/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.config.builder;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.pac4j.config.builder.AbstractBuilder;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.password.PasswordEncoder;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.sql.profile.service.DbProfileService;

public class DbAuthenticatorBuilder
extends AbstractBuilder {
    public DbAuthenticatorBuilder(Map<String, String> properties) {
        super(properties);
    }

    public void tryBuildDbAuthenticator(Map<String, Authenticator> authenticators, Map<String, PasswordEncoder> encoders) {
        for (int i = 0; i <= 10; ++i) {
            if (!this.containsProperty("db.dataSourceClassName", i) && !this.containsProperty("db.jdbcUrl", i)) continue;
            try {
                DataSource ds = this.buildDataSource(i);
                DbProfileService authenticator = new DbProfileService(ds);
                if (this.containsProperty("db.userAttributes", i)) {
                    authenticator.setAttributes(this.getProperty("db.userAttributes", i));
                }
                if (this.containsProperty("db.userIdAttribute", i)) {
                    authenticator.setIdAttribute(this.getProperty("db.userIdAttribute", i));
                }
                if (this.containsProperty("db.usernameAttribute", i)) {
                    authenticator.setUsernameAttribute(this.getProperty("db.usernameAttribute", i));
                }
                if (this.containsProperty("db.userPasswordAttribute", i)) {
                    authenticator.setPasswordAttribute(this.getProperty("db.userPasswordAttribute", i));
                }
                if (this.containsProperty("db.usersTable", i)) {
                    authenticator.setUsersTable(this.getProperty("db.usersTable", i));
                }
                if (this.containsProperty("db.passwordEncoder", i)) {
                    authenticator.setPasswordEncoder(encoders.get(this.getProperty("db.passwordEncoder", i)));
                }
                authenticators.put(this.concat("db", i), (Authenticator)authenticator);
                continue;
            }
            catch (SQLException e) {
                throw new TechnicalException((Throwable)e);
            }
        }
    }

    private DataSource buildDataSource(int i) throws SQLException {
        HikariDataSource ds = new HikariDataSource();
        if (this.containsProperty("db.dataSourceClassName", i)) {
            ds.setDataSourceClassName(this.getProperty("db.dataSourceClassName", i));
        } else if (this.containsProperty("db.jdbcUrl", i)) {
            ds.setJdbcUrl(this.getProperty("db.jdbcUrl", i));
        }
        if (this.containsProperty("db.username", i)) {
            ds.setUsername(this.getProperty("db.username", i));
        }
        if (this.containsProperty("db.password", i)) {
            ds.setPassword(this.getProperty("db.password", i));
        }
        if (this.containsProperty("db.autoCommit", i)) {
            ds.setAutoCommit(this.getPropertyAsBoolean("db.autoCommit", i));
        }
        if (this.containsProperty("db.connectionTimeout", i)) {
            ds.setConnectionTimeout(this.getPropertyAsLong("db.connectionTimeout", i));
        }
        if (this.containsProperty("db.idleTimeout", i)) {
            ds.setIdleTimeout(this.getPropertyAsLong("db.idleTimeout", i));
        }
        if (this.containsProperty("db.maxLifetime", i)) {
            ds.setMaxLifetime(this.getPropertyAsLong("db.maxLifetime", i));
        }
        if (this.containsProperty("db.connectionTestQuery", i)) {
            ds.setConnectionTestQuery(this.getProperty("db.connectionTestQuery", i));
        }
        if (this.containsProperty("db.minimumIdle", i)) {
            ds.setMinimumIdle(this.getPropertyAsInteger("db.minimumIdle", i));
        }
        if (this.containsProperty("db.maximumPoolSize", i)) {
            ds.setMaximumPoolSize(this.getPropertyAsInteger("db.maximumPoolSize", i));
        }
        if (this.containsProperty("db.poolName", i)) {
            ds.setPoolName(this.getProperty("db.poolName", i));
        }
        if (this.containsProperty("db.initializationFailTimeout", i)) {
            ds.setInitializationFailTimeout(this.getPropertyAsLong("db.initializationFailTimeout", i));
        }
        if (this.containsProperty("db.isolateInternalQueries", i)) {
            ds.setIsolateInternalQueries(this.getPropertyAsBoolean("db.isolateInternalQueries", i));
        }
        if (this.containsProperty("db.allowPoolSuspension", i)) {
            ds.setAllowPoolSuspension(this.getPropertyAsBoolean("db.allowPoolSuspension", i));
        }
        if (this.containsProperty("db.readOnly", i)) {
            ds.setReadOnly(this.getPropertyAsBoolean("db.readOnly", i));
        }
        if (this.containsProperty("db.registerMbeans", i)) {
            ds.setRegisterMbeans(this.getPropertyAsBoolean("db.registerMbeans", i));
        }
        if (this.containsProperty("db.catalog", i)) {
            ds.setCatalog(this.getProperty("db.catalog", i));
        }
        if (this.containsProperty("db.connectionInitSql", i)) {
            ds.setConnectionInitSql(this.getProperty("db.connectionInitSql", i));
        }
        if (this.containsProperty("db.driverClassName", i)) {
            ds.setDriverClassName(this.getProperty("db.driverClassName", i));
        }
        if (this.containsProperty("db.transactionIsolation", i)) {
            ds.setTransactionIsolation(this.getProperty("db.transactionIsolation", i));
        }
        if (this.containsProperty("db.validationTimeout", i)) {
            ds.setValidationTimeout(this.getPropertyAsLong("db.validationTimeout", i));
        }
        if (this.containsProperty("db.leakDetectionThreshold", i)) {
            ds.setLeakDetectionThreshold(this.getPropertyAsLong("db.leakDetectionThreshold", i));
        }
        for (int j = 1; j <= 5; ++j) {
            if (!this.containsProperty("db.customParamKey" + j, i)) continue;
            ds.addDataSourceProperty(this.getProperty("db.customParamKey" + j, i), (Object)this.getProperty("db.customParamValue" + j, i));
        }
        if (this.containsProperty("db.loginTimeout", i)) {
            ds.setLoginTimeout(this.getPropertyAsInteger("db.loginTimeout", i));
        }
        if (this.containsProperty("db.dataSourceJndi", i)) {
            ds.setDataSourceJNDI(this.getProperty("db.dataSourceJndi", i));
        }
        return ds;
    }
}

