"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const filtered_1 = require("./filtered");
const interface_1 = require("./interface");
const virtual_1 = require("./virtual");
function empty() { return new virtual_1.VirtualTree(); }
exports.empty = empty;
function branch(tree) {
    return virtual_1.VirtualTree.branch(tree);
}
exports.branch = branch;
function merge(tree, other, strategy = interface_1.MergeStrategy.Default) {
    return virtual_1.VirtualTree.merge(tree, other, strategy);
}
exports.merge = merge;
function partition(tree, predicate) {
    return [
        new filtered_1.FilteredTree(tree, predicate),
        new filtered_1.FilteredTree(tree, (path, entry) => !predicate(path, entry)),
    ];
}
exports.partition = partition;
function optimize(tree) {
    return virtual_1.VirtualTree.optimize(tree);
}
exports.optimize = optimize;
//# sourceMappingURL=data:application/json;base64,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