/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiClusterTemplateClusterSpec;
import com.cloudera.api.swagger.model.ApiClusterTemplateHostInfo;
import com.cloudera.api.swagger.model.ApiClusterTemplateRoleConfigGroupInfo;
import com.cloudera.api.swagger.model.ApiClusterTemplateVariable;
import com.cloudera.api.swagger.model.ApiConfigureForKerberosArguments;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Details of cluster template")
public class ApiClusterTemplateInstantiator {
    @SerializedName(value="clusterName")
    private String clusterName = null;
    @SerializedName(value="hosts")
    private List<ApiClusterTemplateHostInfo> hosts = null;
    @SerializedName(value="variables")
    private List<ApiClusterTemplateVariable> variables = null;
    @SerializedName(value="roleConfigGroups")
    private List<ApiClusterTemplateRoleConfigGroupInfo> roleConfigGroups = null;
    @SerializedName(value="clusterSpec")
    private ApiClusterTemplateClusterSpec clusterSpec = null;
    @SerializedName(value="keepHostTemplates")
    private Boolean keepHostTemplates = null;
    @SerializedName(value="enableKerberos")
    private ApiConfigureForKerberosArguments enableKerberos = null;

    public ApiClusterTemplateInstantiator clusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    @ApiModelProperty(value="Cluster name")
    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public ApiClusterTemplateInstantiator hosts(List<ApiClusterTemplateHostInfo> hosts) {
        this.hosts = hosts;
        return this;
    }

    public ApiClusterTemplateInstantiator addHostsItem(ApiClusterTemplateHostInfo hostsItem) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<ApiClusterTemplateHostInfo>();
        }
        this.hosts.add(hostsItem);
        return this;
    }

    @ApiModelProperty(value="All the hosts that are part of that cluster")
    public List<ApiClusterTemplateHostInfo> getHosts() {
        return this.hosts;
    }

    public void setHosts(List<ApiClusterTemplateHostInfo> hosts) {
        this.hosts = hosts;
    }

    public ApiClusterTemplateInstantiator variables(List<ApiClusterTemplateVariable> variables) {
        this.variables = variables;
        return this;
    }

    public ApiClusterTemplateInstantiator addVariablesItem(ApiClusterTemplateVariable variablesItem) {
        if (this.variables == null) {
            this.variables = new ArrayList<ApiClusterTemplateVariable>();
        }
        this.variables.add(variablesItem);
        return this;
    }

    @ApiModelProperty(value="All the variables the are referred by the cluster template")
    public List<ApiClusterTemplateVariable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<ApiClusterTemplateVariable> variables) {
        this.variables = variables;
    }

    public ApiClusterTemplateInstantiator roleConfigGroups(List<ApiClusterTemplateRoleConfigGroupInfo> roleConfigGroups) {
        this.roleConfigGroups = roleConfigGroups;
        return this;
    }

    public ApiClusterTemplateInstantiator addRoleConfigGroupsItem(ApiClusterTemplateRoleConfigGroupInfo roleConfigGroupsItem) {
        if (this.roleConfigGroups == null) {
            this.roleConfigGroups = new ArrayList<ApiClusterTemplateRoleConfigGroupInfo>();
        }
        this.roleConfigGroups.add(roleConfigGroupsItem);
        return this;
    }

    @ApiModelProperty(value="All the role config group informations for non-base RCGs.")
    public List<ApiClusterTemplateRoleConfigGroupInfo> getRoleConfigGroups() {
        return this.roleConfigGroups;
    }

    public void setRoleConfigGroups(List<ApiClusterTemplateRoleConfigGroupInfo> roleConfigGroups) {
        this.roleConfigGroups = roleConfigGroups;
    }

    public ApiClusterTemplateInstantiator clusterSpec(ApiClusterTemplateClusterSpec clusterSpec) {
        this.clusterSpec = clusterSpec;
        return this;
    }

    @ApiModelProperty(value="Cluster specification.")
    public ApiClusterTemplateClusterSpec getClusterSpec() {
        return this.clusterSpec;
    }

    public void setClusterSpec(ApiClusterTemplateClusterSpec clusterSpec) {
        this.clusterSpec = clusterSpec;
    }

    public ApiClusterTemplateInstantiator keepHostTemplates(Boolean keepHostTemplates) {
        this.keepHostTemplates = keepHostTemplates;
        return this;
    }

    @ApiModelProperty(value="Keep the hosts templates from cluster template.")
    public Boolean getKeepHostTemplates() {
        return this.keepHostTemplates;
    }

    public void setKeepHostTemplates(Boolean keepHostTemplates) {
        this.keepHostTemplates = keepHostTemplates;
    }

    public ApiClusterTemplateInstantiator enableKerberos(ApiConfigureForKerberosArguments enableKerberos) {
        this.enableKerberos = enableKerberos;
        return this;
    }

    @ApiModelProperty(value="Enable kerberos authentication")
    public ApiConfigureForKerberosArguments getEnableKerberos() {
        return this.enableKerberos;
    }

    public void setEnableKerberos(ApiConfigureForKerberosArguments enableKerberos) {
        this.enableKerberos = enableKerberos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiClusterTemplateInstantiator apiClusterTemplateInstantiator = (ApiClusterTemplateInstantiator)o;
        return Objects.equals(this.clusterName, apiClusterTemplateInstantiator.clusterName) && Objects.equals(this.hosts, apiClusterTemplateInstantiator.hosts) && Objects.equals(this.variables, apiClusterTemplateInstantiator.variables) && Objects.equals(this.roleConfigGroups, apiClusterTemplateInstantiator.roleConfigGroups) && Objects.equals(this.clusterSpec, apiClusterTemplateInstantiator.clusterSpec) && Objects.equals(this.keepHostTemplates, apiClusterTemplateInstantiator.keepHostTemplates) && Objects.equals(this.enableKerberos, apiClusterTemplateInstantiator.enableKerberos);
    }

    public int hashCode() {
        return Objects.hash(this.clusterName, this.hosts, this.variables, this.roleConfigGroups, this.clusterSpec, this.keepHostTemplates, this.enableKerberos);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiClusterTemplateInstantiator {\n");
        sb.append("    clusterName: ").append(this.toIndentedString(this.clusterName)).append("\n");
        sb.append("    hosts: ").append(this.toIndentedString(this.hosts)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    roleConfigGroups: ").append(this.toIndentedString(this.roleConfigGroups)).append("\n");
        sb.append("    clusterSpec: ").append(this.toIndentedString(this.clusterSpec)).append("\n");
        sb.append("    keepHostTemplates: ").append(this.toIndentedString(this.keepHostTemplates)).append("\n");
        sb.append("    enableKerberos: ").append(this.toIndentedString(this.enableKerberos)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

