/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.impala;

import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.knox.gateway.security.SubjectUtils;

public class ImpalaDispatchUtils {
    private static final String PASSWORD_PLACEHOLDER = "*";

    public static void addCredentialsToRequest(HttpUriRequest request) {
        String principal = SubjectUtils.getCurrentEffectivePrincipalName();
        if (principal != null) {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(principal, PASSWORD_PLACEHOLDER);
            try {
                request.addHeader(new BasicScheme().authenticate((Credentials)credentials, (HttpRequest)request, null));
            }
            catch (AuthenticationException authenticationException) {
                // empty catch block
            }
        }
    }
}

