/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.util.Arrays;
import org.ldaptive.LdapUtils;
import org.ldaptive.ResponseMessage;
import org.ldaptive.ResultCode;
import org.ldaptive.control.ResponseControl;

public class Response<T>
implements ResponseMessage {
    public static final String ENCODE_CNTRL_CHARS = "org.ldaptive.response.encodeCntrlChars";
    protected static boolean encodeCntrlChars;
    private final T result;
    private final ResultCode resultCode;
    private final String message;
    private final String matchedDn;
    private final ResponseControl[] responseControls;
    private final String[] referralURLs;
    private final int messageId;

    public Response(T t, ResultCode rc) {
        this.result = t;
        this.resultCode = rc;
        this.message = null;
        this.matchedDn = null;
        this.responseControls = null;
        this.referralURLs = null;
        this.messageId = -1;
    }

    public Response(T t, ResultCode rc, String msg, String dn, ResponseControl[] c, String[] urls, int id) {
        this.result = t;
        this.resultCode = rc;
        this.message = msg;
        this.matchedDn = dn;
        this.responseControls = c;
        this.referralURLs = urls;
        this.messageId = id;
    }

    public T getResult() {
        return this.result;
    }

    public ResultCode getResultCode() {
        return this.resultCode;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMatchedDn() {
        return this.matchedDn;
    }

    public ResponseControl[] getControls() {
        return this.responseControls;
    }

    @Override
    public ResponseControl getControl(String oid) {
        if (this.getControls() != null) {
            for (ResponseControl c : this.getControls()) {
                if (!c.getOID().equals(oid)) continue;
                return c;
            }
        }
        return null;
    }

    public String[] getReferralURLs() {
        return this.referralURLs;
    }

    @Override
    public int getMessageId() {
        return this.messageId;
    }

    public String toString() {
        return String.format("[%s@%d::result=%s, resultCode=%s, message=%s, matchedDn=%s, responseControls=%s, referralURLs=%s, messageId=%s]", new Object[]{this.getClass().getName(), this.hashCode(), this.result, this.resultCode, encodeCntrlChars ? LdapUtils.percentEncodeControlChars(this.message) : this.message, this.matchedDn, Arrays.toString(this.responseControls), Arrays.toString(this.referralURLs), this.messageId});
    }

    static {
        String ecc = System.getProperty(ENCODE_CNTRL_CHARS);
        if (ecc != null) {
            encodeCntrlChars = Boolean.valueOf(ecc);
        }
    }
}

