/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.token.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.KeyLengthException;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.knox.gateway.GatewayResources;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.services.security.token.JWTokenAttributes;
import org.apache.knox.gateway.services.security.token.JWTokenAuthority;
import org.apache.knox.gateway.services.security.token.TokenServiceException;
import org.apache.knox.gateway.services.security.token.TokenUtils;
import org.apache.knox.gateway.services.security.token.impl.JWT;
import org.apache.knox.gateway.services.security.token.impl.JWTToken;
import org.apache.knox.gateway.services.token.impl.TokenAuthorityServiceMessages;

public class DefaultTokenAuthorityService
implements JWTokenAuthority,
Service {
    private static final GatewayResources RESOURCES = (GatewayResources)ResourcesFactory.get(GatewayResources.class);
    private static final TokenAuthorityServiceMessages LOG = (TokenAuthorityServiceMessages)MessagesFactory.get(TokenAuthorityServiceMessages.class);
    private static final Set<String> SUPPORTED_PKI_SIG_ALGS = new HashSet<String>(Arrays.asList("RS256", "RS384", "RS512", "PS256", "PS384", "PS512"));
    private static final Set<String> SUPPORTED_HMAC_SIG_ALGS = new HashSet<String>(Arrays.asList("HS256", "HS384", "HS512"));
    private AliasService aliasService;
    private KeystoreService keystoreService;
    private GatewayConfig config;
    private char[] cachedSigningKeyPassphrase;
    private byte[] cachedSigningHmacSecret;
    private RSAPrivateKey signingKey;
    private Optional<String> cachedSigningKeyID = Optional.empty();

    public void setKeystoreService(KeystoreService ks) {
        this.keystoreService = ks;
    }

    public void setAliasService(AliasService as) {
        this.aliasService = as;
    }

    public JWT issueToken(JWTokenAttributes jwtAttributes) throws TokenServiceException {
        JWTToken token;
        String[] claimArray = new String[6];
        claimArray[0] = "KNOXSSO";
        claimArray[1] = jwtAttributes.getPrincipal().getName();
        claimArray[2] = null;
        claimArray[3] = jwtAttributes.getExpires() == -1L ? null : String.valueOf(jwtAttributes.getExpires());
        String algorithm = jwtAttributes.getAlgorithm();
        if (SUPPORTED_HMAC_SIG_ALGS.contains(algorithm)) {
            claimArray[4] = null;
            claimArray[5] = null;
        } else {
            claimArray[4] = this.cachedSigningKeyID.isPresent() ? this.cachedSigningKeyID.get() : null;
            claimArray[5] = jwtAttributes.getJku();
        }
        Object object = token = SUPPORTED_PKI_SIG_ALGS.contains(algorithm) || SUPPORTED_HMAC_SIG_ALGS.contains(algorithm) ? new JWTToken(algorithm, claimArray, jwtAttributes.getAudiences(), jwtAttributes.isManaged()) : null;
        if (token != null) {
            if (SUPPORTED_HMAC_SIG_ALGS.contains(algorithm)) {
                this.signTokenWithHMAC((JWT)token);
            } else {
                this.signTokenWithRSA((JWT)token, jwtAttributes.getSigningKeystoreName(), jwtAttributes.getSigningKeystoreAlias(), jwtAttributes.getSigningKeystorePassphrase());
            }
            return token;
        }
        throw new TokenServiceException("Cannot issue token - Unsupported algorithm: " + algorithm);
    }

    private void signTokenWithRSA(JWT token, String signingKeystoreName, String signingKeystoreAlias, char[] signingKeystorePassphrase) throws TokenServiceException {
        try {
            RSAPrivateKey key = this.getSigningKey(signingKeystoreName, signingKeystoreAlias, signingKeystorePassphrase);
            RSASSASigner signer = new RSASSASigner((PrivateKey)key, true);
            token.sign((JWSSigner)signer);
        }
        catch (KeystoreServiceException e) {
            throw new TokenServiceException((Exception)((Object)e));
        }
    }

    private RSAPrivateKey getSigningKey(String signingKeystoreName, String signingKeystoreAlias, char[] signingKeystorePassphrase) throws KeystoreServiceException, TokenServiceException {
        if (signingKeystorePassphrase != null) {
            return (RSAPrivateKey)this.keystoreService.getSigningKey(signingKeystoreName, this.getSigningKeyAlias(signingKeystoreAlias), this.getSigningKeyPassphrase(signingKeystorePassphrase));
        }
        return this.signingKey;
    }

    private void signTokenWithHMAC(JWT token) throws TokenServiceException {
        try {
            MACSigner signer = new MACSigner(this.getHmacSecret());
            token.sign((JWSSigner)signer);
        }
        catch (KeyLengthException e) {
            throw new TokenServiceException((Exception)((Object)e));
        }
    }

    private byte[] getHmacSecret() throws TokenServiceException {
        if (this.cachedSigningHmacSecret == null) {
            try {
                char[] hmacSecret = this.aliasService.getPasswordFromAliasForGateway("gateway.signing.hmac.secret");
                this.cachedSigningHmacSecret = hmacSecret == null ? null : new String(hmacSecret).getBytes(StandardCharsets.UTF_8);
            }
            catch (AliasServiceException e) {
                throw new TokenServiceException((Exception)((Object)e));
            }
        }
        return this.cachedSigningHmacSecret;
    }

    private char[] getSigningKeyPassphrase(char[] signingKeyPassphrase) {
        return signingKeyPassphrase != null ? signingKeyPassphrase : this.cachedSigningKeyPassphrase;
    }

    private String getSigningKeyAlias() {
        String alias = this.config.getSigningKeyAlias();
        return alias == null ? "gateway-identity" : alias;
    }

    private String getSigningKeyAlias(String signingKeystoreAlias) {
        if (signingKeystoreAlias != null) {
            return signingKeystoreAlias;
        }
        return this.getSigningKeyAlias();
    }

    public boolean verifyToken(JWT token) throws TokenServiceException {
        return this.verifyToken(token, null);
    }

    public boolean verifyToken(JWT token, RSAPublicKey publicKey) throws TokenServiceException {
        String signatureAlgorithm = token.getSignatureAlgorithm().getName();
        return SUPPORTED_HMAC_SIG_ALGS.contains(signatureAlgorithm) ? this.verifyTokenUsingHMAC(token) : this.verifyTokenUsingRSA(token, publicKey);
    }

    private boolean verifyTokenUsingRSA(JWT token, RSAPublicKey publicKey) throws TokenServiceException {
        try {
            PublicKey key = publicKey;
            if (key == null) {
                key = this.keystoreService.getSigningKeystore().getCertificate(this.getSigningKeyAlias()).getPublicKey();
            }
            RSASSAVerifier verifier = new RSASSAVerifier(key);
            return token.verify((JWSVerifier)verifier);
        }
        catch (KeyStoreException | KeystoreServiceException e) {
            throw new TokenServiceException("Cannot verify token.", (Exception)e);
        }
    }

    private boolean verifyTokenUsingHMAC(JWT token) throws TokenServiceException {
        try {
            MACVerifier verifier = new MACVerifier(this.getHmacSecret());
            return token.verify((JWSVerifier)verifier);
        }
        catch (JOSEException e) {
            throw new TokenServiceException("Cannot verify token.", (Exception)((Object)e));
        }
    }

    public boolean verifyToken(JWT token, String jwksurl, String algorithm) throws TokenServiceException {
        boolean verified = false;
        try {
            if (algorithm != null && jwksurl != null) {
                JWSAlgorithm expectedJWSAlg = JWSAlgorithm.parse((String)algorithm);
                RemoteJWKSet keySource = new RemoteJWKSet(new URL(jwksurl));
                JWSVerificationKeySelector keySelector = new JWSVerificationKeySelector(expectedJWSAlg, (JWKSource)keySource);
                DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
                jwtProcessor.setJWSKeySelector((JWSKeySelector)keySelector);
                DefaultJWTClaimsVerifier claimsVerifier = new DefaultJWTClaimsVerifier();
                jwtProcessor.setJWTClaimsSetVerifier((JWTClaimsSetVerifier)claimsVerifier);
                SecurityContext ctx = null;
                jwtProcessor.process(token.toString(), ctx);
                verified = true;
            }
        }
        catch (JOSEException | BadJOSEException | MalformedURLException | ParseException e) {
            throw new TokenServiceException("Cannot verify token.", (Exception)e);
        }
        return verified;
    }

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        if (this.aliasService == null || this.keystoreService == null) {
            throw new ServiceLifecycleException("Alias or Keystore service is not set");
        }
        this.config = config;
    }

    public void start() throws ServiceLifecycleException {
        KeyStore keystore;
        try {
            keystore = this.keystoreService.getSigningKeystore();
            if (keystore == null) {
                throw new ServiceLifecycleException(RESOURCES.signingKeystoreNotAvailable(this.config.getSigningKeystorePath()));
            }
        }
        catch (KeystoreServiceException e) {
            throw new ServiceLifecycleException(RESOURCES.signingKeystoreNotAvailable(this.config.getSigningKeystorePath()), (Exception)((Object)e));
        }
        try {
            this.cachedSigningKeyPassphrase = this.aliasService.getSigningKeyPassphrase();
            if (this.cachedSigningKeyPassphrase == null) {
                throw new ServiceLifecycleException(RESOURCES.signingKeyPassphraseNotAvailable(this.config.getSigningKeyPassphraseAlias()));
            }
        }
        catch (AliasServiceException e) {
            throw new ServiceLifecycleException(RESOURCES.signingKeyPassphraseNotAvailable(this.config.getSigningKeyPassphraseAlias()), (Exception)((Object)e));
        }
        String signingKeyAlias = this.getSigningKeyAlias();
        try {
            Certificate certificate = keystore.getCertificate(signingKeyAlias);
            if (certificate == null) {
                throw new ServiceLifecycleException(RESOURCES.publicSigningKeyNotFound(signingKeyAlias));
            }
            PublicKey publicKey = certificate.getPublicKey();
            if (publicKey == null) {
                throw new ServiceLifecycleException(RESOURCES.publicSigningKeyNotFound(signingKeyAlias));
            }
            if (!(publicKey instanceof RSAPublicKey)) {
                throw new ServiceLifecycleException(RESOURCES.publicSigningKeyWrongType(signingKeyAlias));
            }
            this.cachedSigningKeyID = Optional.of(TokenUtils.getThumbprint((RSAPublicKey)((RSAPublicKey)publicKey), (String)"SHA-256"));
        }
        catch (KeyStoreException e) {
            throw new ServiceLifecycleException(RESOURCES.publicSigningKeyNotFound(signingKeyAlias), (Exception)e);
        }
        catch (JOSEException e) {
            LOG.errorGettingKid(e.toString());
            this.cachedSigningKeyID = Optional.empty();
        }
        try {
            Key key = keystore.getKey(signingKeyAlias, this.cachedSigningKeyPassphrase);
            if (key == null) {
                throw new ServiceLifecycleException(RESOURCES.privateSigningKeyNotFound(signingKeyAlias));
            }
            if (!(key instanceof RSAPrivateKey)) {
                throw new ServiceLifecycleException(RESOURCES.privateSigningKeyWrongType(signingKeyAlias));
            }
            this.signingKey = (RSAPrivateKey)key;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new ServiceLifecycleException(RESOURCES.privateSigningKeyNotFound(signingKeyAlias), (Exception)e);
        }
    }

    public void stop() throws ServiceLifecycleException {
    }

    protected Optional<String> getCachedSigningKeyID() {
        return this.cachedSigningKeyID;
    }
}

