/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.ambari;

import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.topology.ClusterConfigurationMonitorService;
import org.apache.knox.gateway.topology.discovery.ClusterConfigurationMonitor;
import org.apache.knox.gateway.topology.discovery.GatewayService;
import org.apache.knox.gateway.topology.discovery.ServiceDiscovery;
import org.apache.knox.gateway.topology.discovery.ServiceDiscoveryConfig;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariClientCommon;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariCluster;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariComponent;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariConfigurationMonitor;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariServiceDiscoveryMessages;
import org.apache.knox.gateway.topology.discovery.ambari.RESTInvoker;

class AmbariServiceDiscovery
implements ServiceDiscovery {
    static final String TYPE = "Ambari";
    static final String AMBARI_CLUSTERS_URI = "/api/v1/clusters";
    static final String AMBARI_HOSTROLES_URI = "/api/v1/clusters/%s/services?fields=components/host_components/HostRoles";
    static final String AMBARI_SERVICECONFIGS_URI = "/api/v1/clusters/%s/configurations/service_config_versions?is_current=true";
    static final String COMPONENT_CONFIG_MAPPING_SYSTEM_PROPERTY = "org.apache.knox.gateway.topology.discovery.ambari.component.mapping";
    private static final String COMPONENT_CONFIG_MAPPING_FILE = "ambari-service-discovery-component-config-mapping.properties";
    private static final String COMPONENT_CONFIG_OVERRIDES_FILENAME = "ambari-discovery-component-config.properties";
    private static final String GATEWAY_SERVICES_ACCESSOR_CLASS = "org.apache.knox.gateway.GatewayServer";
    private static final String GATEWAY_SERVICES_ACCESSOR_METHOD = "getGatewayServices";
    private static final AmbariServiceDiscoveryMessages log = (AmbariServiceDiscoveryMessages)MessagesFactory.get(AmbariServiceDiscoveryMessages.class);
    private static Map<String, String> componentServiceConfigs = new HashMap<String, String>();
    @GatewayService
    private AliasService aliasService;
    @GatewayService
    private KeystoreService keystoreService;
    private RESTInvoker restClient;
    private AmbariClientCommon ambariClient;
    private AmbariConfigurationMonitor configChangeMonitor;
    private boolean isInitialized;

    static void initializeComponentConfigMappings() {
        block18: {
            try {
                File overridesFile;
                componentServiceConfigs.clear();
                Properties configMapping = new Properties();
                configMapping.load(AmbariServiceDiscovery.class.getClassLoader().getResourceAsStream(COMPONENT_CONFIG_MAPPING_FILE));
                for (String componentName : configMapping.stringPropertyNames()) {
                    componentServiceConfigs.put(componentName, configMapping.getProperty(componentName));
                }
                String overridesPath = null;
                String gatewayConfDir = System.getProperty("org.apache.knox.gateway.conf.dir");
                if (gatewayConfDir != null && (overridesFile = new File(gatewayConfDir, COMPONENT_CONFIG_OVERRIDES_FILENAME)).exists()) {
                    overridesPath = overridesFile.getAbsolutePath();
                }
                if (overridesPath == null) {
                    overridesPath = System.getProperty(COMPONENT_CONFIG_MAPPING_SYSTEM_PROPERTY);
                }
                if (overridesPath == null) break block18;
                Properties overrides = new Properties();
                try (InputStream in = Files.newInputStream(Paths.get(overridesPath, new String[0]), new OpenOption[0]);){
                    overrides.load(in);
                    for (String name : overrides.stringPropertyNames()) {
                        componentServiceConfigs.put(name, overrides.getProperty(name));
                    }
                }
            }
            catch (Exception e) {
                log.failedToLoadServiceDiscoveryURLDefConfiguration(COMPONENT_CONFIG_MAPPING_FILE, e);
            }
        }
    }

    AmbariServiceDiscovery() {
    }

    AmbariServiceDiscovery(RESTInvoker restClient) {
        this.restClient = restClient;
    }

    private void init(GatewayConfig config) {
        if (!this.isInitialized) {
            if (this.restClient == null) {
                this.restClient = new RESTInvoker(config, this.aliasService, this.keystoreService);
            }
            this.ambariClient = new AmbariClientCommon(this.restClient);
            this.configChangeMonitor = this.getConfigurationChangeMonitor();
            this.isInitialized = true;
        }
    }

    private AmbariConfigurationMonitor getConfigurationChangeMonitor() {
        AmbariConfigurationMonitor ambariMonitor = null;
        try {
            ClusterConfigurationMonitorService clusterMonitorService;
            ClusterConfigurationMonitor monitor;
            Object obj;
            Method m;
            Class<?> clazz = Class.forName(GATEWAY_SERVICES_ACCESSOR_CLASS);
            if (clazz != null && (m = clazz.getDeclaredMethod(GATEWAY_SERVICES_ACCESSOR_METHOD, new Class[0])) != null && GatewayServices.class.isAssignableFrom((obj = m.invoke(null, new Object[0])).getClass()) && (monitor = (clusterMonitorService = (ClusterConfigurationMonitorService)((GatewayServices)obj).getService(ServiceType.CLUSTER_CONFIGURATION_MONITOR_SERVICE)).getMonitor(AmbariConfigurationMonitor.getType())) != null && AmbariConfigurationMonitor.class.isAssignableFrom(monitor.getClass())) {
                ambariMonitor = (AmbariConfigurationMonitor)monitor;
            }
        }
        catch (Exception e) {
            log.errorAccessingConfigurationChangeMonitor(e);
        }
        return ambariMonitor;
    }

    public String getType() {
        return TYPE;
    }

    public Map<String, ServiceDiscovery.Cluster> discover(GatewayConfig gatewayConfig, ServiceDiscoveryConfig discoveryConfig) {
        HashMap<String, ServiceDiscovery.Cluster> clusters = new HashMap<String, ServiceDiscovery.Cluster>();
        this.init(gatewayConfig);
        String discoveryAddress = discoveryConfig.getAddress();
        String clustersDiscoveryURL = String.format(Locale.ROOT, "%s/api/v1/clusters", discoveryAddress);
        JSONObject json = this.restClient.invoke(clustersDiscoveryURL, discoveryConfig.getUser(), discoveryConfig.getPasswordAlias());
        JSONArray clusterItems = (JSONArray)json.get((Object)"items");
        for (Object clusterItem : clusterItems) {
            String clusterName = (String)((JSONObject)((JSONObject)clusterItem).get((Object)"Clusters")).get((Object)"cluster_name");
            try {
                ServiceDiscovery.Cluster c = this.discover(gatewayConfig, discoveryConfig, clusterName);
                clusters.put(clusterName, c);
            }
            catch (Exception e) {
                log.clusterDiscoveryError(clusterName, e);
            }
        }
        return clusters;
    }

    public ServiceDiscovery.Cluster discover(GatewayConfig gatewayConfig, ServiceDiscoveryConfig config, String clusterName) {
        AmbariCluster cluster = null;
        String discoveryAddress = config.getAddress();
        String discoveryUser = config.getUser();
        String discoveryPwdAlias = config.getPasswordAlias();
        if ((discoveryAddress == null || discoveryAddress.isEmpty()) && (discoveryAddress = gatewayConfig.getDefaultDiscoveryAddress()) == null) {
            log.missingDiscoveryAddress();
        }
        if ((clusterName == null || clusterName.isEmpty()) && (clusterName = gatewayConfig.getDefaultDiscoveryCluster()) == null) {
            log.missingDiscoveryCluster();
        }
        if (discoveryAddress != null && clusterName != null) {
            Map<String, Map<String, AmbariCluster.ServiceConfiguration>> serviceConfigurations;
            String encodedClusterName;
            cluster = new AmbariCluster(clusterName);
            try {
                encodedClusterName = URLEncoder.encode(clusterName, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                encodedClusterName = clusterName;
            }
            HashMap<String, String> serviceComponents = new HashMap<String, String>();
            this.init(gatewayConfig);
            HashMap componentHostNames = new HashMap();
            String hostRolesURL = String.format(Locale.ROOT, "%s/api/v1/clusters/%s/services?fields=components/host_components/HostRoles", discoveryAddress, encodedClusterName);
            JSONObject hostRolesJSON = this.restClient.invoke(hostRolesURL, discoveryUser, discoveryPwdAlias);
            if (hostRolesJSON != null) {
                JSONArray items = (JSONArray)hostRolesJSON.get((Object)"items");
                for (Object e : items) {
                    JSONArray components = (JSONArray)((JSONObject)e).get((Object)"components");
                    Iterator iterator = components.iterator();
                    while (iterator.hasNext()) {
                        Object component = iterator.next();
                        JSONArray hostComponents = (JSONArray)((JSONObject)component).get((Object)"host_components");
                        for (Object hostComponent : hostComponents) {
                            JSONObject hostRoles = (JSONObject)((JSONObject)hostComponent).get((Object)"HostRoles");
                            String serviceName = (String)hostRoles.get((Object)"service_name");
                            String componentName = (String)hostRoles.get((Object)"component_name");
                            serviceComponents.put(componentName, serviceName);
                            String hostName = (String)hostRoles.get((Object)"public_host_name");
                            if (hostName == null) {
                                hostName = (String)hostRoles.get((Object)"host_name");
                            }
                            if (hostName == null) continue;
                            log.discoveredServiceHost(serviceName, hostName);
                            if (!componentHostNames.containsKey(componentName)) {
                                componentHostNames.put(componentName, new ArrayList());
                            }
                            if (((List)componentHostNames.get(componentName)).contains(hostName)) continue;
                            ((List)componentHostNames.get(componentName)).add(hostName);
                        }
                    }
                }
            }
            if ((serviceConfigurations = this.ambariClient.getActiveServiceConfigurations(discoveryAddress, encodedClusterName, discoveryUser, discoveryPwdAlias)).isEmpty()) {
                log.failedToAccessServiceConfigs(clusterName);
            }
            for (Map.Entry<String, Map<String, AmbariCluster.ServiceConfiguration>> entry : serviceConfigurations.entrySet()) {
                for (Map.Entry entry2 : entry.getValue().entrySet()) {
                    cluster.addServiceConfiguration(entry.getKey(), (String)entry2.getKey(), (AmbariCluster.ServiceConfiguration)entry2.getValue());
                }
            }
            for (Map.Entry<String, Map<String, AmbariCluster.ServiceConfiguration>> entry : serviceComponents.entrySet()) {
                AmbariCluster.ServiceConfiguration svcConfig;
                String componentName = entry.getKey();
                String string = (String)((Object)entry.getValue());
                List hostNames = (List)componentHostNames.get(componentName);
                Map<String, AmbariCluster.ServiceConfiguration> configs = serviceConfigurations.get(string);
                String configType = componentServiceConfigs.get(componentName);
                if (configType == null || (svcConfig = configs.get(configType)) == null) continue;
                AmbariComponent c = new AmbariComponent(componentName, svcConfig.getVersion(), encodedClusterName, string, hostNames, svcConfig.getProperties());
                cluster.addComponent(c);
            }
            if (this.configChangeMonitor != null) {
                this.configChangeMonitor.addClusterConfigVersions(cluster, config);
            }
        }
        return cluster;
    }

    static {
        AmbariServiceDiscovery.initializeComponentConfigMappings();
    }
}

