/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiServiceRef;
import com.cloudera.api.swagger.model.ReplicationStrategy;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Replication arguments for HDFS.")
public class ApiHdfsCloudReplicationArguments {
    @SerializedName(value="sourceService")
    private ApiServiceRef sourceService = null;
    @SerializedName(value="sourcePath")
    private String sourcePath = null;
    @SerializedName(value="destinationPath")
    private String destinationPath = null;
    @SerializedName(value="mapreduceServiceName")
    private String mapreduceServiceName = null;
    @SerializedName(value="schedulerPoolName")
    private String schedulerPoolName = null;
    @SerializedName(value="userName")
    private String userName = null;
    @SerializedName(value="sourceUser")
    private String sourceUser = null;
    @SerializedName(value="numMaps")
    private BigDecimal numMaps = null;
    @SerializedName(value="dryRun")
    private Boolean dryRun = null;
    @SerializedName(value="bandwidthPerMap")
    private BigDecimal bandwidthPerMap = null;
    @SerializedName(value="abortOnError")
    private Boolean abortOnError = null;
    @SerializedName(value="removeMissingFiles")
    private Boolean removeMissingFiles = null;
    @SerializedName(value="preserveReplicationCount")
    private Boolean preserveReplicationCount = null;
    @SerializedName(value="preserveBlockSize")
    private Boolean preserveBlockSize = null;
    @SerializedName(value="preservePermissions")
    private Boolean preservePermissions = null;
    @SerializedName(value="logPath")
    private String logPath = null;
    @SerializedName(value="skipChecksumChecks")
    private Boolean skipChecksumChecks = null;
    @SerializedName(value="skipListingChecksumChecks")
    private Boolean skipListingChecksumChecks = null;
    @SerializedName(value="skipTrash")
    private Boolean skipTrash = null;
    @SerializedName(value="replicationStrategy")
    private ReplicationStrategy replicationStrategy = null;
    @SerializedName(value="preserveXAttrs")
    private Boolean preserveXAttrs = null;
    @SerializedName(value="exclusionFilters")
    private List<String> exclusionFilters = null;
    @SerializedName(value="raiseSnapshotDiffFailures")
    private Boolean raiseSnapshotDiffFailures = null;
    @SerializedName(value="destinationCloudAccount")
    private String destinationCloudAccount = null;
    @SerializedName(value="sourceAccount")
    private String sourceAccount = null;
    @SerializedName(value="destinationAccount")
    private String destinationAccount = null;

    public ApiHdfsCloudReplicationArguments sourceService(ApiServiceRef sourceService) {
        this.sourceService = sourceService;
        return this;
    }

    @ApiModelProperty(value="The service to replicate from.")
    public ApiServiceRef getSourceService() {
        return this.sourceService;
    }

    public void setSourceService(ApiServiceRef sourceService) {
        this.sourceService = sourceService;
    }

    public ApiHdfsCloudReplicationArguments sourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
        return this;
    }

    @ApiModelProperty(value="The path to replicate.")
    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public ApiHdfsCloudReplicationArguments destinationPath(String destinationPath) {
        this.destinationPath = destinationPath;
        return this;
    }

    @ApiModelProperty(value="The destination to replicate to.")
    public String getDestinationPath() {
        return this.destinationPath;
    }

    public void setDestinationPath(String destinationPath) {
        this.destinationPath = destinationPath;
    }

    public ApiHdfsCloudReplicationArguments mapreduceServiceName(String mapreduceServiceName) {
        this.mapreduceServiceName = mapreduceServiceName;
        return this;
    }

    @ApiModelProperty(value="The mapreduce service to use for the replication job.")
    public String getMapreduceServiceName() {
        return this.mapreduceServiceName;
    }

    public void setMapreduceServiceName(String mapreduceServiceName) {
        this.mapreduceServiceName = mapreduceServiceName;
    }

    public ApiHdfsCloudReplicationArguments schedulerPoolName(String schedulerPoolName) {
        this.schedulerPoolName = schedulerPoolName;
        return this;
    }

    @ApiModelProperty(value="Name of the scheduler pool to use when submitting the MapReduce job. Currently supports the capacity and fair schedulers. The option is ignored if a different scheduler is configured.")
    public String getSchedulerPoolName() {
        return this.schedulerPoolName;
    }

    public void setSchedulerPoolName(String schedulerPoolName) {
        this.schedulerPoolName = schedulerPoolName;
    }

    public ApiHdfsCloudReplicationArguments userName(String userName) {
        this.userName = userName;
        return this;
    }

    @ApiModelProperty(value="The user which will execute the MapReduce job. Required if running with Kerberos enabled.")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public ApiHdfsCloudReplicationArguments sourceUser(String sourceUser) {
        this.sourceUser = sourceUser;
        return this;
    }

    @ApiModelProperty(value="The user which will perform operations on source cluster. Required if running with Kerberos enabled.")
    public String getSourceUser() {
        return this.sourceUser;
    }

    public void setSourceUser(String sourceUser) {
        this.sourceUser = sourceUser;
    }

    public ApiHdfsCloudReplicationArguments numMaps(BigDecimal numMaps) {
        this.numMaps = numMaps;
        return this;
    }

    @ApiModelProperty(value="The number of mappers to use for the mapreduce replication job.")
    public BigDecimal getNumMaps() {
        return this.numMaps;
    }

    public void setNumMaps(BigDecimal numMaps) {
        this.numMaps = numMaps;
    }

    public ApiHdfsCloudReplicationArguments dryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    @ApiModelProperty(value="Whether to perform a dry run. Defaults to false.")
    public Boolean getDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public ApiHdfsCloudReplicationArguments bandwidthPerMap(BigDecimal bandwidthPerMap) {
        this.bandwidthPerMap = bandwidthPerMap;
        return this;
    }

    @ApiModelProperty(value="The maximum bandwidth (in MB) per mapper in the mapreduce replication job.")
    public BigDecimal getBandwidthPerMap() {
        return this.bandwidthPerMap;
    }

    public void setBandwidthPerMap(BigDecimal bandwidthPerMap) {
        this.bandwidthPerMap = bandwidthPerMap;
    }

    public ApiHdfsCloudReplicationArguments abortOnError(Boolean abortOnError) {
        this.abortOnError = abortOnError;
        return this;
    }

    @ApiModelProperty(value="Whether to abort on a replication failure. Defaults to false.")
    public Boolean getAbortOnError() {
        return this.abortOnError;
    }

    public void setAbortOnError(Boolean abortOnError) {
        this.abortOnError = abortOnError;
    }

    public ApiHdfsCloudReplicationArguments removeMissingFiles(Boolean removeMissingFiles) {
        this.removeMissingFiles = removeMissingFiles;
        return this;
    }

    @ApiModelProperty(value="Whether to delete destination files that are missing in source. Defaults to false.")
    public Boolean getRemoveMissingFiles() {
        return this.removeMissingFiles;
    }

    public void setRemoveMissingFiles(Boolean removeMissingFiles) {
        this.removeMissingFiles = removeMissingFiles;
    }

    public ApiHdfsCloudReplicationArguments preserveReplicationCount(Boolean preserveReplicationCount) {
        this.preserveReplicationCount = preserveReplicationCount;
        return this;
    }

    @ApiModelProperty(value="Whether to preserve the HDFS replication count. Defaults to false.")
    public Boolean getPreserveReplicationCount() {
        return this.preserveReplicationCount;
    }

    public void setPreserveReplicationCount(Boolean preserveReplicationCount) {
        this.preserveReplicationCount = preserveReplicationCount;
    }

    public ApiHdfsCloudReplicationArguments preserveBlockSize(Boolean preserveBlockSize) {
        this.preserveBlockSize = preserveBlockSize;
        return this;
    }

    @ApiModelProperty(value="Whether to preserve the HDFS block size. Defaults to false.")
    public Boolean getPreserveBlockSize() {
        return this.preserveBlockSize;
    }

    public void setPreserveBlockSize(Boolean preserveBlockSize) {
        this.preserveBlockSize = preserveBlockSize;
    }

    public ApiHdfsCloudReplicationArguments preservePermissions(Boolean preservePermissions) {
        this.preservePermissions = preservePermissions;
        return this;
    }

    @ApiModelProperty(value="Whether to preserve the HDFS owner, group and permissions. Defaults to false. Starting from V10, it also preserves ACLs. Defaults to null (no preserve). ACLs is preserved if both clusters enable ACL support, and replication ignores any ACL related failures.")
    public Boolean getPreservePermissions() {
        return this.preservePermissions;
    }

    public void setPreservePermissions(Boolean preservePermissions) {
        this.preservePermissions = preservePermissions;
    }

    public ApiHdfsCloudReplicationArguments logPath(String logPath) {
        this.logPath = logPath;
        return this;
    }

    @ApiModelProperty(value="The HDFS path where the replication log files should be written to.")
    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public ApiHdfsCloudReplicationArguments skipChecksumChecks(Boolean skipChecksumChecks) {
        this.skipChecksumChecks = skipChecksumChecks;
        return this;
    }

    @ApiModelProperty(value="Whether to skip checksum based file validation during replication. Defaults to false.")
    public Boolean getSkipChecksumChecks() {
        return this.skipChecksumChecks;
    }

    public void setSkipChecksumChecks(Boolean skipChecksumChecks) {
        this.skipChecksumChecks = skipChecksumChecks;
    }

    public ApiHdfsCloudReplicationArguments skipListingChecksumChecks(Boolean skipListingChecksumChecks) {
        this.skipListingChecksumChecks = skipListingChecksumChecks;
        return this;
    }

    @ApiModelProperty(value="Whether to skip checksum based file comparison during replication. Defaults to false.")
    public Boolean getSkipListingChecksumChecks() {
        return this.skipListingChecksumChecks;
    }

    public void setSkipListingChecksumChecks(Boolean skipListingChecksumChecks) {
        this.skipListingChecksumChecks = skipListingChecksumChecks;
    }

    public ApiHdfsCloudReplicationArguments skipTrash(Boolean skipTrash) {
        this.skipTrash = skipTrash;
        return this;
    }

    @ApiModelProperty(value="Whether to permanently delete destination files that are missing in source. Defaults to null.")
    public Boolean getSkipTrash() {
        return this.skipTrash;
    }

    public void setSkipTrash(Boolean skipTrash) {
        this.skipTrash = skipTrash;
    }

    public ApiHdfsCloudReplicationArguments replicationStrategy(ReplicationStrategy replicationStrategy) {
        this.replicationStrategy = replicationStrategy;
        return this;
    }

    @ApiModelProperty(value="The strategy for distributing the file replication tasks among the mappers of the MR job associated with a replication. Default is ReplicationStrategy#STATIC.")
    public ReplicationStrategy getReplicationStrategy() {
        return this.replicationStrategy;
    }

    public void setReplicationStrategy(ReplicationStrategy replicationStrategy) {
        this.replicationStrategy = replicationStrategy;
    }

    public ApiHdfsCloudReplicationArguments preserveXAttrs(Boolean preserveXAttrs) {
        this.preserveXAttrs = preserveXAttrs;
        return this;
    }

    @ApiModelProperty(value="Whether to preserve XAttrs, default to false This is introduced in V10. To preserve XAttrs, both CDH versions should be >= 5.2. Replication fails if either cluster does not support XAttrs.")
    public Boolean getPreserveXAttrs() {
        return this.preserveXAttrs;
    }

    public void setPreserveXAttrs(Boolean preserveXAttrs) {
        this.preserveXAttrs = preserveXAttrs;
    }

    public ApiHdfsCloudReplicationArguments exclusionFilters(List<String> exclusionFilters) {
        this.exclusionFilters = exclusionFilters;
        return this;
    }

    public ApiHdfsCloudReplicationArguments addExclusionFiltersItem(String exclusionFiltersItem) {
        if (this.exclusionFilters == null) {
            this.exclusionFilters = new ArrayList<String>();
        }
        this.exclusionFilters.add(exclusionFiltersItem);
        return this;
    }

    @ApiModelProperty(example="\"null\"", value="Specify regular expression strings to match full paths of files and directories matching source paths and exclude them from the replication. Optional. Available since V11.")
    public List<String> getExclusionFilters() {
        return this.exclusionFilters;
    }

    public void setExclusionFilters(List<String> exclusionFilters) {
        this.exclusionFilters = exclusionFilters;
    }

    public ApiHdfsCloudReplicationArguments raiseSnapshotDiffFailures(Boolean raiseSnapshotDiffFailures) {
        this.raiseSnapshotDiffFailures = raiseSnapshotDiffFailures;
        return this;
    }

    @ApiModelProperty(value="Flag indicating if failures during snapshotDiff should be ignored or not. When it is set to false then, replication will fallback to full copy listing in case of any error in snapshot diff handling and it will ignore snapshot delete/rename failures at the end of a replication. The flag is by default set to false in distcp tool which means it will ignore snapshot diff failures and mark replication as success for snapshot delete/rename failures. In UI, the flag is set to true by default when source CM Version is greater than 5.14.")
    public Boolean getRaiseSnapshotDiffFailures() {
        return this.raiseSnapshotDiffFailures;
    }

    public void setRaiseSnapshotDiffFailures(Boolean raiseSnapshotDiffFailures) {
        this.raiseSnapshotDiffFailures = raiseSnapshotDiffFailures;
    }

    public ApiHdfsCloudReplicationArguments destinationCloudAccount(String destinationCloudAccount) {
        this.destinationCloudAccount = destinationCloudAccount;
        return this;
    }

    @ApiModelProperty(value="The cloud account name which is used in direct hive cloud replication, if specified.")
    public String getDestinationCloudAccount() {
        return this.destinationCloudAccount;
    }

    public void setDestinationCloudAccount(String destinationCloudAccount) {
        this.destinationCloudAccount = destinationCloudAccount;
    }

    public ApiHdfsCloudReplicationArguments sourceAccount(String sourceAccount) {
        this.sourceAccount = sourceAccount;
        return this;
    }

    @ApiModelProperty(value="")
    public String getSourceAccount() {
        return this.sourceAccount;
    }

    public void setSourceAccount(String sourceAccount) {
        this.sourceAccount = sourceAccount;
    }

    public ApiHdfsCloudReplicationArguments destinationAccount(String destinationAccount) {
        this.destinationAccount = destinationAccount;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDestinationAccount() {
        return this.destinationAccount;
    }

    public void setDestinationAccount(String destinationAccount) {
        this.destinationAccount = destinationAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHdfsCloudReplicationArguments apiHdfsCloudReplicationArguments = (ApiHdfsCloudReplicationArguments)o;
        return Objects.equals(this.sourceService, apiHdfsCloudReplicationArguments.sourceService) && Objects.equals(this.sourcePath, apiHdfsCloudReplicationArguments.sourcePath) && Objects.equals(this.destinationPath, apiHdfsCloudReplicationArguments.destinationPath) && Objects.equals(this.mapreduceServiceName, apiHdfsCloudReplicationArguments.mapreduceServiceName) && Objects.equals(this.schedulerPoolName, apiHdfsCloudReplicationArguments.schedulerPoolName) && Objects.equals(this.userName, apiHdfsCloudReplicationArguments.userName) && Objects.equals(this.sourceUser, apiHdfsCloudReplicationArguments.sourceUser) && Objects.equals(this.numMaps, apiHdfsCloudReplicationArguments.numMaps) && Objects.equals(this.dryRun, apiHdfsCloudReplicationArguments.dryRun) && Objects.equals(this.bandwidthPerMap, apiHdfsCloudReplicationArguments.bandwidthPerMap) && Objects.equals(this.abortOnError, apiHdfsCloudReplicationArguments.abortOnError) && Objects.equals(this.removeMissingFiles, apiHdfsCloudReplicationArguments.removeMissingFiles) && Objects.equals(this.preserveReplicationCount, apiHdfsCloudReplicationArguments.preserveReplicationCount) && Objects.equals(this.preserveBlockSize, apiHdfsCloudReplicationArguments.preserveBlockSize) && Objects.equals(this.preservePermissions, apiHdfsCloudReplicationArguments.preservePermissions) && Objects.equals(this.logPath, apiHdfsCloudReplicationArguments.logPath) && Objects.equals(this.skipChecksumChecks, apiHdfsCloudReplicationArguments.skipChecksumChecks) && Objects.equals(this.skipListingChecksumChecks, apiHdfsCloudReplicationArguments.skipListingChecksumChecks) && Objects.equals(this.skipTrash, apiHdfsCloudReplicationArguments.skipTrash) && Objects.equals((Object)this.replicationStrategy, (Object)apiHdfsCloudReplicationArguments.replicationStrategy) && Objects.equals(this.preserveXAttrs, apiHdfsCloudReplicationArguments.preserveXAttrs) && Objects.equals(this.exclusionFilters, apiHdfsCloudReplicationArguments.exclusionFilters) && Objects.equals(this.raiseSnapshotDiffFailures, apiHdfsCloudReplicationArguments.raiseSnapshotDiffFailures) && Objects.equals(this.destinationCloudAccount, apiHdfsCloudReplicationArguments.destinationCloudAccount) && Objects.equals(this.sourceAccount, apiHdfsCloudReplicationArguments.sourceAccount) && Objects.equals(this.destinationAccount, apiHdfsCloudReplicationArguments.destinationAccount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceService, this.sourcePath, this.destinationPath, this.mapreduceServiceName, this.schedulerPoolName, this.userName, this.sourceUser, this.numMaps, this.dryRun, this.bandwidthPerMap, this.abortOnError, this.removeMissingFiles, this.preserveReplicationCount, this.preserveBlockSize, this.preservePermissions, this.logPath, this.skipChecksumChecks, this.skipListingChecksumChecks, this.skipTrash, this.replicationStrategy, this.preserveXAttrs, this.exclusionFilters, this.raiseSnapshotDiffFailures, this.destinationCloudAccount, this.sourceAccount, this.destinationAccount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHdfsCloudReplicationArguments {\n");
        sb.append("    sourceService: ").append(this.toIndentedString(this.sourceService)).append("\n");
        sb.append("    sourcePath: ").append(this.toIndentedString(this.sourcePath)).append("\n");
        sb.append("    destinationPath: ").append(this.toIndentedString(this.destinationPath)).append("\n");
        sb.append("    mapreduceServiceName: ").append(this.toIndentedString(this.mapreduceServiceName)).append("\n");
        sb.append("    schedulerPoolName: ").append(this.toIndentedString(this.schedulerPoolName)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    sourceUser: ").append(this.toIndentedString(this.sourceUser)).append("\n");
        sb.append("    numMaps: ").append(this.toIndentedString(this.numMaps)).append("\n");
        sb.append("    dryRun: ").append(this.toIndentedString(this.dryRun)).append("\n");
        sb.append("    bandwidthPerMap: ").append(this.toIndentedString(this.bandwidthPerMap)).append("\n");
        sb.append("    abortOnError: ").append(this.toIndentedString(this.abortOnError)).append("\n");
        sb.append("    removeMissingFiles: ").append(this.toIndentedString(this.removeMissingFiles)).append("\n");
        sb.append("    preserveReplicationCount: ").append(this.toIndentedString(this.preserveReplicationCount)).append("\n");
        sb.append("    preserveBlockSize: ").append(this.toIndentedString(this.preserveBlockSize)).append("\n");
        sb.append("    preservePermissions: ").append(this.toIndentedString(this.preservePermissions)).append("\n");
        sb.append("    logPath: ").append(this.toIndentedString(this.logPath)).append("\n");
        sb.append("    skipChecksumChecks: ").append(this.toIndentedString(this.skipChecksumChecks)).append("\n");
        sb.append("    skipListingChecksumChecks: ").append(this.toIndentedString(this.skipListingChecksumChecks)).append("\n");
        sb.append("    skipTrash: ").append(this.toIndentedString(this.skipTrash)).append("\n");
        sb.append("    replicationStrategy: ").append(this.toIndentedString((Object)this.replicationStrategy)).append("\n");
        sb.append("    preserveXAttrs: ").append(this.toIndentedString(this.preserveXAttrs)).append("\n");
        sb.append("    exclusionFilters: ").append(this.toIndentedString(this.exclusionFilters)).append("\n");
        sb.append("    raiseSnapshotDiffFailures: ").append(this.toIndentedString(this.raiseSnapshotDiffFailures)).append("\n");
        sb.append("    destinationCloudAccount: ").append(this.toIndentedString(this.destinationCloudAccount)).append("\n");
        sb.append("    sourceAccount: ").append(this.toIndentedString(this.sourceAccount)).append("\n");
        sb.append("    destinationAccount: ").append(this.toIndentedString(this.destinationAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

