/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.security.ldap;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.ServerSocket;
import java.util.UUID;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.FileUtils;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.factory.DefaultDirectoryServiceFactory;
import org.apache.directory.server.core.factory.JdbmPartitionFactory;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.store.LdifFileLoader;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.knox.gateway.security.ldap.SimpleDirectoryService;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLdapDirectoryServer {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleLdapDirectoryServer.class);
    private static final String DEFAULT_PORT = "33389";
    private DirectoryService service;
    private LdapServer server;

    public SimpleLdapDirectoryServer(String rootDn, File usersLdif, Transport ... transports) throws Exception {
        JdbmPartitionFactory partitionFactory;
        SimpleDirectoryService directoryService;
        if (!usersLdif.exists()) {
            throw new FileNotFoundException(usersLdif.getAbsolutePath());
        }
        try {
            directoryService = new SimpleDirectoryService();
            directoryService.setShutdownHookEnabled(false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            String typeName = System.getProperty("apacheds.partition.factory");
            if (typeName != null) {
                Class<PartitionFactory> type = Class.forName(typeName).asSubclass(PartitionFactory.class);
                partitionFactory = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else {
                partitionFactory = new JdbmPartitionFactory();
            }
        }
        catch (Exception e) {
            String msg = "Error instantiating custom partition factory";
            LOG.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        DefaultDirectoryServiceFactory factory = new DefaultDirectoryServiceFactory((DirectoryService)directoryService, (PartitionFactory)partitionFactory);
        factory.init(UUID.randomUUID().toString());
        this.service = factory.getDirectoryService();
        SimpleLdapDirectoryServer.enabledPosixSchema(this.service);
        Partition partition = factory.getPartitionFactory().createPartition(this.service.getSchemaManager(), this.service.getDnFactory(), "users", rootDn, 500, this.service.getInstanceLayout().getInstanceDirectory());
        this.service.addPartition(partition);
        CoreSession session = this.service.getAdminSession();
        LdifFileLoader lfl = new LdifFileLoader(session, usersLdif, null);
        lfl.execute();
        this.server = new LdapServer();
        this.server.setTransports(transports);
        this.server.setDirectoryService(this.service);
    }

    private static void enabledPosixSchema(DirectoryService service) throws LdapException {
        service.getSchemaManager().getLoadedSchema("nis").enable();
        service.getAdminSession().modify(new Dn(new String[]{"cn=nis,ou=schema"}), new Modification[]{new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "m-disabled", new String[]{"FALSE"})});
    }

    public void start() throws Exception {
        this.service.startup();
        this.server.start();
    }

    public void stop(boolean clean) throws Exception {
        this.server.stop();
        this.service.shutdown();
        if (clean) {
            FileUtils.deleteDirectory((File)this.service.getInstanceLayout().getInstanceDirectory());
        }
    }

    public static void main(String[] args) throws Exception {
        File file;
        PropertyConfigurator.configure((String)System.getProperty("log4j.configuration"));
        if (args.length < 1) {
            file = new File("conf/users.ldif");
        } else {
            File dir = new File(args[0]);
            if (!dir.exists() || !dir.isDirectory()) {
                throw new FileNotFoundException(dir.getAbsolutePath());
            }
            file = new File(dir, "users.ldif");
        }
        if (!file.exists() || !file.canRead()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        int port = Integer.parseInt(System.getProperty("ldap.port", DEFAULT_PORT));
        ServerSocket socket = new ServerSocket(port);
        socket.close();
        TcpTransport transport = new TcpTransport(port);
        SimpleLdapDirectoryServer ldap = new SimpleLdapDirectoryServer("dc=hadoop,dc=apache,dc=org", file, new Transport[]{transport});
        ldap.start();
    }
}

