/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ad.control;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.ldaptive.LdapUtils;
import org.ldaptive.asn1.AbstractParseHandler;
import org.ldaptive.asn1.DERParser;
import org.ldaptive.asn1.IntegerType;
import org.ldaptive.asn1.OctetStringType;
import org.ldaptive.asn1.ParseHandler;
import org.ldaptive.control.AbstractControl;
import org.ldaptive.control.RequestControl;
import org.ldaptive.control.ResponseControl;

public class GetStatsControl
extends AbstractControl
implements RequestControl,
ResponseControl {
    public static final String OID = "1.2.840.113556.1.4.970";
    private static final int HASH_CODE_SEED = 929;
    private final Map<String, Object> statistics = new HashMap<String, Object>();

    public GetStatsControl() {
        super(OID);
    }

    public GetStatsControl(boolean critical) {
        super(OID, critical);
    }

    public Map<String, Object> getStatistics() {
        return this.statistics;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GetStatsControl && super.equals(o)) {
            GetStatsControl v = (GetStatsControl)o;
            return LdapUtils.areEqual(this.statistics, v.statistics);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(929, this.getOID(), this.getCriticality(), this.statistics);
    }

    public String toString() {
        return String.format("[%s@%d::criticality=%s, statistics=%s]", this.getClass().getName(), this.hashCode(), this.getCriticality(), this.statistics);
    }

    @Override
    public byte[] encode() {
        return null;
    }

    @Override
    public void decode(byte[] berValue) {
        this.logger.trace("decoding control: {}", (Object)LdapUtils.base64Encode(berValue));
        DERParser parser = new DERParser();
        parser.registerHandler("/SEQ/INT[1]", (ParseHandler)new IntegerHandler(this, "threadCount"));
        parser.registerHandler("/SEQ/INT[3]", (ParseHandler)new IntegerHandler(this, "callTime"));
        parser.registerHandler("/SEQ/INT[5]", (ParseHandler)new IntegerHandler(this, "entriesReturned"));
        parser.registerHandler("/SEQ/INT[7]", (ParseHandler)new IntegerHandler(this, "entriesVisited"));
        parser.registerHandler("/SEQ/OCTSTR[9]", (ParseHandler)new StringHandler(this, "filter"));
        parser.registerHandler("/SEQ/OCTSTR[11]", (ParseHandler)new StringHandler(this, "index"));
        parser.registerHandler("/SEQ/INT[13]", (ParseHandler)new IntegerHandler(this, "pagesReferenced"));
        parser.registerHandler("/SEQ/INT[15]", (ParseHandler)new IntegerHandler(this, "pagesRead"));
        parser.registerHandler("/SEQ/INT[17]", (ParseHandler)new IntegerHandler(this, "pagesPreread"));
        parser.registerHandler("/SEQ/INT[19]", (ParseHandler)new IntegerHandler(this, "pagesDirtied"));
        parser.registerHandler("/SEQ/INT[21]", (ParseHandler)new IntegerHandler(this, "pagesRedirtied"));
        parser.registerHandler("/SEQ/INT[23]", (ParseHandler)new IntegerHandler(this, "logRecordCount"));
        parser.registerHandler("/SEQ/INT[25]", (ParseHandler)new IntegerHandler(this, "logRecordBytes"));
        parser.parse(ByteBuffer.wrap(berValue));
    }

    private static class StringHandler
    extends AbstractParseHandler<GetStatsControl> {
        private final String statName;

        public StringHandler(GetStatsControl control, String name) {
            super(control);
            this.statName = name;
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            ((GetStatsControl)this.getObject()).getStatistics().put(this.statName, OctetStringType.decode(encoded).trim());
        }
    }

    private static class IntegerHandler
    extends AbstractParseHandler<GetStatsControl> {
        private final String statName;

        public IntegerHandler(GetStatsControl control, String name) {
            super(control);
            this.statName = name;
        }

        @Override
        public void handle(DERParser parser, ByteBuffer encoded) {
            ((GetStatsControl)this.getObject()).getStatistics().put(this.statName, IntegerType.decode(encoded).intValue());
        }
    }
}

