/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiEndPointHost;
import com.cloudera.api.swagger.model.ApiMapEntry;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="This defines a single logical service in the SDX cluster. A single service can expose one or more URLs. This ApiEndPoint groups the URLs logically for configuration, versioning, or any other service specific reason.")
public class ApiEndPoint {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="version")
    private String version = null;
    @SerializedName(value="serviceConfigs")
    private List<ApiMapEntry> serviceConfigs = null;
    @SerializedName(value="endPointHostList")
    private List<ApiEndPointHost> endPointHostList = null;
    @SerializedName(value="serviceType")
    private String serviceType = null;

    public ApiEndPoint name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name for the endPoint.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiEndPoint version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="Endpoint specific version.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ApiEndPoint serviceConfigs(List<ApiMapEntry> serviceConfigs) {
        this.serviceConfigs = serviceConfigs;
        return this;
    }

    public ApiEndPoint addServiceConfigsItem(ApiMapEntry serviceConfigsItem) {
        if (this.serviceConfigs == null) {
            this.serviceConfigs = new ArrayList<ApiMapEntry>();
        }
        this.serviceConfigs.add(serviceConfigsItem);
        return this;
    }

    @ApiModelProperty(value="Additional configs for the endPoint.")
    public List<ApiMapEntry> getServiceConfigs() {
        return this.serviceConfigs;
    }

    public void setServiceConfigs(List<ApiMapEntry> serviceConfigs) {
        this.serviceConfigs = serviceConfigs;
    }

    public ApiEndPoint endPointHostList(List<ApiEndPointHost> endPointHostList) {
        this.endPointHostList = endPointHostList;
        return this;
    }

    public ApiEndPoint addEndPointHostListItem(ApiEndPointHost endPointHostListItem) {
        if (this.endPointHostList == null) {
            this.endPointHostList = new ArrayList<ApiEndPointHost>();
        }
        this.endPointHostList.add(endPointHostListItem);
        return this;
    }

    @ApiModelProperty(value="List hosts (uris) for this endPoint.")
    public List<ApiEndPointHost> getEndPointHostList() {
        return this.endPointHostList;
    }

    public void setEndPointHostList(List<ApiEndPointHost> endPointHostList) {
        this.endPointHostList = endPointHostList;
    }

    public ApiEndPoint serviceType(String serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @ApiModelProperty(value="Endpoint service type.")
    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiEndPoint apiEndPoint = (ApiEndPoint)o;
        return Objects.equals(this.name, apiEndPoint.name) && Objects.equals(this.version, apiEndPoint.version) && Objects.equals(this.serviceConfigs, apiEndPoint.serviceConfigs) && Objects.equals(this.endPointHostList, apiEndPoint.endPointHostList) && Objects.equals(this.serviceType, apiEndPoint.serviceType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.serviceConfigs, this.endPointHostList, this.serviceType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiEndPoint {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    serviceConfigs: ").append(this.toIndentedString(this.serviceConfigs)).append("\n");
        sb.append("    endPointHostList: ").append(this.toIndentedString(this.endPointHostList)).append("\n");
        sb.append("    serviceType: ").append(this.toIndentedString(this.serviceType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

