/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Arguments used for Rolling Upgrade command.")
public class ApiRollingUpgradeServicesArgs {
    @SerializedName(value="upgradeFromCdhVersion")
    private String upgradeFromCdhVersion = null;
    @SerializedName(value="upgradeToCdhVersion")
    private String upgradeToCdhVersion = null;
    @SerializedName(value="slaveBatchSize")
    private BigDecimal slaveBatchSize = null;
    @SerializedName(value="sleepSeconds")
    private BigDecimal sleepSeconds = null;
    @SerializedName(value="slaveFailCountThreshold")
    private BigDecimal slaveFailCountThreshold = null;
    @SerializedName(value="upgradeServiceNames")
    private List<String> upgradeServiceNames = null;

    public ApiRollingUpgradeServicesArgs upgradeFromCdhVersion(String upgradeFromCdhVersion) {
        this.upgradeFromCdhVersion = upgradeFromCdhVersion;
        return this;
    }

    @ApiModelProperty(value="Current CDH Version of the services. Example versions are: \"5.1.0\", \"5.2.2\" or \"5.4.0\"")
    public String getUpgradeFromCdhVersion() {
        return this.upgradeFromCdhVersion;
    }

    public void setUpgradeFromCdhVersion(String upgradeFromCdhVersion) {
        this.upgradeFromCdhVersion = upgradeFromCdhVersion;
    }

    public ApiRollingUpgradeServicesArgs upgradeToCdhVersion(String upgradeToCdhVersion) {
        this.upgradeToCdhVersion = upgradeToCdhVersion;
        return this;
    }

    @ApiModelProperty(value="Target CDH Version for the services. The CDH version should already be present and activated on the nodes. Example versions are: \"5.1.0\", \"5.2.2\" or \"5.4.0\"")
    public String getUpgradeToCdhVersion() {
        return this.upgradeToCdhVersion;
    }

    public void setUpgradeToCdhVersion(String upgradeToCdhVersion) {
        this.upgradeToCdhVersion = upgradeToCdhVersion;
    }

    public ApiRollingUpgradeServicesArgs slaveBatchSize(BigDecimal slaveBatchSize) {
        this.slaveBatchSize = slaveBatchSize;
        return this;
    }

    @ApiModelProperty(value="Number of hosts with slave roles to upgrade at a time. Must be greater than zero. Default is 1.")
    public BigDecimal getSlaveBatchSize() {
        return this.slaveBatchSize;
    }

    public void setSlaveBatchSize(BigDecimal slaveBatchSize) {
        this.slaveBatchSize = slaveBatchSize;
    }

    public ApiRollingUpgradeServicesArgs sleepSeconds(BigDecimal sleepSeconds) {
        this.sleepSeconds = sleepSeconds;
        return this;
    }

    @ApiModelProperty(value="Number of seconds to sleep between restarts of slave host batches.  Must be greater than or equal to 0. Default is 0.")
    public BigDecimal getSleepSeconds() {
        return this.sleepSeconds;
    }

    public void setSleepSeconds(BigDecimal sleepSeconds) {
        this.sleepSeconds = sleepSeconds;
    }

    public ApiRollingUpgradeServicesArgs slaveFailCountThreshold(BigDecimal slaveFailCountThreshold) {
        this.slaveFailCountThreshold = slaveFailCountThreshold;
        return this;
    }

    @ApiModelProperty(value="The threshold for number of slave host batches that are allowed to fail to restart before the entire command is considered failed.  Must be greater than or equal to 0. Default is 0. <p> This argument is for ADVANCED users only. </p>")
    public BigDecimal getSlaveFailCountThreshold() {
        return this.slaveFailCountThreshold;
    }

    public void setSlaveFailCountThreshold(BigDecimal slaveFailCountThreshold) {
        this.slaveFailCountThreshold = slaveFailCountThreshold;
    }

    public ApiRollingUpgradeServicesArgs upgradeServiceNames(List<String> upgradeServiceNames) {
        this.upgradeServiceNames = upgradeServiceNames;
        return this;
    }

    public ApiRollingUpgradeServicesArgs addUpgradeServiceNamesItem(String upgradeServiceNamesItem) {
        if (this.upgradeServiceNames == null) {
            this.upgradeServiceNames = new ArrayList<String>();
        }
        this.upgradeServiceNames.add(upgradeServiceNamesItem);
        return this;
    }

    @ApiModelProperty(value="List of services to upgrade. Only the services that support rolling upgrade should be included.")
    public List<String> getUpgradeServiceNames() {
        return this.upgradeServiceNames;
    }

    public void setUpgradeServiceNames(List<String> upgradeServiceNames) {
        this.upgradeServiceNames = upgradeServiceNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiRollingUpgradeServicesArgs apiRollingUpgradeServicesArgs = (ApiRollingUpgradeServicesArgs)o;
        return Objects.equals(this.upgradeFromCdhVersion, apiRollingUpgradeServicesArgs.upgradeFromCdhVersion) && Objects.equals(this.upgradeToCdhVersion, apiRollingUpgradeServicesArgs.upgradeToCdhVersion) && Objects.equals(this.slaveBatchSize, apiRollingUpgradeServicesArgs.slaveBatchSize) && Objects.equals(this.sleepSeconds, apiRollingUpgradeServicesArgs.sleepSeconds) && Objects.equals(this.slaveFailCountThreshold, apiRollingUpgradeServicesArgs.slaveFailCountThreshold) && Objects.equals(this.upgradeServiceNames, apiRollingUpgradeServicesArgs.upgradeServiceNames);
    }

    public int hashCode() {
        return Objects.hash(this.upgradeFromCdhVersion, this.upgradeToCdhVersion, this.slaveBatchSize, this.sleepSeconds, this.slaveFailCountThreshold, this.upgradeServiceNames);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiRollingUpgradeServicesArgs {\n");
        sb.append("    upgradeFromCdhVersion: ").append(this.toIndentedString(this.upgradeFromCdhVersion)).append("\n");
        sb.append("    upgradeToCdhVersion: ").append(this.toIndentedString(this.upgradeToCdhVersion)).append("\n");
        sb.append("    slaveBatchSize: ").append(this.toIndentedString(this.slaveBatchSize)).append("\n");
        sb.append("    sleepSeconds: ").append(this.toIndentedString(this.sleepSeconds)).append("\n");
        sb.append("    slaveFailCountThreshold: ").append(this.toIndentedString(this.slaveFailCountThreshold)).append("\n");
        sb.append("    upgradeServiceNames: ").append(this.toIndentedString(this.upgradeServiceNames)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

