/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class ServletRequestUtils {
    public static String getRequestPath(ServletRequest servletRequest) {
        return ServletRequestUtils.getRequestPath((HttpServletRequest)servletRequest);
    }

    public static String getRequestPath(HttpServletRequest httpServletRequest) {
        return ServletRequestUtils.emptyOrValue(httpServletRequest.getServletPath()) + ServletRequestUtils.emptyOrValue(httpServletRequest.getPathInfo());
    }

    public static String getRequestPathWithQuery(ServletRequest servletRequest) {
        return ServletRequestUtils.getRequestPathWithQuery((HttpServletRequest)servletRequest);
    }

    public static String getRequestPathWithQuery(HttpServletRequest httpServletRequest) {
        return ServletRequestUtils.getRequestPath(httpServletRequest) + ServletRequestUtils.emptyOrValue(httpServletRequest.getQueryString(), "?");
    }

    public static String getContextPathWithQuery(ServletRequest servletRequest) {
        return ServletRequestUtils.getContextPathWithQuery((HttpServletRequest)servletRequest);
    }

    public static String getContextPathWithQuery(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getContextPath() + ServletRequestUtils.getRequestPathWithQuery(httpServletRequest);
    }

    private static String emptyOrValue(String toTest) {
        return ServletRequestUtils.emptyOrValue(toTest, null);
    }

    private static String emptyOrValue(String toTest, String prefix) {
        if (toTest == null) {
            return "";
        }
        return prefix == null ? toTest : prefix + toTest;
    }
}

