/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm;

import com.cloudera.api.swagger.RolesResourceApi;
import com.cloudera.api.swagger.ServicesResourceApi;
import com.cloudera.api.swagger.client.ApiClient;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiRoleList;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import com.cloudera.api.swagger.model.ApiServiceList;
import java.net.ConnectException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.knox.gateway.GatewayServer;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.GatewaySpiMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.topology.ClusterConfigurationMonitorService;
import org.apache.knox.gateway.topology.discovery.ClusterConfigurationMonitor;
import org.apache.knox.gateway.topology.discovery.ServiceDiscovery;
import org.apache.knox.gateway.topology.discovery.ServiceDiscoveryConfig;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerCluster;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerServiceDiscoveryMessages;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerServiceDiscoveryRepository;
import org.apache.knox.gateway.topology.discovery.cm.DiscoveryApiClient;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModelGenerator;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModelGeneratorHandleResponse;
import org.apache.knox.gateway.topology.discovery.cm.monitor.ClouderaManagerClusterConfigurationMonitor;

public class ClouderaManagerServiceDiscovery
implements ServiceDiscovery,
ClusterConfigurationMonitor.ConfigurationChangeListener {
    static final String TYPE = "ClouderaManager";
    private static final ClouderaManagerServiceDiscoveryMessages log = (ClouderaManagerServiceDiscoveryMessages)MessagesFactory.get(ClouderaManagerServiceDiscoveryMessages.class);
    private static final GatewaySpiMessages LOGGER = (GatewaySpiMessages)MessagesFactory.get(GatewaySpiMessages.class);
    static final String API_PATH = "api/v32";
    private static final String VIEW_SUMMARY = "summary";
    private static final String VIEW_FULL = "full";
    static final String DEFAULT_USER_ALIAS = "cm.discovery.user";
    static final String DEFAULT_PWD_ALIAS = "cm.discovery.password";
    public static final String CM_SERVICE_TYPE = "CM";
    public static final String CM_ROLE_TYPE = "CM_SERVER";
    private static Map<String, List<ServiceModelGenerator>> serviceModelGenerators = new HashMap<String, List<ServiceModelGenerator>>();
    private boolean debug;
    private AliasService aliasService;
    private KeyStore truststore;
    private ClouderaManagerClusterConfigurationMonitor configChangeMonitor;
    private final ClouderaManagerServiceDiscoveryRepository repository = ClouderaManagerServiceDiscoveryRepository.getInstance();
    private final AtomicInteger retryAttempts = new AtomicInteger(0);
    private final int retrySleepSeconds = 3;
    private int maxRetryAttempts = -1;

    ClouderaManagerServiceDiscovery(GatewayConfig gatewayConfig) {
        this(false, gatewayConfig);
    }

    ClouderaManagerServiceDiscovery(boolean debug, GatewayConfig gatewayConfig) {
        GatewayServices gwServices = GatewayServer.getGatewayServices();
        if (gwServices != null) {
            this.aliasService = (AliasService)gwServices.getService(ServiceType.ALIAS_SERVICE);
            KeystoreService keystoreService = (KeystoreService)gwServices.getService(ServiceType.KEYSTORE_SERVICE);
            if (keystoreService != null) {
                try {
                    this.truststore = keystoreService.getTruststoreForHttpClient();
                }
                catch (KeystoreServiceException e) {
                    LOGGER.failedToLoadTruststore(e.getMessage(), (Exception)((Object)e));
                }
            }
        }
        this.debug = debug;
        this.configChangeMonitor = this.getConfigurationChangeMonitor();
        if (gatewayConfig != null) {
            this.repository.setCacheEntryTTL(gatewayConfig.getClouderaManagerServiceDiscoveryRepositoryEntryTTL());
            this.configureRetryParams(gatewayConfig);
        }
    }

    private void configureRetryParams(GatewayConfig gatewayConfig) {
        int configuredMaxRetryAttempts = gatewayConfig.getClouderaManagerServiceDiscoveryMaximumRetryAttempts();
        if (configuredMaxRetryAttempts > 0) {
            int configuredRetryDurationSeconds = configuredMaxRetryAttempts * 3;
            int pollingInterval = gatewayConfig.getClusterMonitorPollingInterval(ClouderaManagerClusterConfigurationMonitor.getType());
            int retryDurationLimit = pollingInterval / 2;
            if (retryDurationLimit > configuredRetryDurationSeconds) {
                this.maxRetryAttempts = configuredMaxRetryAttempts;
            } else {
                this.maxRetryAttempts = retryDurationLimit / 3;
                log.updateMaxRetryAttempts(configuredMaxRetryAttempts, this.maxRetryAttempts);
            }
        }
    }

    public String getType() {
        return TYPE;
    }

    private DiscoveryApiClient getClient(GatewayConfig gatewayConfig, ServiceDiscoveryConfig discoveryConfig) {
        String discoveryAddress = discoveryConfig.getAddress();
        if (discoveryAddress == null || discoveryAddress.isEmpty()) {
            log.missingDiscoveryAddress();
            throw new IllegalArgumentException("Missing or invalid discovery address.");
        }
        DiscoveryApiClient client = new DiscoveryApiClient(gatewayConfig, discoveryConfig, this.aliasService, this.truststore);
        client.setDebugging(this.debug);
        return client;
    }

    private ClouderaManagerClusterConfigurationMonitor getConfigurationChangeMonitor() {
        ClouderaManagerClusterConfigurationMonitor cmMonitor = null;
        try {
            ClusterConfigurationMonitorService clusterMonitorService;
            ClusterConfigurationMonitor monitor;
            GatewayServices gwServices = GatewayServer.getGatewayServices();
            if (gwServices != null && (monitor = (clusterMonitorService = (ClusterConfigurationMonitorService)GatewayServer.getGatewayServices().getService(ServiceType.CLUSTER_CONFIGURATION_MONITOR_SERVICE)).getMonitor(ClouderaManagerClusterConfigurationMonitor.getType())) != null && ClouderaManagerClusterConfigurationMonitor.class.isAssignableFrom(monitor.getClass())) {
                cmMonitor = (ClouderaManagerClusterConfigurationMonitor)monitor;
                cmMonitor.addListener(this);
            }
        }
        catch (Exception e) {
            log.errorAccessingConfigurationChangeMonitor(e);
        }
        return cmMonitor;
    }

    public ClouderaManagerCluster discover(GatewayConfig gatewayConfig, ServiceDiscoveryConfig discoveryConfig, String clusterName) {
        return this.discover(gatewayConfig, discoveryConfig, clusterName, (Collection)Collections.emptySet());
    }

    public ClouderaManagerCluster discover(GatewayConfig gatewayConfig, ServiceDiscoveryConfig discoveryConfig, String clusterName, Collection<String> includedServices) {
        return this.discover(gatewayConfig, discoveryConfig, clusterName, includedServices, this.getClient(gatewayConfig, discoveryConfig));
    }

    protected ClouderaManagerCluster discover(GatewayConfig gatewayConfig, ServiceDiscoveryConfig discoveryConfig, String clusterName, Collection<String> includedServices, DiscoveryApiClient client) {
        ClouderaManagerCluster cluster = null;
        if (clusterName == null || clusterName.isEmpty()) {
            log.missingDiscoveryCluster();
            throw new IllegalArgumentException("The cluster configuration is missing from, or invalid in, the discovery configuration.");
        }
        try {
            cluster = this.discoverCluster(client, clusterName, includedServices);
            if (this.configChangeMonitor != null && cluster != null) {
                this.configChangeMonitor.addServiceConfiguration(cluster, discoveryConfig);
            }
            this.resetRetryAttempts();
        }
        catch (ApiException e) {
            log.clusterDiscoveryError(clusterName, (Exception)((Object)e));
            if (this.shouldRetryServiceDiscovery(e)) {
                log.retryDiscovery(3L, this.retryAttempts.get());
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                cluster = this.discover(gatewayConfig, discoveryConfig, clusterName, includedServices, client);
            }
            this.resetRetryAttempts();
        }
        return cluster;
    }

    private void resetRetryAttempts() {
        this.retryAttempts.set(0);
    }

    private boolean shouldRetryServiceDiscovery(ApiException e) {
        Throwable cause;
        return this.maxRetryAttempts > 0 && this.maxRetryAttempts > this.retryAttempts.getAndIncrement() && (cause = e.getCause()) != null && ConnectException.class.isAssignableFrom(cause.getClass());
    }

    private ClouderaManagerCluster discoverCluster(DiscoveryApiClient client, String clusterName, Collection<String> includedServices) throws ApiException {
        ServicesResourceApi servicesResourceApi = new ServicesResourceApi((ApiClient)client);
        RolesResourceApi rolesResourceApi = new RolesResourceApi((ApiClient)client);
        log.discoveringCluster(clusterName);
        this.repository.registerCluster(client.getConfig());
        HashSet<ServiceModel> serviceModels = new HashSet<ServiceModel>();
        List<ApiService> serviceList = this.getClusterServices(client.getConfig(), servicesResourceApi);
        if (serviceList != null) {
            ApiService cmService = new ApiService();
            cmService.setName(CM_SERVICE_TYPE.toLowerCase(Locale.ROOT));
            cmService.setType(CM_SERVICE_TYPE);
            serviceList.add(cmService);
            for (ApiService service : serviceList) {
                ApiRoleList roleList;
                List<ServiceModelGenerator> modelGenerators = serviceModelGenerators.get(service.getType());
                if (this.shouldSkipServiceDiscovery(modelGenerators, includedServices)) {
                    log.skipServiceDiscovery(service.getName(), service.getType());
                    continue;
                }
                log.discoveringService(service.getName(), service.getType());
                ApiServiceConfig serviceConfig = null;
                if (!CM_SERVICE_TYPE.equals(service.getType())) {
                    serviceConfig = this.getServiceConfig(client.getConfig(), servicesResourceApi, service);
                }
                if ((roleList = this.getRoles(client.getConfig(), rolesResourceApi, clusterName, service)) != null) {
                    for (ApiRole role : roleList.getItems()) {
                        String roleName = role.getName();
                        log.discoveringServiceRole(roleName, role.getType());
                        ApiConfigList roleConfig = null;
                        if (!CM_SERVICE_TYPE.equals(service.getType())) {
                            roleConfig = this.getRoleConfig(client.getConfig(), rolesResourceApi, service, role);
                        }
                        if (modelGenerators != null) {
                            for (ServiceModelGenerator serviceModelGenerator : modelGenerators) {
                                ServiceModelGeneratorHandleResponse response = serviceModelGenerator.handles(service, serviceConfig, role, roleConfig);
                                if (response.handled()) {
                                    serviceModelGenerator.setApiClient(client);
                                    ServiceModel serviceModel = serviceModelGenerator.generateService(service, serviceConfig, role, roleConfig);
                                    serviceModels.add(serviceModel);
                                    continue;
                                }
                                if (response.getConfigurationIssues().isEmpty()) continue;
                                log.serviceRoleHasConfigurationIssues(roleName, String.join((CharSequence)";", response.getConfigurationIssues()));
                            }
                        }
                        log.discoveredServiceRole(roleName, role.getType());
                    }
                }
                log.discoveredService(service.getName(), service.getType());
            }
            ClouderaManagerCluster cluster = new ClouderaManagerCluster(clusterName);
            cluster.addServiceModels(serviceModels);
            return cluster;
        }
        return null;
    }

    private boolean shouldSkipServiceDiscovery(List<ServiceModelGenerator> modelGenerators, Collection<String> includedServices) {
        if (includedServices == null || includedServices.isEmpty()) {
            return false;
        }
        if (modelGenerators != null) {
            for (ServiceModelGenerator modelGenerator : modelGenerators) {
                if (!includedServices.contains(modelGenerator.getService())) continue;
                return false;
            }
        }
        return true;
    }

    private List<ApiService> getClusterServices(ServiceDiscoveryConfig serviceDiscoveryConfig, ServicesResourceApi servicesResourceApi) throws ApiException {
        log.lookupClusterServicesFromRepository();
        List<ApiService> services = this.repository.getServices(serviceDiscoveryConfig);
        if (services == null || services.isEmpty()) {
            try {
                log.lookupClusterServicesFromCM();
                ApiServiceList serviceList = servicesResourceApi.readServices(serviceDiscoveryConfig.getCluster(), VIEW_SUMMARY);
                services = serviceList == null ? new ArrayList() : serviceList.getItems();
                services.forEach(service -> this.repository.addService(serviceDiscoveryConfig, (ApiService)service));
            }
            catch (ApiException e) {
                log.failedToAccessServiceConfigs(serviceDiscoveryConfig.getCluster(), (Exception)((Object)e));
                throw e;
            }
        }
        return services;
    }

    private ApiServiceConfig getServiceConfig(ServiceDiscoveryConfig serviceDiscoveryConfig, ServicesResourceApi servicesResourceApi, ApiService service) throws ApiException {
        log.lookupServiceConfigsFromRepository();
        ApiServiceConfig serviceConfig = this.repository.getServiceConfig(serviceDiscoveryConfig, service);
        if (serviceConfig == null) {
            try {
                log.lookupServiceConfigsFromCM();
                serviceConfig = servicesResourceApi.readServiceConfig(serviceDiscoveryConfig.getCluster(), service.getName(), VIEW_FULL);
                this.repository.addServiceConfig(serviceDiscoveryConfig, service, serviceConfig);
            }
            catch (ApiException e) {
                log.failedToAccessServiceConfigs(serviceDiscoveryConfig.getCluster(), (Exception)((Object)e));
                throw e;
            }
        }
        return serviceConfig;
    }

    private ApiRoleList getRoles(ServiceDiscoveryConfig serviceDiscoveryConfig, RolesResourceApi rolesResourceApi, String clusterName, ApiService service) throws ApiException {
        log.lookupRolesFromRepository();
        ApiRoleList roles = this.repository.getRoles(serviceDiscoveryConfig, service);
        if (roles == null || roles.getItems() == null) {
            String serviceName = service.getName();
            try {
                log.lookupRolesFromCM();
                if (CM_SERVICE_TYPE.equalsIgnoreCase(serviceName)) {
                    roles = new ApiRoleList();
                    ApiRole cmRole = new ApiRole();
                    cmRole.setName(CM_ROLE_TYPE);
                    cmRole.setType(CM_ROLE_TYPE);
                    roles.addItemsItem(cmRole);
                } else {
                    roles = rolesResourceApi.readRoles(clusterName, serviceName, "", VIEW_SUMMARY);
                }
                this.repository.addRoles(serviceDiscoveryConfig, service, roles);
            }
            catch (ApiException e) {
                log.failedToAccessServiceRoleConfigs(serviceName, "N/A", clusterName, (Exception)((Object)e));
                throw e;
            }
        }
        return roles;
    }

    private ApiConfigList getRoleConfig(ServiceDiscoveryConfig serviceDiscoveryConfig, RolesResourceApi rolesResourceApi, ApiService service, ApiRole role) throws ApiException {
        log.lookupRoleConfigsFromRepository();
        ApiConfigList configList = this.repository.getRoleConfigs(serviceDiscoveryConfig, service, role);
        if (configList == null || configList.getItems() == null) {
            try {
                log.lookupRoleConfigsFromCM();
                configList = rolesResourceApi.readRoleConfig(serviceDiscoveryConfig.getCluster(), role.getName(), service.getName(), VIEW_FULL);
                this.repository.addRoleConfigs(serviceDiscoveryConfig, service, role, configList);
            }
            catch (ApiException e) {
                log.failedToAccessServiceRoleConfigs(service.getName(), role.getName(), serviceDiscoveryConfig.getCluster(), (Exception)((Object)e));
                throw e;
            }
        }
        return configList;
    }

    public void onConfigurationChange(String source, String clusterName) {
        log.clearServiceDiscoveryRepository();
        this.repository.clear();
    }

    static {
        ServiceLoader<ServiceModelGenerator> loader = ServiceLoader.load(ServiceModelGenerator.class);
        for (ServiceModelGenerator serviceModelGenerator : loader) {
            List smgList = serviceModelGenerators.computeIfAbsent(serviceModelGenerator.getServiceType(), k -> new ArrayList());
            smgList.add(serviceModelGenerator);
        }
    }
}

