/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.monitor;

import com.cloudera.api.swagger.EventsResourceApi;
import com.cloudera.api.swagger.RolesResourceApi;
import com.cloudera.api.swagger.ServicesResourceApi;
import com.cloudera.api.swagger.client.ApiClient;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiEvent;
import com.cloudera.api.swagger.model.ApiEventAttribute;
import com.cloudera.api.swagger.model.ApiEventCategory;
import com.cloudera.api.swagger.model.ApiEventQueryResult;
import com.cloudera.api.swagger.model.ApiHostRef;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiRoleConfig;
import com.cloudera.api.swagger.model.ApiRoleConfigList;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.KeyStore;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.knox.gateway.GatewayServer;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.GatewaySpiMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.services.topology.TopologyService;
import org.apache.knox.gateway.services.topology.impl.GatewayStatusService;
import org.apache.knox.gateway.topology.ClusterConfigurationMonitorService;
import org.apache.knox.gateway.topology.discovery.ClusterConfigurationMonitor;
import org.apache.knox.gateway.topology.discovery.ServiceDiscoveryConfig;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerServiceDiscoveryMessages;
import org.apache.knox.gateway.topology.discovery.cm.DiscoveryApiClient;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModelGeneratorsHolder;
import org.apache.knox.gateway.topology.discovery.cm.ServiceRoleCollector;
import org.apache.knox.gateway.topology.discovery.cm.ServiceRoleCollectorBuilder;
import org.apache.knox.gateway.topology.discovery.cm.monitor.ClusterConfigurationCache;
import org.apache.knox.gateway.topology.discovery.cm.monitor.ServiceConfigurationModel;
import org.apache.knox.gateway.topology.simple.SimpleDescriptor;
import org.apache.knox.gateway.topology.simple.SimpleDescriptorFactory;

public class PollingConfigurationAnalyzer
implements Runnable {
    private static final String COMMAND = "COMMAND";
    private static final String COMMAND_STATUS = "COMMAND_STATUS";
    static final String SUCCEEDED_STATUS = "SUCCEEDED";
    static final String RESTART_COMMAND = "Restart";
    static final String START_COMMAND = "Start";
    static final String ROLLING_RESTART_COMMAND = "RollingRestart";
    static final String RESTART_WAITING_FOR_STALENESS_SUCCESS_COMMAND = "RestartWaitingForStalenessSuccess";
    static final String CM_SERVICE_TYPE = "ManagerServer";
    static final String CM_SERVICE = "ClouderaManager";
    public static final String EVENT_CODE_ROLE_DELETED = "EV_ROLE_DELETED";
    public static final String EVENT_CODE_ROLE_CREATED = "EV_ROLE_CREATED";
    private static final Collection<String> START_COMMANDS = Arrays.asList("Start", "Restart", "RollingRestart", "RestartWaitingForStalenessSuccess");
    private static final Collection<String> DELETED_EVENT_CODES = Arrays.asList("EV_ROLE_DELETED");
    private static final Collection<String> CREATED_EVENT_CODES = Arrays.asList("EV_ROLE_CREATED");
    private static final String EVENTS_QUERY_FORMAT = "category==" + ApiEventCategory.AUDIT_EVENT.getValue() + ";attributes.cluster==\"%s\"%s";
    private static final String EVENTS_QUERY_TIMESTAMP_FORMAT = ";timeOccurred=gt=%s";
    private static final long DEFAULT_EVENT_QUERY_DEFAULT_TIMESTAMP_OFFSET = 3600000L;
    private static final int DEFAULT_POLLING_INTERVAL = 60;
    private static final ClouderaManagerServiceDiscoveryMessages log = (ClouderaManagerServiceDiscoveryMessages)MessagesFactory.get(ClouderaManagerServiceDiscoveryMessages.class);
    private static final GatewaySpiMessages LOGGER = (GatewaySpiMessages)MessagesFactory.get(GatewaySpiMessages.class);
    private static final String FQCN_DELIM = "::";
    private ClusterConfigurationCache configCache;
    private ClusterConfigurationMonitor.ConfigurationChangeListener changeListener;
    private AliasService aliasService;
    private KeyStore truststore;
    private TopologyService topologyService;
    private ClusterConfigurationMonitorService ccms;
    private int interval;
    private final Cache<String, Long> processedEvents;
    private final Map<String, DiscoveryApiClient> clients = new ConcurrentHashMap<String, DiscoveryApiClient>();
    private Map<String, Instant> eventQueryTimestamps = new ConcurrentHashMap<String, Instant>();
    private long eventQueryDefaultTimestampOffset = 3600000L;
    private ServiceModelGeneratorsHolder serviceModelGeneratorsHolder = ServiceModelGeneratorsHolder.getInstance();
    private boolean isActive;
    private final GatewayConfig gatewayConfig;
    private GatewayStatusService gatewayStatusService;

    PollingConfigurationAnalyzer(GatewayConfig gatewayConfig, ClusterConfigurationCache configCache, AliasService aliasService, KeystoreService keystoreService, ClusterConfigurationMonitor.ConfigurationChangeListener changeListener) {
        this(gatewayConfig, configCache, aliasService, keystoreService, changeListener, 60);
    }

    PollingConfigurationAnalyzer(GatewayConfig gatewayConfig, ClusterConfigurationCache configCache, AliasService aliasService, KeystoreService keystoreService, ClusterConfigurationMonitor.ConfigurationChangeListener changeListener, int interval) {
        this.gatewayConfig = gatewayConfig;
        this.configCache = configCache;
        this.aliasService = aliasService;
        if (keystoreService != null) {
            try {
                this.truststore = keystoreService.getTruststoreForHttpClient();
            }
            catch (KeystoreServiceException e) {
                LOGGER.failedToLoadTruststore(e.getMessage(), (Exception)((Object)e));
            }
        }
        this.changeListener = changeListener;
        this.interval = interval;
        this.processedEvents = Caffeine.newBuilder().expireAfterAccess((long)(interval * 3), TimeUnit.SECONDS).maximumSize(1000L).build();
    }

    void setInterval(int interval) {
        this.interval = interval;
    }

    void stop() {
        this.isActive = false;
    }

    private void waitFor(long seconds) {
        try {
            Thread.sleep(seconds * 1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void run() {
        log.startedClouderaManagerConfigMonitor(this.interval);
        this.isActive = true;
        boolean gatewayStatusOk = false;
        while (this.isActive) {
            if (!gatewayStatusOk) {
                boolean bl = gatewayStatusOk = this.getGatewayStatusService() != null && this.getGatewayStatusService().status();
            }
            if (gatewayStatusOk) {
                this.monitorClusterConfigurationChanges();
            } else {
                log.gatewayIsNotYetReadyToMonitorClouderaManagerConfigs();
            }
            this.waitFor(this.interval);
        }
        log.stoppedClouderaManagerConfigMonitor();
    }

    private void monitorClusterConfigurationChanges() {
        try {
            ArrayList<String> clustersToStopMonitoring = new ArrayList<String>();
            for (Map.Entry<String, List<String>> entry : this.configCache.getClusterNames().entrySet()) {
                String address = entry.getKey();
                for (String clusterName : entry.getValue()) {
                    if (this.configCache.getDiscoveryConfig(address, clusterName) == null) {
                        log.noClusterConfiguration(clusterName, address);
                        continue;
                    }
                    log.checkingClusterConfiguration(clusterName, address);
                    if (!this.clusterReferencesExist(address, clusterName)) {
                        clustersToStopMonitoring.add(address + FQCN_DELIM + clusterName);
                        continue;
                    }
                    List<RelevantEvent> relevantEvents = this.getRelevantEvents(address, clusterName);
                    if (relevantEvents.isEmpty()) continue;
                    if (this.hasConfigChanged(address, clusterName, relevantEvents) || this.hasScaleEvent(relevantEvents)) {
                        this.notifyChangeListener(address, clusterName);
                    }
                    relevantEvents.forEach(re -> this.processedEvents.put((Object)((RelevantEvent)re).auditEvent.getId(), (Object)1L));
                }
            }
            for (String fqcn : clustersToStopMonitoring) {
                String[] parts = fqcn.split(FQCN_DELIM);
                this.stopMonitoring(parts[0], parts[1]);
            }
            clustersToStopMonitoring.clear();
        }
        catch (Exception e) {
            log.clouderaManagerConfigurationChangesMonitoringError(e);
        }
    }

    private boolean hasScaleEvent(List<RelevantEvent> relevantEvents) {
        boolean found = false;
        for (RelevantEvent event : relevantEvents) {
            if (this.alreadyProcessed(event)) {
                log.activationEventAlreadyProcessed(event.auditEvent.getId());
                continue;
            }
            if (event.getRole() == null) continue;
            if (event.isRoleAddedEvent()) {
                log.foundUpScaleEvent(event.getRole(), event.getHosts());
                found = true;
                break;
            }
            if (!event.isRoleDeletedEvent()) continue;
            log.foundDownScaleEvent(event.getRole(), event.getHosts());
            found = true;
            break;
        }
        return found;
    }

    private boolean alreadyProcessed(RelevantEvent event) {
        return this.processedEvents.getIfPresent((Object)event.auditEvent.getId()) != null;
    }

    private boolean hasConfigChanged(String address, String clusterName, List<RelevantEvent> relevantEvents) {
        Map<String, ServiceConfigurationModel> serviceConfigurations = this.configCache.getClusterServiceConfigurations(address, clusterName);
        ArrayList<String> handledServiceTypes = new ArrayList<String>();
        boolean configHasChanged = false;
        for (RelevantEvent re : relevantEvents) {
            if (this.alreadyProcessed(re)) {
                log.activationEventAlreadyProcessed(re.auditEvent.getId());
                continue;
            }
            if (re.isRoleAddedEvent() || re.isRoleDeletedEvent()) continue;
            String serviceType = re.getServiceType();
            if (CM_SERVICE_TYPE.equals(serviceType) && CM_SERVICE.equals(re.getService())) {
                configHasChanged = true;
            }
            if (!configHasChanged && !handledServiceTypes.contains(serviceType)) {
                ServiceConfigurationModel serviceConfig = serviceConfigurations.get(re.getServiceType());
                if (serviceConfig != null) {
                    ServiceConfigurationModel currentConfig = this.getCurrentServiceConfiguration(address, clusterName, re.getService());
                    if (currentConfig != null) {
                        log.analyzingCurrentServiceConfiguration(re.getService());
                        try {
                            configHasChanged = this.hasConfigurationChanged(serviceConfig, currentConfig);
                        }
                        catch (Exception e) {
                            log.errorAnalyzingCurrentServiceConfiguration(re.getService(), e);
                        }
                    }
                } else {
                    log.serviceEnabled(re.getService());
                    configHasChanged = true;
                }
                handledServiceTypes.add(serviceType);
            }
            if (!configHasChanged) continue;
            break;
        }
        return configHasChanged;
    }

    private TopologyService getTopologyService() {
        GatewayServices gws;
        if (this.topologyService == null && (gws = GatewayServer.getGatewayServices()) != null) {
            this.topologyService = (TopologyService)gws.getService(ServiceType.TOPOLOGY_SERVICE);
        }
        return this.topologyService;
    }

    private ClusterConfigurationMonitorService getConfigMonitorService() {
        GatewayServices gws;
        if (this.ccms == null && (gws = GatewayServer.getGatewayServices()) != null) {
            this.ccms = (ClusterConfigurationMonitorService)gws.getService(ServiceType.CLUSTER_CONFIGURATION_MONITOR_SERVICE);
        }
        return this.ccms;
    }

    private GatewayStatusService getGatewayStatusService() {
        GatewayServices gatewayServices;
        if (this.gatewayStatusService == null && (gatewayServices = GatewayServer.getGatewayServices()) != null) {
            this.gatewayStatusService = (GatewayStatusService)gatewayServices.getService(ServiceType.GATEWAY_STATUS_SERVICE);
        }
        return this.gatewayStatusService;
    }

    private boolean clusterReferencesExist(String source, String clusterName) {
        boolean remainingClusterRefs = false;
        if (source != null && clusterName != null) {
            TopologyService ts = this.getTopologyService();
            if (ts != null) {
                for (File f : ts.getDescriptors()) {
                    try {
                        SimpleDescriptor sd = SimpleDescriptorFactory.parse((String)f.toPath().toAbsolutePath().toString());
                        if (!source.equals(sd.getDiscoveryAddress()) || !clusterName.equals(sd.getCluster())) continue;
                        remainingClusterRefs = true;
                        break;
                    }
                    catch (IOException iOException) {
                    }
                }
            } else {
                remainingClusterRefs = true;
            }
        }
        return remainingClusterRefs;
    }

    private void stopMonitoring(String source, String clusterName) {
        ClusterConfigurationMonitorService ms = this.getConfigMonitorService();
        if (ms != null) {
            log.stoppingConfigMonitoring(source, clusterName);
            ms.clearCache(source, clusterName);
        }
    }

    private void notifyChangeListener(String source, String clusterName) {
        if (this.changeListener != null) {
            this.changeListener.onConfigurationChange(source, clusterName);
        }
    }

    void setEventQueryTimestamp(String address, String cluster, Instant timestamp) {
        this.eventQueryTimestamps.put(address + ":" + cluster, timestamp);
    }

    private Instant getEventQueryTimestamp(String address, String cluster) {
        return this.eventQueryTimestamps.get(address + ":" + cluster);
    }

    private DiscoveryApiClient getApiClient(ServiceDiscoveryConfig discoveryConfig) {
        return this.clients.computeIfAbsent(discoveryConfig.getAddress(), c -> new DiscoveryApiClient(this.gatewayConfig, discoveryConfig, this.aliasService, this.truststore));
    }

    private List<RelevantEvent> getRelevantEvents(String address, String clusterName) {
        ArrayList<RelevantEvent> relevantEvents = new ArrayList<RelevantEvent>();
        Instant lastTimestamp = this.getEventQueryTimestamp(address, clusterName);
        if (lastTimestamp == null) {
            lastTimestamp = Instant.now().minus(this.eventQueryDefaultTimestampOffset, ChronoUnit.MILLIS);
        }
        lastTimestamp = lastTimestamp.minus(this.interval * 2, ChronoUnit.SECONDS);
        log.queryingConfigActivationEventsFromCluster(clusterName, address, lastTimestamp.toString());
        this.setEventQueryTimestamp(address, clusterName, Instant.now());
        List<ApiEvent> events = this.queryEvents(this.getApiClient(this.configCache.getDiscoveryConfig(address, clusterName)), clusterName, lastTimestamp.toString());
        if (events.isEmpty()) {
            log.noActivationEventFound();
        } else {
            for (ApiEvent event : events) {
                if (!this.isStartEvent(event) && !this.isScaleEvent(event)) continue;
                relevantEvents.add(new RelevantEvent(event));
            }
        }
        return relevantEvents;
    }

    private boolean isStartEvent(ApiEvent event) {
        Map<String, Object> attributeMap = this.getAttributeMap(event.getAttributes());
        String command = this.getAttribute(attributeMap, COMMAND);
        String status = this.getAttribute(attributeMap, COMMAND_STATUS);
        String serviceType = this.getAttribute(attributeMap, "SERVICE_TYPE");
        boolean serviceModelGeneratorExists = this.serviceModelGeneratorsHolder.getServiceModelGenerators(serviceType) != null;
        boolean relevant = START_COMMANDS.contains(command) && SUCCEEDED_STATUS.equals(status) && serviceModelGeneratorExists;
        log.activationEventRelevance(event.getId(), String.valueOf(relevant), command, status, serviceType, serviceModelGeneratorExists);
        return relevant;
    }

    private boolean isScaleEvent(ApiEvent event) {
        Map<String, Object> attributeMap = this.getAttributeMap(event.getAttributes());
        String serviceType = this.getAttribute(attributeMap, "SERVICE_TYPE");
        String eventCode = this.getAttribute(attributeMap, "EVENTCODE");
        boolean serviceModelGeneratorExists = this.serviceModelGeneratorsHolder.getServiceModelGenerators(serviceType) != null;
        boolean relevant = serviceModelGeneratorExists && (CREATED_EVENT_CODES.contains(eventCode) || DELETED_EVENT_CODES.contains(eventCode));
        log.scaleEventRelevance(event.getId(), String.valueOf(relevant), eventCode, serviceType, relevant);
        return relevant;
    }

    private String getAttribute(Map<String, Object> attributeMap, String attributeName) {
        return attributeMap.containsKey(attributeName) ? (String)((List)attributeMap.get(attributeName)).get(0) : "";
    }

    private Map<String, Object> getAttributeMap(List<ApiEventAttribute> attributes) {
        return attributes == null ? Collections.emptyMap() : attributes.stream().collect(Collectors.toMap(ApiEventAttribute::getName, ApiEventAttribute::getValues));
    }

    protected List<ApiEvent> queryEvents(ApiClient client, String clusterName, String since) {
        ArrayList<ApiEvent> events = new ArrayList<ApiEvent>();
        String timeFilter = since != null ? String.format(Locale.ROOT, EVENTS_QUERY_TIMESTAMP_FORMAT, since) : "";
        String queryString = String.format(Locale.ROOT, EVENTS_QUERY_FORMAT, clusterName, timeFilter);
        try {
            ApiEventQueryResult eventsResult = new EventsResourceApi(client).readEvents(null, queryString, BigDecimal.valueOf(0L));
            events.addAll(eventsResult.getItems());
        }
        catch (ApiException e) {
            log.clouderaManagerEventsAPIError(e);
        }
        return events;
    }

    protected ServiceConfigurationModel getCurrentServiceConfiguration(String address, String clusterName, String service) {
        ServiceConfigurationModel currentConfig = null;
        log.gettingCurrentClusterConfiguration(service, clusterName, address);
        DiscoveryApiClient apiClient = this.getApiClient(this.configCache.getDiscoveryConfig(address, clusterName));
        ServicesResourceApi api = new ServicesResourceApi((ApiClient)apiClient);
        try {
            ApiServiceConfig svcConfig = api.readServiceConfig(clusterName, service, "full");
            HashMap<ApiRole, ApiConfigList> roleConfigs = new HashMap<ApiRole, ApiConfigList>();
            RolesResourceApi rolesResourceApi = new RolesResourceApi((ApiClient)apiClient);
            ServiceRoleCollector roleCollector = ServiceRoleCollectorBuilder.newBuilder().gatewayConfig(this.gatewayConfig).rolesResourceApi(rolesResourceApi).build();
            ApiRoleConfigList roleConfigList = roleCollector.getAllServiceRoleConfigurations(clusterName, service);
            for (ApiRoleConfig roleConfig : roleConfigList.getItems()) {
                ApiConfigList configList = roleConfig.getConfig();
                String roleName = roleConfig.getName();
                String roleType = roleConfig.getRoleType();
                ApiHostRef hostRef = roleConfig.getHostRef();
                ApiRole role = new ApiRole().name(roleName).type(roleType).hostRef(hostRef);
                roleConfigs.put(role, configList);
            }
            currentConfig = new ServiceConfigurationModel(svcConfig, roleConfigs);
        }
        catch (ApiException e) {
            log.clouderaManagerConfigurationAPIError(e);
        }
        return currentConfig;
    }

    private boolean hasConfigurationChanged(ServiceConfigurationModel previous, ServiceConfigurationModel current) {
        boolean hasChanged = false;
        Map<String, String> previousProps = previous.getServiceProps();
        Map<String, String> currentProps = current.getServiceProps();
        for (String name : previousProps.keySet()) {
            String currValue;
            String prevValue = previousProps.get(name);
            if (prevValue.equals(currValue = currentProps.get(name))) continue;
            log.serviceConfigurationPropertyHasChanged(name, prevValue, currValue);
            hasChanged = true;
            break;
        }
        if (!hasChanged) {
            Set<String> previousRoleTypes = previous.getRoleTypes();
            Set<String> currentRoleTypes = current.getRoleTypes();
            block1: for (String roleType : previousRoleTypes) {
                if (!currentRoleTypes.contains(roleType)) {
                    log.roleTypeRemoved(roleType);
                    hasChanged = true;
                    break;
                }
                previousProps = previous.getRoleProps(roleType);
                currentProps = current.getRoleProps(roleType);
                for (String name : previousProps.keySet()) {
                    String prevValue = previousProps.get(name);
                    String currValue = currentProps.get(name);
                    if (currValue == null) {
                        if (prevValue == null || "null".equals(prevValue)) continue;
                        log.roleConfigurationPropertyHasChanged(name, prevValue, "null");
                        hasChanged = true;
                        continue block1;
                    }
                    if (currValue.equals(prevValue)) continue;
                    log.roleConfigurationPropertyHasChanged(name, prevValue, currValue);
                    hasChanged = true;
                    continue block1;
                }
            }
        }
        return hasChanged;
    }

    static final class RelevantEvent {
        private static final String ATTR_CLUSTER = "CLUSTER";
        private static final String ATTR_SERVICE_TYPE = "SERVICE_TYPE";
        private static final String ATTR_SERVICE = "SERVICE";
        private static final String ATTR_ROLE = "ROLE_TYPE";
        private static final String ATTR_HOST = "HOSTS";
        private static final String ATTR_EVENT_CODE = "EVENTCODE";
        private static List<String> attrsOfInterest = new ArrayList<String>();
        private ApiEvent auditEvent;
        private String clusterName;
        private String serviceType;
        private String service;
        private String role;
        private String eventCode;
        private Set<String> hosts = new HashSet<String>();

        RelevantEvent(ApiEvent auditEvent) {
            if (ApiEventCategory.AUDIT_EVENT != auditEvent.getCategory()) {
                throw new IllegalArgumentException("Invalid event category " + auditEvent.getCategory().getValue());
            }
            this.auditEvent = auditEvent;
            for (ApiEventAttribute attribute : auditEvent.getAttributes()) {
                if (!attrsOfInterest.contains(attribute.getName())) continue;
                this.setPropertyFromAttribute(attribute);
            }
        }

        String getTimestamp() {
            return this.auditEvent.getTimeOccurred();
        }

        String getClusterName() {
            return this.clusterName;
        }

        String getServiceType() {
            return this.serviceType;
        }

        String getService() {
            return this.service;
        }

        Set<String> getHosts() {
            return this.hosts;
        }

        String getRole() {
            return this.role;
        }

        boolean isRoleAddedEvent() {
            return PollingConfigurationAnalyzer.EVENT_CODE_ROLE_CREATED.equals(this.eventCode);
        }

        boolean isRoleDeletedEvent() {
            return PollingConfigurationAnalyzer.EVENT_CODE_ROLE_DELETED.equals(this.eventCode);
        }

        private void setPropertyFromAttribute(ApiEventAttribute attribute) {
            switch (attribute.getName()) {
                case "CLUSTER": {
                    this.clusterName = (String)attribute.getValues().get(0);
                    break;
                }
                case "SERVICE_TYPE": {
                    this.serviceType = (String)attribute.getValues().get(0);
                    break;
                }
                case "SERVICE": {
                    this.service = (String)attribute.getValues().get(0);
                    break;
                }
                case "HOSTS": {
                    if (attribute.getValues() == null || attribute.getValues().isEmpty()) break;
                    this.hosts.addAll(attribute.getValues());
                    break;
                }
                case "ROLE_TYPE": {
                    this.role = (String)attribute.getValues().get(0);
                    break;
                }
                case "EVENTCODE": {
                    this.eventCode = (String)attribute.getValues().get(0);
                    break;
                }
            }
        }

        static {
            attrsOfInterest.add(ATTR_CLUSTER);
            attrsOfInterest.add(ATTR_SERVICE_TYPE);
            attrsOfInterest.add(ATTR_SERVICE);
            attrsOfInterest.add(ATTR_ROLE);
            attrsOfInterest.add(ATTR_HOST);
            attrsOfInterest.add(ATTR_EVENT_CODE);
        }
    }
}

