/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.spark;

import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class SparkHistoryUIServiceModelGenerator
extends AbstractServiceModelGenerator {
    public static final String SERVICE = "SPARKHISTORYUI";
    public static final String SERVICE_TYPE = "SPARK_ON_YARN";
    public static final String ROLE_TYPE = "SPARK_YARN_HISTORY_SERVER";
    static final String SSL_ENABLED = "ssl_enabled";
    static final String SSL_SERVER_PORT = "ssl_server_port";
    static final String HISTORY_SERVER_PORT = "history_server_web_port";

    @Override
    public String getService() {
        return SERVICE;
    }

    @Override
    public String getServiceType() {
        return SERVICE_TYPE;
    }

    @Override
    public String getRoleType() {
        return ROLE_TYPE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.UI;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig, ApiServiceConfig coreSettingsConfig) {
        String port;
        String scheme;
        String hostname = role.getHostRef().getHostname();
        String sslEnabled = this.getRoleConfigValue(roleConfig, SSL_ENABLED);
        if (Boolean.parseBoolean(sslEnabled)) {
            scheme = "https";
            port = this.getRoleConfigValue(roleConfig, SSL_SERVER_PORT);
        } else {
            scheme = "http";
            port = this.getRoleConfigValue(roleConfig, HISTORY_SERVER_PORT);
        }
        ServiceModel model = this.createServiceModel(String.format(Locale.getDefault(), "%s://%s:%s", scheme, hostname, port));
        model.addRoleProperty(this.getRoleType(), SSL_ENABLED, sslEnabled);
        model.addRoleProperty(this.getRoleType(), SSL_SERVER_PORT, this.getRoleConfigValue(roleConfig, SSL_SERVER_PORT));
        model.addRoleProperty(this.getRoleType(), HISTORY_SERVER_PORT, this.getRoleConfigValue(roleConfig, HISTORY_SERVER_PORT));
        return model;
    }
}

