/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import org.apache.commons.collections.map.LRUMap;
import org.apache.directory.mavibot.btree.AbstractPage;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.PageHolder;
import org.apache.directory.mavibot.btree.PersistedBTree;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.mavibot.btree.exception.BTreeOperationException;
import org.apache.directory.mavibot.btree.exception.EndOfFileExceededException;

class PersistedPageHolder<K, V>
extends PageHolder<K, V> {
    private RecordManager recordManager;
    private LRUMap cache;
    private long offset;
    private long lastOffset;

    public PersistedPageHolder(BTree<K, V> btree, Page<K, V> page) {
        super(btree, null);
        this.cache = ((PersistedBTree)btree).getCache();
        this.recordManager = ((PersistedBTree)btree).getRecordManager();
        this.offset = ((AbstractPage)page).getOffset();
        this.lastOffset = ((AbstractPage)page).getLastOffset();
        ((AbstractPage)page).setOffset(this.offset);
        ((AbstractPage)page).setLastOffset(this.lastOffset);
        this.cache.put((Object)this.offset, page);
    }

    public PersistedPageHolder(BTree<K, V> btree, Page<K, V> page, long offset, long lastOffset) {
        super(btree, null);
        this.cache = ((PersistedBTree)btree).getCache();
        this.recordManager = ((PersistedBTree)btree).getRecordManager();
        this.offset = offset;
        this.lastOffset = lastOffset;
        if (page != null) {
            ((AbstractPage)page).setOffset(offset);
            ((AbstractPage)page).setLastOffset(lastOffset);
        }
        this.cache.put((Object)offset, page);
    }

    @Override
    public Page<K, V> getValue() {
        Page<K, V> page = (Page<K, V>)this.cache.get((Object)this.offset);
        if (page == null) {
            page = this.fetchElement();
            ((AbstractPage)page).setOffset(this.offset);
            ((AbstractPage)page).setLastOffset(this.lastOffset);
            this.cache.put((Object)this.offset, page);
        }
        return page;
    }

    private Page<K, V> fetchElement() {
        try {
            Page element = this.recordManager.deserialize(this.btree, this.offset);
            return element;
        }
        catch (EndOfFileExceededException eofee) {
            throw new BTreeOperationException(eofee.getMessage());
        }
        catch (IOException ioe) {
            throw new BTreeOperationException(ioe.getMessage());
        }
    }

    long getOffset() {
        return this.offset;
    }

    long getLastOffset() {
        return this.lastOffset;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Page<K, V> page = this.getValue();
        sb.append(this.btree.getName()).append("[").append(this.offset).append(", ").append(this.lastOffset).append("]:").append(page);
        return sb.toString();
    }
}

