/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.dispatch;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.knox.gateway.ha.config.HaConfigurations;
import org.apache.knox.gateway.ha.dispatch.StickySessionCookieRemovedRequest;
import org.apache.knox.gateway.ha.dispatch.i18n.HaDispatchMessages;
import org.apache.knox.gateway.ha.provider.HaServiceConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;

public interface CommonHaDispatch {
    public static final HaDispatchMessages LOG = (HaDispatchMessages)MessagesFactory.get(HaDispatchMessages.class);
    public static final Map<String, String> urlToHashLookup = new HashMap<String, String>();
    public static final Map<String, String> hashToUrlLookup = new HashMap<String, String>();
    public static final String FAILOVER_COUNTER_ATTRIBUTE = "dispatch.ha.failover.counter";
    public static final List<String> nonIdempotentRequests = Arrays.asList("POST", "PATCH", "CONNECT");

    public String getServiceRole();

    public URI getDispatchUrl(HttpServletRequest var1);

    public HaConfigurations getHaConfigurations();

    public AtomicReference<String> getActiveURL();

    public void setActiveURL(String var1);

    default public void initializeCommonHaDispatch(HaServiceConfig serviceConfig) {
        this.getHaConfigurations().setLoadBalancingEnabled(serviceConfig.isLoadBalancingEnabled());
        this.getHaConfigurations().setStickySessionsEnabled(this.getHaConfigurations().isLoadBalancingEnabled() && serviceConfig.isStickySessionEnabled());
        if (this.getHaConfigurations().isStickySessionEnabled()) {
            this.getHaConfigurations().setStickySessionCookieName(serviceConfig.getStickySessionCookieName());
        }
        if (StringUtils.isNotBlank((CharSequence)serviceConfig.getStickySessionDisabledUserAgents())) {
            this.getHaConfigurations().setDisableLoadBalancingForUserAgents(Arrays.asList(serviceConfig.getStickySessionDisabledUserAgents().trim().split("\\s*,\\s*")));
        }
        this.setupUrlHashLookup();
        this.setActiveURL(this.getHaConfigurations().getHaProvider().getActiveURL(this.getServiceRole()));
        this.getHaConfigurations().setStickySessionCookieName(this.getHaConfigurations().getStickySessionCookieName() + '-' + this.getServiceRole());
        this.getHaConfigurations().setMaxFailoverAttempts(serviceConfig.getMaxFailoverAttempts());
        this.getHaConfigurations().setFailoverSleep(serviceConfig.getFailoverSleep());
        this.getHaConfigurations().setFailoverNonIdempotentRequestEnabled(serviceConfig.isFailoverNonIdempotentRequestEnabled());
        this.getHaConfigurations().setNoFallbackEnabled(this.getHaConfigurations().isStickySessionEnabled() && serviceConfig.isNoFallbackEnabled());
    }

    default public void setKnoxHaCookie(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse, boolean sslEnabled) {
        if (this.getHaConfigurations().isStickySessionEnabled()) {
            List serviceHaCookies = Collections.emptyList();
            if (inboundRequest.getCookies() != null) {
                serviceHaCookies = Arrays.stream(inboundRequest.getCookies()).filter(cookie -> this.getHaConfigurations().getStickySessionCookieName().equals(cookie.getName())).collect(Collectors.toList());
            }
            if (serviceHaCookies.isEmpty() || !hashToUrlLookup.containsKey(((Cookie)serviceHaCookies.get(0)).getValue())) {
                List urls = this.getHaConfigurations().getHaProvider().getURLs(this.getServiceRole()).stream().filter(u -> u.contains(outboundRequest.getURI().getHost())).collect(Collectors.toList());
                String cookieValue = urlToHashLookup.get(urls.get(0));
                Cookie stickySessionCookie = new Cookie(this.getHaConfigurations().getStickySessionCookieName(), cookieValue);
                stickySessionCookie.setPath(inboundRequest.getContextPath());
                stickySessionCookie.setMaxAge(-1);
                stickySessionCookie.setHttpOnly(true);
                stickySessionCookie.setSecure(sslEnabled);
                outboundResponse.addCookie(stickySessionCookie);
            }
        }
    }

    default public Optional<URI> getBackendFromHaCookie(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest) {
        if (this.getHaConfigurations().isLoadBalancingEnabled() && this.getHaConfigurations().isStickySessionEnabled() && inboundRequest.getCookies() != null) {
            for (Cookie cookie : inboundRequest.getCookies()) {
                if (!this.getHaConfigurations().getStickySessionCookieName().equals(cookie.getName())) continue;
                String backendURLHash = cookie.getValue();
                String backendURL = hashToUrlLookup.get(backendURLHash);
                if (!this.getHaConfigurations().getHaProvider().getURLs(this.getServiceRole()).contains(backendURL)) continue;
                try {
                    return Optional.of(this.updateHostURL(outboundRequest.getURI(), backendURL));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        return Optional.empty();
    }

    default public String hash(String url) {
        return DigestUtils.sha256Hex((String)url);
    }

    default public URI updateHostURL(URI source, String host) throws URISyntaxException {
        URI newUri = new URI(host);
        URIBuilder uriBuilder = new URIBuilder(source);
        uriBuilder.setScheme(newUri.getScheme());
        uriBuilder.setHost(newUri.getHost());
        uriBuilder.setPort(newUri.getPort());
        return uriBuilder.build();
    }

    default public void setupUrlHashLookup() {
        for (String url : this.getHaConfigurations().getHaProvider().getURLs(this.getServiceRole())) {
            String urlHash = this.hash(url);
            urlToHashLookup.put(url, urlHash);
            hashToUrlLookup.put(urlHash, url);
        }
    }

    default public boolean isUserAgentDisabled(HttpServletRequest inboundRequest) {
        String userAgentFromBrowser = StringUtils.isBlank((CharSequence)inboundRequest.getHeader("User-Agent")) ? "" : inboundRequest.getHeader("User-Agent");
        boolean userAgentDisabled = false;
        if (this.getHaConfigurations().getDisableLoadBalancingForUserAgents().stream().anyMatch(userAgentFromBrowser::contains)) {
            userAgentDisabled = true;
            LOG.disableHALoadbalancinguserAgent(userAgentFromBrowser, this.getHaConfigurations().getDisableLoadBalancingForUserAgents().toString());
        }
        return userAgentDisabled;
    }

    default public Optional<URI> setBackendUri(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, boolean userAgentDisabled) {
        Optional<URI> backendURI = Optional.empty();
        if (!userAgentDisabled) {
            backendURI = this.getBackendFromHaCookie(outboundRequest, inboundRequest);
            backendURI.ifPresent(uri -> ((HttpRequestBase)outboundRequest).setURI(uri));
        }
        if (this.getHaConfigurations().isLoadBalancingEnabled() && userAgentDisabled) {
            try {
                ((HttpRequestBase)outboundRequest).setURI(this.updateHostURL(outboundRequest.getURI(), this.getActiveURL().get()));
            }
            catch (URISyntaxException e) {
                LOG.errorSettingActiveUrl();
            }
        }
        return backendURI;
    }

    default public void shiftActiveURL(boolean userAgentDisabled, Optional<URI> backendURI) {
        if (this.getHaConfigurations().isLoadBalancingEnabled() && !userAgentDisabled) {
            if (this.getHaConfigurations().isStickySessionEnabled()) {
                if (!backendURI.isPresent()) {
                    this.getHaConfigurations().getHaProvider().makeNextActiveURLAvailable(this.getServiceRole());
                }
            } else {
                this.getHaConfigurations().getHaProvider().makeNextActiveURLAvailable(this.getServiceRole());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public AtomicInteger markEndpointFailed(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest) {
        CommonHaDispatch commonHaDispatch = this;
        synchronized (commonHaDispatch) {
            this.getHaConfigurations().getHaProvider().markFailedURL(this.getServiceRole(), outboundRequest.getURI().toString());
            AtomicInteger counter = (AtomicInteger)inboundRequest.getAttribute(FAILOVER_COUNTER_ATTRIBUTE);
            if (counter == null) {
                counter = new AtomicInteger(0);
            }
            if (counter.incrementAndGet() <= this.getHaConfigurations().getMaxFailoverAttempts()) {
                this.setupUrlHashLookup();
                this.getActiveURL().set(outboundRequest.getURI().toString());
            }
            return counter;
        }
    }

    default public HttpServletRequest prepareForFailover(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest) {
        inboundRequest.setAttribute("targetRequestUrl", null);
        inboundRequest = new StickySessionCookieRemovedRequest(this.getHaConfigurations().getStickySessionCookieName(), (HttpServletRequest)inboundRequest);
        URI uri = this.getDispatchUrl((HttpServletRequest)inboundRequest);
        ((HttpRequestBase)outboundRequest).setURI(uri);
        if (this.getHaConfigurations().getFailoverSleep() > 0) {
            try {
                Thread.sleep(this.getHaConfigurations().getFailoverSleep());
            }
            catch (InterruptedException e) {
                LOG.failoverSleepFailed(this.getServiceRole(), e);
                Thread.currentThread().interrupt();
            }
        }
        LOG.failingOverRequest(outboundRequest.getURI().toString());
        return inboundRequest;
    }

    default public boolean disabledFailoverHandled(HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException {
        Optional<Object> sessionCookie = Optional.empty();
        if (inboundRequest.getCookies() != null) {
            sessionCookie = Arrays.stream(inboundRequest.getCookies()).filter(cookie -> this.getHaConfigurations().getStickySessionCookieName().equals(cookie.getName())).findFirst();
        }
        if (this.getHaConfigurations().isStickySessionEnabled() && this.getHaConfigurations().isNoFallbackEnabled() && sessionCookie.isPresent()) {
            LOG.noFallbackError();
            outboundResponse.sendError(502, "Service connection error, HA failover disabled");
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isNonIdempotentAndNonIdempotentFailoverDisabled(HttpUriRequest outboundRequest) {
        if (this.getHaConfigurations().isFailoverNonIdempotentRequestEnabled()) return false;
        if (!nonIdempotentRequests.stream().anyMatch(outboundRequest.getMethod()::equalsIgnoreCase)) return false;
        return true;
    }
}

