/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.Objects;

@Schema(description="Arguments to run bandwidth diagnostics as part of performance inspector. Requires iperf3 package installed on hosts.")
public class ApiPerfInspectorBandwidthArgs {
    @SerializedName(value="runBandwidthDiagnostics")
    private Boolean runBandwidthDiagnostics = null;
    @SerializedName(value="bandwidthTimeoutSecs")
    private BigDecimal bandwidthTimeoutSecs = null;

    public ApiPerfInspectorBandwidthArgs runBandwidthDiagnostics(Boolean runBandwidthDiagnostics) {
        this.runBandwidthDiagnostics = runBandwidthDiagnostics;
        return this;
    }

    @Schema(example="false", description="Optional flag to run bandwidth diagnostics test. Exercise caution, running bandwidth test will have an impact on currently running workloads. If not specified, defaults to false.")
    public Boolean isRunBandwidthDiagnostics() {
        return this.runBandwidthDiagnostics;
    }

    public void setRunBandwidthDiagnostics(Boolean runBandwidthDiagnostics) {
        this.runBandwidthDiagnostics = runBandwidthDiagnostics;
    }

    public ApiPerfInspectorBandwidthArgs bandwidthTimeoutSecs(BigDecimal bandwidthTimeoutSecs) {
        this.bandwidthTimeoutSecs = bandwidthTimeoutSecs;
        return this;
    }

    @Schema(example="10", description="Timeout in seconds for the bandwidth request to each target host. If not specified, defaults to 10 seconds.")
    public BigDecimal getBandwidthTimeoutSecs() {
        return this.bandwidthTimeoutSecs;
    }

    public void setBandwidthTimeoutSecs(BigDecimal bandwidthTimeoutSecs) {
        this.bandwidthTimeoutSecs = bandwidthTimeoutSecs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiPerfInspectorBandwidthArgs apiPerfInspectorBandwidthArgs = (ApiPerfInspectorBandwidthArgs)o;
        return Objects.equals(this.runBandwidthDiagnostics, apiPerfInspectorBandwidthArgs.runBandwidthDiagnostics) && Objects.equals(this.bandwidthTimeoutSecs, apiPerfInspectorBandwidthArgs.bandwidthTimeoutSecs);
    }

    public int hashCode() {
        return Objects.hash(this.runBandwidthDiagnostics, this.bandwidthTimeoutSecs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiPerfInspectorBandwidthArgs {\n");
        sb.append("    runBandwidthDiagnostics: ").append(this.toIndentedString(this.runBandwidthDiagnostics)).append("\n");
        sb.append("    bandwidthTimeoutSecs: ").append(this.toIndentedString(this.bandwidthTimeoutSecs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

