/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.subtree;

import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.directory.api.ldap.model.filter.BranchNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.NotNode;
import org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.directory.api.ldap.model.filter.SimpleNode;
import org.apache.directory.server.core.api.subtree.RefinementLeafEvaluator;
import org.apache.directory.server.i18n.I18n;

public class RefinementEvaluator {
    private RefinementLeafEvaluator leafEvaluator;

    public RefinementEvaluator(RefinementLeafEvaluator leafEvaluator) {
        this.leafEvaluator = leafEvaluator;
    }

    public boolean evaluate(ExprNode node, Attribute objectClasses) throws LdapException {
        if (node == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_295, (Object[])new Object[0]));
        }
        if (objectClasses == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_296, (Object[])new Object[0]));
        }
        if (!"2.5.4.0".equals(objectClasses.getAttributeType().getOid())) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_297, (Object[])new Object[0]));
        }
        if (node.isLeaf()) {
            return this.leafEvaluator.evaluate((SimpleNode)node, objectClasses);
        }
        BranchNode bnode = (BranchNode)node;
        if (node instanceof OrNode) {
            for (ExprNode child : bnode.getChildren()) {
                if (!this.evaluate(child, objectClasses)) continue;
                return true;
            }
            return false;
        }
        if (node instanceof AndNode) {
            for (ExprNode child : bnode.getChildren()) {
                if (this.evaluate(child, objectClasses)) continue;
                return false;
            }
            return true;
        }
        if (node instanceof NotNode) {
            if (null != bnode.getFirstChild()) {
                return !this.evaluate(bnode.getFirstChild(), objectClasses);
            }
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_243, (Object[])new Object[]{node}));
        }
        throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_244, (Object[])new Object[]{bnode}));
    }
}

