/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.auth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.security.SubjectUtils;
import org.apache.knox.gateway.service.auth.AuthMessages;

public abstract class AbstractAuthResource {
    public static final String AUTH_ACTOR_ID_HEADER_NAME = "preauth.auth.header.actor.id.name";
    public static final String AUTH_ACTOR_GROUPS_HEADER_PREFIX = "preauth.auth.header.actor.groups.prefix";
    public static final String GROUP_FILTER_PATTERN = "preauth.group.filter.pattern";
    static final AuthMessages LOG = (AuthMessages)MessagesFactory.get(AuthMessages.class);
    static final String DEFAULT_AUTH_ACTOR_ID_HEADER_NAME = "X-Knox-Actor-ID";
    static final String DEFAULT_AUTH_ACTOR_GROUPS_HEADER_PREFIX = "X-Knox-Actor-Groups";
    static final Pattern DEFAULT_GROUP_FILTER_PATTERN = Pattern.compile(".*");
    protected static final int MAX_HEADER_LENGTH = 1000;
    protected static final String ACTOR_GROUPS_HEADER_FORMAT = "%s-%d";
    protected String authHeaderActorIDName;
    protected String authHeaderActorGroupsPrefix;
    protected Pattern groupFilterPattern;

    protected void initialize() {
        this.authHeaderActorIDName = this.getInitParameter(AUTH_ACTOR_ID_HEADER_NAME, DEFAULT_AUTH_ACTOR_ID_HEADER_NAME);
        this.authHeaderActorGroupsPrefix = this.getInitParameter(AUTH_ACTOR_GROUPS_HEADER_PREFIX, DEFAULT_AUTH_ACTOR_GROUPS_HEADER_PREFIX);
        String groupFilterPatternString = this.getInitParameter(GROUP_FILTER_PATTERN, null);
        this.groupFilterPattern = groupFilterPatternString == null ? DEFAULT_GROUP_FILTER_PATTERN : Pattern.compile(groupFilterPatternString);
    }

    abstract HttpServletResponse getResponse();

    abstract ServletContext getContext();

    String getInitParameter(String paramName, String defaultValue) {
        String initParam = this.getContext().getInitParameter(paramName);
        return initParam == null ? defaultValue : initParam;
    }

    public Response doGetImpl() {
        Set<String> matchingGroupNames;
        String primaryPrincipalName;
        Subject subject = SubjectUtils.getCurrentSubject();
        String string = primaryPrincipalName = subject == null ? null : SubjectUtils.getPrimaryPrincipalName((Subject)subject);
        if (primaryPrincipalName == null) {
            LOG.noPrincipalFound();
            return Response.status((int)401).build();
        }
        this.getResponse().setHeader(this.authHeaderActorIDName, primaryPrincipalName);
        Set<String> set = matchingGroupNames = subject == null ? Collections.emptySet() : SubjectUtils.getGroupPrincipals((Subject)subject).stream().filter(group -> this.groupFilterPattern.matcher(group.getName()).matches()).map(group -> group.getName()).collect(Collectors.toSet());
        if (!matchingGroupNames.isEmpty()) {
            List<String> groupStrings = this.getGroupStrings(matchingGroupNames);
            for (int i = 0; i < groupStrings.size(); ++i) {
                this.getResponse().addHeader(String.format(Locale.ROOT, ACTOR_GROUPS_HEADER_FORMAT, this.authHeaderActorGroupsPrefix, i + 1), groupStrings.get(i));
            }
        }
        return Response.ok().build();
    }

    private List<String> getGroupStrings(Collection<String> groupNames) {
        if (groupNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> groupStrings = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (String groupName : groupNames) {
            if (sb.length() + groupName.length() > 1000) {
                groupStrings.add(sb.toString());
                sb = new StringBuilder();
            }
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(groupName);
        }
        if (sb.length() > 0) {
            groupStrings.add(sb.toString());
        }
        return groupStrings;
    }
}

