/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.sse;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import javax.servlet.AsyncContext;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.client.methods.AsyncCharConsumer;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.apache.knox.gateway.dispatch.AsyncDispatch;
import org.apache.knox.gateway.dispatch.ConfigurableDispatch;
import org.apache.knox.gateway.dispatch.DefaultHttpAsyncClientFactory;
import org.apache.knox.gateway.sse.SSECallback;
import org.apache.knox.gateway.sse.SSEException;
import org.apache.knox.gateway.sse.SSEResponse;

public class SSEDispatch
extends ConfigurableDispatch
implements AsyncDispatch {
    protected final HttpAsyncClient asyncClient;
    private static final String TEXT_EVENT_STREAM_VALUE = "text/event-stream";

    public SSEDispatch(FilterConfig filterConfig) {
        DefaultHttpAsyncClientFactory asyncClientFactory = new DefaultHttpAsyncClientFactory();
        this.asyncClient = asyncClientFactory.createAsyncHttpClient(filterConfig);
        if (this.asyncClient instanceof CloseableHttpAsyncClient) {
            ((CloseableHttpAsyncClient)this.asyncClient).start();
        }
    }

    @Override
    public void doGet(URI url, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException {
        HttpGet httpGetRequest = new HttpGet(url);
        this.doHttpMethod((HttpUriRequest)httpGetRequest, inboundRequest, outboundResponse);
    }

    @Override
    public void doPost(URI url, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException, URISyntaxException {
        HttpPost httpPostRequest = new HttpPost(url);
        httpPostRequest.setEntity(this.createRequestEntity(inboundRequest));
        this.doHttpMethod((HttpUriRequest)httpPostRequest, inboundRequest, outboundResponse);
    }

    @Override
    public void doPut(URI url, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException {
        HttpPut httpPutRequest = new HttpPut(url);
        httpPutRequest.setEntity(this.createRequestEntity(inboundRequest));
        this.doHttpMethod((HttpUriRequest)httpPutRequest, inboundRequest, outboundResponse);
    }

    @Override
    public void doPatch(URI url, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException {
        HttpPatch httpPatchRequest = new HttpPatch(url);
        httpPatchRequest.setEntity(this.createRequestEntity(inboundRequest));
        this.doHttpMethod((HttpUriRequest)httpPatchRequest, inboundRequest, outboundResponse);
    }

    private void doHttpMethod(HttpUriRequest httpMethod, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException {
        this.addAcceptHeader(httpMethod);
        this.copyRequestHeaderFields(httpMethod, inboundRequest);
        this.executeRequestWrapper(httpMethod, inboundRequest, outboundResponse);
    }

    @Override
    protected void executeRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) {
        AsyncContext asyncContext = inboundRequest.startAsync();
        asyncContext.setTimeout(0L);
        this.executeAsyncRequest(outboundRequest, outboundResponse, asyncContext, inboundRequest);
    }

    protected void executeAsyncRequest(HttpUriRequest outboundRequest, HttpServletResponse outboundResponse, AsyncContext asyncContext, HttpServletRequest inboundRequest) {
        HttpAsyncRequestProducer producer = HttpAsyncMethods.create((HttpUriRequest)outboundRequest);
        SSECharConsumer consumer = new SSECharConsumer(outboundResponse, outboundRequest.getURI(), asyncContext, inboundRequest, outboundRequest);
        LOG.dispatchRequest(outboundRequest.getMethod(), outboundRequest.getURI());
        auditor.audit("dispatch", outboundRequest.getURI().toString(), "uri", "unavailable", RES.requestMethod(outboundRequest.getMethod()));
        this.asyncClient.execute(producer, (HttpAsyncResponseConsumer)consumer, (FutureCallback)new SSECallback(outboundResponse, asyncContext, producer));
    }

    private void addAcceptHeader(HttpUriRequest outboundRequest) {
        outboundRequest.setHeader("Accept", TEXT_EVENT_STREAM_VALUE);
    }

    private void handleSuccessResponse(HttpServletResponse outboundResponse, URI url, HttpResponse inboundResponse) {
        this.prepareServletResponse(outboundResponse, inboundResponse.getStatusLine().getStatusCode());
        this.copyResponseHeaderFields(outboundResponse, inboundResponse);
        auditor.audit("dispatch", url.toString(), "uri", "success", RES.responseStatus(200));
    }

    private void handleErrorResponse(HttpServletResponse outboundResponse, URI url, HttpResponse httpResponse) {
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        outboundResponse.setStatus(statusCode);
        LOG.dispatchResponseStatusCode(statusCode);
        auditor.audit("dispatch", url.toString(), "uri", "failure", RES.responseStatus(statusCode));
    }

    private void prepareServletResponse(HttpServletResponse outboundResponse, int statusCode) {
        LOG.dispatchResponseStatusCode(statusCode);
        outboundResponse.setStatus(statusCode);
        outboundResponse.setCharacterEncoding(StandardCharsets.UTF_8.name());
    }

    private boolean isSuccessful(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    protected void shiftCallback(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest) {
    }

    @Override
    public void destroy() {
        try {
            if (this.asyncClient != null && this.asyncClient instanceof CloseableHttpAsyncClient) {
                ((CloseableHttpAsyncClient)this.asyncClient).close();
            }
        }
        catch (IOException e) {
            LOG.errorClosingHttpClient(e);
        }
    }

    public HttpAsyncClient getAsyncClient() {
        return this.asyncClient;
    }

    protected class SSECharConsumer
    extends AsyncCharConsumer<SSEResponse> {
        private SSEResponse sseResponse;
        private final HttpServletResponse outboundResponse;
        private final HttpUriRequest outboundRequest;
        private final HttpServletRequest inboundRequest;
        private final URI url;
        private final AsyncContext asyncContext;

        public SSECharConsumer(HttpServletResponse outboundResponse, URI url, AsyncContext asyncContext, HttpServletRequest inboundRequest, HttpUriRequest outboundRequest) {
            this.outboundResponse = outboundResponse;
            this.outboundRequest = outboundRequest;
            this.inboundRequest = inboundRequest;
            this.url = url;
            this.asyncContext = asyncContext;
        }

        protected void onResponseReceived(HttpResponse inboundResponse) {
            this.sseResponse = new SSEResponse(inboundResponse);
            if (SSEDispatch.this.isSuccessful(inboundResponse.getStatusLine().getStatusCode())) {
                SSEDispatch.this.outboundResponseWrapper(this.outboundRequest, this.inboundRequest, this.outboundResponse);
                SSEDispatch.this.handleSuccessResponse(this.outboundResponse, this.url, inboundResponse);
            } else {
                SSEDispatch.this.handleErrorResponse(this.outboundResponse, this.url, inboundResponse);
            }
            SSEDispatch.this.shiftCallback(this.outboundRequest, this.inboundRequest);
        }

        protected void onCharReceived(CharBuffer buf, IOControl ioctl) {
            try {
                if (this.sseResponse.getEntity().readCharBuffer(buf)) {
                    this.sseResponse.getEntity().sendEvent(this.asyncContext);
                }
            }
            catch (IOException | InterruptedException e) {
                LOG.errorWritingOutputStream(e);
                throw new SSEException(e.getMessage(), e);
            }
        }

        protected SSEResponse buildResult(HttpContext context) {
            return this.sseResponse;
        }
    }
}

