/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.chainsaw.helper.SwingHelper;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;

public abstract class AbstractPreferencePanel
extends JPanel {
    private final JLabel titleLabel = new JLabel("Selected Pref Panel");
    private final JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
    private final JPanel selectedPrefPanel = new JPanel(new BorderLayout(0, 3));
    private final JButton okButton = new JButton(" OK ");
    private final JButton cancelButton = new JButton(" Cancel ");
    private ActionListener okCancelListener;
    private Component currentlyDisplayedPanel = null;
    private final JTree prefTree = new JTree();

    protected void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        this.prefTree.setModel(this.createTreeModel());
        this.prefTree.setRootVisible(false);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(ChainsawIcons.ICON_PREFERENCES);
        this.prefTree.setCellRenderer(renderer);
        JScrollPane treeScroll = new JScrollPane(this.prefTree);
        treeScroll.setPreferredSize(new Dimension(200, 240));
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setBorder(BorderFactory.createEtchedBorder());
        this.titleLabel.setBackground(Color.white);
        this.titleLabel.setOpaque(true);
        this.selectedPrefPanel.add((Component)this.titleLabel, "North");
        this.mainPanel.add((Component)treeScroll, "West");
        this.mainPanel.add((Component)this.selectedPrefPanel, "Center");
        this.add((Component)this.mainPanel, "Center");
        Box buttonBox = Box.createHorizontalBox();
        List buttons = SwingHelper.orderOKCancelButtons(this.okButton, this.cancelButton);
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add((JButton)buttons.get(0));
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add((JButton)buttons.get(1));
        this.add((Component)buttonBox, "South");
        DefaultTreeSelectionModel treeSelectionModel = new DefaultTreeSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        this.prefTree.setSelectionModel(treeSelectionModel);
        this.prefTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getNewLeadSelectionPath();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                AbstractPreferencePanel.this.setDisplayedPrefPanel((JComponent)node.getUserObject());
            }
        });
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.prefTree.getModel().getRoot();
        DefaultMutableTreeNode firstNode = (DefaultMutableTreeNode)root.getFirstChild();
        this.prefTree.setSelectionPath(new TreePath(firstNode.getPath()));
    }

    protected abstract TreeModel createTreeModel();

    protected void setDisplayedPrefPanel(JComponent panel) {
        if (this.currentlyDisplayedPanel != null) {
            this.selectedPrefPanel.remove(this.currentlyDisplayedPanel);
        }
        this.selectedPrefPanel.add((Component)panel, "Center");
        this.currentlyDisplayedPanel = panel;
        String title = panel.toString();
        this.titleLabel.setText(title);
        this.selectedPrefPanel.revalidate();
        this.selectedPrefPanel.repaint();
    }

    public void notifyOfLookAndFeelChange() {
        SwingUtilities.updateComponentTreeUI(this);
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.prefTree.getModel().getRoot()).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!(node.getUserObject() instanceof Component)) continue;
            Component c = (Component)node.getUserObject();
            SwingUtilities.updateComponentTreeUI(c);
        }
    }

    public void setOkCancelActionListener(ActionListener l) {
        this.okCancelListener = l;
    }

    public void hidePanel() {
        if (this.okCancelListener != null) {
            this.okCancelListener.actionPerformed(null);
        }
    }

    protected final JButton getCancelButton() {
        return this.cancelButton;
    }

    protected final JButton getOkButton() {
        return this.okButton;
    }
}

