/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.receivers;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.log4j.chainsaw.Generator;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.chainsaw.icons.LevelIconFactory;
import org.apache.log4j.chainsaw.receivers.ReceiversTreeModel;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.spi.Thresholdable;

public class ReceiverTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Icon rootIcon = new ImageIcon(ChainsawIcons.ANIM_NET_CONNECT);
    private JPanel panel = new JPanel();
    private JLabel levelLabel = new JLabel();

    public ReceiverTreeCellRenderer() {
        BoxLayout layout = new BoxLayout(this.panel, 0);
        this.panel.setLayout(layout);
        this.panel.setOpaque(false);
        this.panel.add(this.levelLabel);
        this.setPreferredSize(new Dimension(200, 19));
        this.panel.add(this);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
        Thresholdable t;
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object o = node.getUserObject();
        this.setText(o.toString());
        String tooltip = "";
        this.setIcon(null);
        if (o == ((ReceiversTreeModel)tree.getModel()).getRootNode().getUserObject()) {
            this.setText(o.toString());
        } else if (o instanceof String) {
            this.setText(o.toString());
            this.setIcon(null);
        } else if (o instanceof Plugin) {
            this.setText(((Plugin)o).getName());
        } else if (o instanceof Generator) {
            Generator generator = (Generator)o;
            this.setText(generator.getName());
            this.setIcon(ChainsawIcons.ICON_HELP);
        } else {
            this.setText("(Unknown Type) :: " + o);
        }
        if (o == ((ReceiversTreeModel)tree.getModel()).getRootNode().getUserObject()) {
            this.setIcon(this.rootIcon);
        }
        this.levelLabel.setText(null);
        this.levelLabel.setIcon(null);
        if (o instanceof Thresholdable && (t = (Thresholdable)o).getThreshold() != null) {
            this.levelLabel.setIcon((Icon)LevelIconFactory.getInstance().getLevelToIconMap().get(t.getThreshold().toString()));
            if (this.levelLabel.getIcon() == null) {
                this.levelLabel.setText(t.getThreshold().toString());
            }
        }
        this.setToolTipText(tooltip);
        return this.panel;
    }
}

