/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.chainsaw.ChainsawAppender;
import org.apache.log4j.chainsaw.ChainsawEventBatch;
import org.apache.log4j.chainsaw.EventBatchListener;
import org.apache.log4j.rule.ExpressionRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.LoggingEventFieldResolver;

public class ChainsawAppenderHandler
extends AppenderSkeleton {
    private static final String DEFAULT_IDENTIFIER = "Unknown";
    private final Object mutex = new Object();
    private int sleepInterval = 1000;
    private EventListenerList listenerList = new EventListenerList();
    private double dataRate = 0.0;
    private String identifierExpression;
    private final LoggingEventFieldResolver resolver = LoggingEventFieldResolver.getInstance();
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private Map<String, Rule> customExpressionRules = new HashMap<String, Rule>();
    private WorkQueue worker = new WorkQueue();

    public ChainsawAppenderHandler(ChainsawAppender appender) {
        super(true);
        appender.setAppender(this);
    }

    public ChainsawAppenderHandler() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdentifierExpression(String identifierExpression) {
        Object object = this.mutex;
        synchronized (object) {
            this.identifierExpression = identifierExpression;
            this.mutex.notify();
        }
    }

    public String getIdentifierExpression() {
        return this.identifierExpression;
    }

    public void addCustomEventBatchListener(String identifier, EventBatchListener l) throws IllegalArgumentException {
        this.customExpressionRules.put(identifier, ExpressionRule.getRule(identifier));
        this.listenerList.add(EventBatchListener.class, l);
    }

    public void addEventBatchListener(EventBatchListener l) {
        this.listenerList.add(EventBatchListener.class, l);
    }

    public void removeEventBatchListener(EventBatchListener l) {
        this.listenerList.remove(EventBatchListener.class, l);
    }

    @Override
    public void append(LoggingEvent event) {
        this.worker.enqueue(event);
    }

    @Override
    public void close() {
    }

    @Override
    public boolean requiresLayout() {
        return false;
    }

    public int getQueueInterval() {
        return this.sleepInterval;
    }

    public void setQueueInterval(int interval) {
        this.sleepInterval = interval;
    }

    String getTabIdentifier(LoggingEvent e) {
        String ident = this.resolver.applyFields(this.identifierExpression, e);
        return ident != null ? ident : DEFAULT_IDENTIFIER;
    }

    public double getDataRate() {
        return this.dataRate;
    }

    void setDataRate(double dataRate) {
        double oldValue = this.dataRate;
        this.dataRate = dataRate;
        this.propertySupport.firePropertyChange("dataRate", oldValue, this.dataRate);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(propertyName, listener);
    }

    class WorkQueue {
        final ArrayList<LoggingEvent> queue = new ArrayList();
        Thread workerThread = new WorkerThread();

        protected WorkQueue() {
            this.workerThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void enqueue(LoggingEvent event) {
            Object object = ChainsawAppenderHandler.this.mutex;
            synchronized (object) {
                this.queue.add(event);
                ChainsawAppenderHandler.this.mutex.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void stop() {
            Object object = ChainsawAppenderHandler.this.mutex;
            synchronized (object) {
                this.workerThread.interrupt();
            }
        }

        private class WorkerThread
        extends Thread {
            public WorkerThread() {
                super("Chainsaw-WorkerThread");
                this.setDaemon(true);
                this.setPriority(4);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<LoggingEvent> innerList = new ArrayList<LoggingEvent>();
                while (true) {
                    Object iter2;
                    long timeStart = System.currentTimeMillis();
                    Object object = ChainsawAppenderHandler.this.mutex;
                    synchronized (object) {
                        try {
                            while (WorkQueue.this.queue.size() == 0 || ChainsawAppenderHandler.this.identifierExpression == null) {
                                ChainsawAppenderHandler.this.setDataRate(0.0);
                                ChainsawAppenderHandler.this.mutex.wait();
                            }
                            if (WorkQueue.this.queue.size() > 0) {
                                innerList.addAll(WorkQueue.this.queue);
                                WorkQueue.this.queue.clear();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    int size = innerList.size();
                    if (size > 0) {
                        iter2 = innerList.iterator();
                        ChainsawEventBatch eventBatch = new ChainsawEventBatch();
                        while (iter2.hasNext()) {
                            String remoteHost;
                            LoggingEvent e = (LoggingEvent)iter2.next();
                            if (e.getProperty("hostname") == null && (remoteHost = e.getProperty("log4j.remoteSourceInfo")) != null) {
                                int colonIndex = remoteHost.indexOf(":");
                                if (colonIndex == -1) {
                                    colonIndex = remoteHost.length();
                                }
                                e.setProperty("hostname", remoteHost.substring(0, colonIndex));
                            }
                            for (Map.Entry o : ChainsawAppenderHandler.this.customExpressionRules.entrySet()) {
                                Map.Entry entry = o;
                                Rule rule = (Rule)entry.getValue();
                                if (!rule.evaluate(e, null)) continue;
                                eventBatch.addEvent((String)entry.getKey(), e);
                            }
                            eventBatch.addEvent(ChainsawAppenderHandler.this.getTabIdentifier(e), e);
                        }
                        this.dispatchEventBatch(eventBatch);
                        innerList.clear();
                    }
                    if (ChainsawAppenderHandler.this.getQueueInterval() > 1000) {
                        try {
                            iter2 = this;
                            synchronized (iter2) {
                                this.wait(ChainsawAppenderHandler.this.getQueueInterval());
                            }
                        }
                        catch (InterruptedException iter2) {}
                    } else {
                        Thread.yield();
                    }
                    if (size == 0) {
                        ChainsawAppenderHandler.this.setDataRate(0.0);
                        continue;
                    }
                    long timeEnd = System.currentTimeMillis();
                    long diffInSeconds = (timeEnd - timeStart) / 1000L;
                    double rate = (double)size / (double)diffInSeconds;
                    ChainsawAppenderHandler.this.setDataRate(rate);
                }
            }

            private void dispatchEventBatch(ChainsawEventBatch eventBatch) {
                EventBatchListener[] listeners = (EventBatchListener[])ChainsawAppenderHandler.this.listenerList.getListeners(EventBatchListener.class);
                Iterator<String> iter = eventBatch.identifierIterator();
                while (iter.hasNext()) {
                    String identifier = iter.next();
                    List<LoggingEvent> eventList = null;
                    for (EventBatchListener listener : listeners) {
                        if (listener.getInterestedIdentifier() != null && !listener.getInterestedIdentifier().equals(identifier)) continue;
                        if (eventList == null) {
                            eventList = eventBatch.entrySet(identifier);
                        }
                        listener.receiveEventBatch(identifier, eventList);
                    }
                }
            }
        }
    }
}

