/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.compress.commons;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamProvider;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractCompressAction;

final class CommonsCompressAction
extends AbstractCompressAction {
    private final CompressorStreamProvider provider;
    private final String name;

    CommonsCompressAction(CompressorStreamProvider provider, String name, Path source, Path destination) {
        super(source, destination);
        this.provider = Objects.requireNonNull(provider);
        this.name = Objects.requireNonNull(name, "name");
    }

    protected OutputStream wrapOutputStream(OutputStream stream) throws IOException {
        try {
            return new BufferedOutputStream((OutputStream)this.provider.createCompressorOutputStream(this.name, stream), 8192);
        }
        catch (CompressorException error) {
            String message = String.format("failed to wrap the output stream with the `%s` compressor", this.name);
            throw new IOException(message, error);
        }
    }

    protected String getAlgorithmName() {
        return this.name;
    }
}

