/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jul.internal;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.jul.internal.LevelConverter;
import org.apache.logging.log4j.jul.spi.LevelChangePropagator;
import org.apache.logging.log4j.status.StatusLogger;

public class JulLevelPropagator
implements LevelChangePropagator,
Consumer<Configuration> {
    private static final Logger LOGGER = StatusLogger.getLogger();
    public static final LevelChangePropagator INSTANCE = new JulLevelPropagator();
    private final AtomicInteger installCount = new AtomicInteger();
    private LoggerContext context;
    private final Set<java.util.logging.Logger> julLoggerRefs = new HashSet<java.util.logging.Logger>();

    @Override
    public void start() {
        if (this.installCount.getAndIncrement() == 0) {
            this.context = LoggerContext.getContext((boolean)false);
            LOGGER.info("Installing Log4j Core to JUL level propagator for context `{}`", (Object)this.context);
            this.context.addConfigurationStartedListener((Consumer)this);
            this.propagateLogLevels(this.context.getConfiguration());
        }
    }

    @Override
    public void stop() {
        if (this.installCount.decrementAndGet() == 0) {
            LOGGER.info("Uninstalling Log4j Core to JUL level propagator for context `{}`", (Object)this.context);
            this.context.removeConfigurationStartedListener((Consumer)this);
            this.context = null;
            this.julLoggerRefs.clear();
        }
    }

    @Override
    public void accept(Configuration configuration) {
        this.propagateLogLevels(configuration);
    }

    private void propagateLogLevels(Configuration configuration) {
        java.util.logging.Logger julLog;
        LOGGER.info("Starting Log4j Core to JUL level propagation for configuration `{}`", (Object)configuration);
        this.julLoggerRefs.clear();
        Map log4jLoggers = configuration.getLoggers();
        for (LoggerConfig loggerConfig : log4jLoggers.values()) {
            julLog = java.util.logging.Logger.getLogger(loggerConfig.getName());
            Level julLevel = LevelConverter.toJulLevel(loggerConfig.getLevel());
            julLog.setLevel(julLevel);
            this.julLoggerRefs.add(julLog);
        }
        LogManager julMgr = LogManager.getLogManager();
        Enumeration<String> en = julMgr.getLoggerNames();
        while (en.hasMoreElements()) {
            julLog = julMgr.getLogger(en.nextElement());
            if (julLog == null || julLog.getLevel() == null || "".equals(julLog.getName()) || log4jLoggers.containsKey(julLog.getName())) continue;
            julLog.setLevel(null);
        }
    }
}

