/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AsyncAppender;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.message.AsynchronouslyFormattable;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.jspecify.annotations.Nullable;

public final class InternalAsyncUtil {
    private InternalAsyncUtil() {
    }

    public static Message makeMessageImmutable(Message msg) {
        if (msg != null && !InternalAsyncUtil.canFormatMessageInBackground(msg)) {
            msg.getFormattedMessage();
        }
        return msg;
    }

    private static boolean canFormatMessageInBackground(Message message) {
        return Constants.FORMAT_MESSAGES_IN_BACKGROUND || message.getClass().isAnnotationPresent(AsynchronouslyFormattable.class);
    }

    public static void makeLocationImmutable(AsyncAppender appender, LogEvent event) {
        InternalAsyncUtil.makeLocationImmutable(appender.isIncludeLocation(), event);
    }

    public static void makeLocationImmutable(LoggerConfig loggerConfig, LogEvent event) {
        InternalAsyncUtil.makeLocationImmutable(loggerConfig.isIncludeLocation(), event);
    }

    private static void makeLocationImmutable(boolean includeLocation, LogEvent event) {
        if (includeLocation) {
            event.getSource();
        } else {
            event.setIncludeLocation(includeLocation);
        }
    }

    public static @Nullable StackTraceElement getLocation(String fqcn, @Nullable StackTraceElement location, boolean requiresLocation) {
        return location != null ? location : (requiresLocation ? StackLocatorUtil.calcLocation((String)fqcn) : null);
    }
}

