/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.arbiters;

import org.apache.logging.log4j.core.config.arbiters.Arbiter;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Factory;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.util.LoaderUtil;

@Configurable(elementType="Arbiter", printObject=true, deferChildren=true)
@Plugin
public class ClassArbiter
implements Arbiter {
    private final String className;

    private ClassArbiter(String className) {
        this.className = className;
    }

    @Override
    public boolean isCondition() {
        return LoaderUtil.isClassAvailable((String)this.className);
    }

    @Factory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<ClassArbiter> {
        public static final String ATTR_CLASS_NAME = "className";
        @PluginBuilderAttribute(value="className")
        private String className;

        public Builder setClassName(String className) {
            this.className = className;
            return this.asBuilder();
        }

        public Builder asBuilder() {
            return this;
        }

        @Override
        public ClassArbiter build() {
            return new ClassArbiter(this.className);
        }
    }
}

