/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.value;

import java.util.function.Consumer;
import org.apache.solr.analytics.facet.compare.ExpressionComparator;
import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.ComparableValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.analytics.value.constant.ConstantStringValue;

public interface StringValue
extends StringValueStream,
AnalyticsValue {
    public String getString();

    public static abstract class AbstractStringValue
    implements CastingStringValue {
        @Override
        public String getObject() {
            return this.getString();
        }

        @Override
        public void streamStrings(Consumer<String> func) {
            String val = this.getString();
            if (this.exists()) {
                func.accept(val);
            }
        }

        @Override
        public void streamObjects(Consumer<Object> func) {
            String val = this.getObject();
            if (this.exists()) {
                func.accept(val);
            }
        }

        @Override
        public AnalyticsValue convertToConstant() {
            if (this.getExpressionType().equals((Object)AnalyticsValueStream.ExpressionType.CONST)) {
                return new ConstantStringValue(this.getString());
            }
            return this;
        }

        @Override
        public ExpressionComparator<String> getObjectComparator(String expression) {
            return new ExpressionComparator<String>(expression);
        }
    }

    public static interface CastingStringValue
    extends StringValue,
    ComparableValue {
    }
}

