/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.anttasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.IOUtils;
import org.apache.rat.Defaults;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.util.HeaderMatcherMultiplexer;
import org.apache.rat.anttasks.ResourceCollectionContainer;
import org.apache.rat.api.RatException;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.report.IReportable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Report
extends Task {
    private Union nestedResources;
    private ArrayList<IHeaderMatcher> licenseMatchers = new ArrayList();
    private ArrayList<ILicenseFamily> licenseNames = new ArrayList();
    private boolean addDefaultLicenseMatchers = true;
    private File reportFile;
    private Format format = Format.PLAIN;
    private Resource stylesheet;
    private AddLicenseHeaders addLicenseHeaders = new AddLicenseHeaders("false");
    private String copyrightMessage;

    public void add(ResourceCollection rc) {
        if (this.nestedResources == null) {
            this.nestedResources = new Union();
        }
        this.nestedResources.add(rc);
    }

    public void add(IHeaderMatcher matcher) {
        this.licenseMatchers.add(matcher);
    }

    public void add(ILicenseFamily license) {
        this.licenseNames.add(license);
    }

    public void setAddDefaultLicenseMatchers(boolean addDefaultLicenseMatchers) {
        this.addDefaultLicenseMatchers = addDefaultLicenseMatchers;
    }

    public void setReportFile(File f) {
        this.reportFile = f;
    }

    public void setFormat(Format f) {
        if (f == null) {
            throw new IllegalArgumentException("format must not be null");
        }
        this.format = f;
    }

    public void setAddLicenseHeaders(AddLicenseHeaders pAdd) {
        if (pAdd == null) {
            throw new IllegalArgumentException("addLicenseHeaders must not be null");
        }
        this.addLicenseHeaders = pAdd;
    }

    public void setCopyrightMessage(String pMessage) {
        this.copyrightMessage = pMessage;
    }

    public void addConfiguredStylesheet(Union u) {
        if (this.stylesheet != null || u.size() != 1) {
            throw new BuildException("You must not specify more than one stylesheet.");
        }
        this.stylesheet = (Resource)u.iterator().next();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        this.validate();
        PrintWriter out = null;
        try {
            out = this.reportFile == null ? new PrintWriter(new OutputStreamWriter((OutputStream)new LogOutputStream((Task)this, 2))) : new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.reportFile), Charset.forName("UTF-8")));
            this.createReport(out);
            out.flush();
        }
        catch (IOException ioex) {
            try {
                throw new BuildException((Throwable)ioex);
                catch (TransformerException e) {
                    throw new BuildException((Throwable)e);
                }
                catch (InterruptedException e) {
                    throw new BuildException((Throwable)e);
                }
                catch (RatException e) {
                    throw new BuildException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(out);
    }

    private void validate() {
        if (this.nestedResources == null) {
            throw new BuildException("You must specify at least one file to create the report for.");
        }
        if (!this.addDefaultLicenseMatchers && this.licenseMatchers.size() == 0) {
            throw new BuildException("You must specify at least one license matcher");
        }
        if (this.format.getValue().equals("styled")) {
            if (this.stylesheet == null) {
                throw new BuildException("You must specify a stylesheet when using the 'styled' format");
            }
            if (!this.stylesheet.isExists()) {
                throw new BuildException("Cannot find specified stylesheet '" + this.stylesheet + "'");
            }
        } else if (this.stylesheet != null) {
            this.log("Ignoring stylesheet '" + this.stylesheet + "' when using format '" + this.format.getValue() + "'", 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createReport(PrintWriter out) throws IOException, TransformerException, InterruptedException, RatException {
        ReportConfiguration configuration = new ReportConfiguration();
        configuration.setHeaderMatcher(new HeaderMatcherMultiplexer(this.getLicenseMatchers()));
        configuration.setApprovedLicenseNames(this.getApprovedLicenseNames());
        configuration.setApproveDefaultLicenses(this.addDefaultLicenseMatchers);
        if ("forced".equalsIgnoreCase(this.addLicenseHeaders.getValue())) {
            configuration.setAddingLicenses(true);
            configuration.setAddingLicensesForced(true);
            configuration.setCopyrightMessage(this.copyrightMessage);
        } else if ("true".equalsIgnoreCase(this.addLicenseHeaders.getValue())) {
            configuration.setAddingLicenses(true);
            configuration.setCopyrightMessage(this.copyrightMessage);
        } else if (!"false".equalsIgnoreCase(this.addLicenseHeaders.getValue())) {
            throw new BuildException("Invalid value for addLicenseHeaders: " + this.addLicenseHeaders.getValue());
        }
        ResourceCollectionContainer rcElement = new ResourceCollectionContainer((ResourceCollection)this.nestedResources);
        if (this.format.getValue().equals("xml")) {
            org.apache.rat.Report.report(rcElement, out, configuration);
            return;
        }
        InputStream style = null;
        try {
            if (this.format.getValue().equals("plain")) {
                style = Defaults.getPlainStyleSheet();
            } else {
                if (!this.format.getValue().equals("styled")) throw new BuildException("unsupported format '" + this.format.getValue() + "'");
                style = this.stylesheet.getInputStream();
            }
            org.apache.rat.Report.report(out, (IReportable)rcElement, style, configuration);
        }
        catch (Throwable throwable) {
            FileUtils.close(style);
            throw throwable;
        }
        FileUtils.close((InputStream)style);
    }

    private List<IHeaderMatcher> getLicenseMatchers() {
        ArrayList<IHeaderMatcher> matchers = new ArrayList<IHeaderMatcher>((this.addDefaultLicenseMatchers ? Defaults.DEFAULT_MATCHERS.size() : 0) + this.licenseMatchers.size());
        if (this.addDefaultLicenseMatchers) {
            matchers.addAll(Defaults.DEFAULT_MATCHERS);
            matchers.addAll(this.licenseMatchers);
        } else {
            matchers = new ArrayList<IHeaderMatcher>(this.licenseMatchers);
        }
        return matchers;
    }

    private ILicenseFamily[] getApprovedLicenseNames() {
        ILicenseFamily[] results = null;
        if (this.licenseNames.size() > 0) {
            results = this.licenseNames.toArray(new ILicenseFamily[0]);
        }
        return results;
    }

    public static class AddLicenseHeaders
    extends EnumeratedAttribute {
        static final String TRUE = "true";
        static final String FALSE = "false";
        static final String FORCED = "forced";

        public AddLicenseHeaders() {
        }

        public AddLicenseHeaders(String s) {
            this.setValue(s);
        }

        public String[] getValues() {
            return new String[]{TRUE, FALSE, FORCED};
        }
    }

    public static class Format
    extends EnumeratedAttribute {
        static final String XML_KEY = "xml";
        static final String STYLED_KEY = "styled";
        static final String PLAIN_KEY = "plain";
        static final Format PLAIN = new Format("plain");

        public Format() {
        }

        private Format(String s) {
            this();
            this.setValue(s);
        }

        public String[] getValues() {
            return new String[]{XML_KEY, STYLED_KEY, PLAIN_KEY};
        }
    }
}

