<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->
---
layout: default
title: Books Tutorials and Talks

    
---
# Intro

This page is a place for info about talks (past and upcoming), tutorials, articles, books, slides, PDFs, discussions, etc. about Mahout. No endorsements are implied or
given.

# Books

## Mahout specific

   * <a href="http://www.weatheringthroughtechdays.com/2016/02/mahout-samsara-book-is-out.html">Apache Mahout: Beyond MapReduce</a> by Dmitriy Lyubimov and Andrew Palumbo published Feb 2016. Covers new features in Mahout "Samsara" releases (0.10, 0.11+).
   * <a href="http://www.packtpub.com/apache-mahout-cookbook/book">Apache Mahout cookbook</a>- Book by Piero Giacomelli published Dec 2013 by Packtpub.
   * <a href="http://www.manning.com/owen/">Mahout in Action</a> - Book by Sean Owen, Robin Anil, Ted Dunning and Ellen Friedman published Oct 2011 by Manning Publications.
   * <a href="http://www.manning.com/ingersoll/">Taming Text</a> - By Grant Ingersoll and Tom Morton, published by Manning Publications. Will have some Mahout coverage, but by no means as complete as Mahout in Action.

## Engineering oriented machine learning books

   * <a href="http://www.amazon.com/Collective-Intelligence-Action-Satnam-Alag/dp/1933988312/ref=pd_bbs_sr_3?ie=UTF8&s=books&qid=1214545249&sr=1-3">Collective Intelligence in Action</a>
   * <a href="http://www.amazon.com/Programming-Collective-Intelligence-Building-Applications/dp/0596529325/ref=pd_bbs_sr_1/104-1017533-9408723?ie=UTF8&s=books&qid=1214593516&sr=1-1">Programming Collective Intelligence</a>
   * <a href="http://www.amazon.com/Algorithms-Intelligent-Web-Haralambos-Marmanis/dp/1933988665/ref=sr_1_1?s=books&ie=UTF8&qid=1298005918&sr=1-1">Algorithms of the Intelligent Web</a>

## Scientific background

   * <a href="http://www.cs.waikato.ac.nz/~ml/weka/book.html">Data Mining: Practical Machine Learning Tools and Techniques</a>
   * <a href="http://www-nlp.stanford.edu/IR-book/">Introduction to Information Retrieval</a>
   * <a href="http://www.amazon.com/Machine-Learning-Mcgraw-Hill-International-Edit/dp/0071154671/ref=pd_bbs_sr_1?ie=UTF8&s=books&qid=1214593709&sr=8-1">Machine Learning</a>
   * <a href="http://www.amazon.com/Pattern-Recognition-Learning-Information-Statistics/dp/0387310738/ref=pd_bbs_sr_2?ie=UTF8&s=books&qid=1214593709&sr=8-2">Pattern Recognition and Machine Learning (Information Science and Statistics) </a>

# News, Articles and Tutorials

   * [Mahout 0.10.x: first Mahout release as a programming environment](http://www.weatheringthroughtechdays.com/2015/04/mahout-010x-first-mahout-release-as.html)   
   * [Comparing Document Classification Functions of Lucene and Mahout](http://soleami.com/blog/comparing-document-classification-functions-of-lucene-and-mahout.html)
   * <a href="http://www.ibm.com/developerworks/java/library/j-mahout-scaling/">Apache Mahout: Scalable Machine Learning for Everyone</a>
   * <a href="http://emmaespina.wordpress.com/2011/04/26/ham-spam-and-elephants-or-how-to-build-a-spam-filter-server-with-mahout/">How to build a spam filter server with Mahout</a> - Applying classification on a live server - April 2011
   * <a href="http://ssc.io/deploying-a-massively-scalable-recommender-system-with-apache-mahout/">Deploying a massively scalable recommender system with Apache Mahout</a> - Blogpost of Sebastian Schelter in April 2011
   * <a href="http://www.redmonk.com/cote/2010/11/04/makeall013/">Apache Mahout & the commoditization of machine learning </a> - Podcast interview with Grant Ingersoll at ApacheCon 2010
   * <a href="http://isabel-drost.de/hadoop/slides/devoxx.pdf">Apache Mahout 0.4 mit neuen Algorithmen</a> - published after the 0.4 release by heise Open/ Developer, November 2010
   * <a href="http://www.infoq.com/news/2009/04/mahout">Mahout on InfoQ</a> - Interview with Grant Ingersoll on InfoQ
   * <a href="http://www.cloudera.com/blog/2009/04/21/hadoop-uk-user-group-meeting/">Mahout in the Cloudera weblog</a> - published after the Hadoop user group UK.
   * <a href="http://blog.athico.com/2008/08/machine-learning-and-apache-mahout.html">Mahout in the Drools weblog</a> - Michael Neale published an article on Mahout in the drools weblog
   * <a href="https://www.ibm.com/developerworks/java/library/j-mahout/index.html">Introducing Apache Mahout</a> - Grant Ingersoll - Intro to Apache Mahout focused on clustering, classification and collaborative filtering. Japanese translation available at: [http://www.ibm.com/developerworks/jp/java/library/j-mahout/](http://www.ibm.com/developerworks/jp/java/library/j-mahout/)
   * <a href="http://philippeadjiman.com/blog/2009/11/11/flexible-collaborative-filtering-in-java-with-mahout-taste/">Flexible Collaborative Filtering In Java With Mahout Taste</a> - Philippe Adjiman - Quick starting guide on how to use the collaborative filtering package of Mahout (called Taste) to quickly and flexibly create, test and compare tailored recommendation engines.
   * <a href="http://www.lucidimagination.com/blog/2010/03/16/integrating-apache-mahout-with-apache-lucene-and-solr-part-i-of-3/">Integrating Mahout with Lucene and Solr</a> Three part series on ways to integrate Mahout with Lucene and Solr
   * <a href="https://www.youtube.com/watch?v=yD40rVKUwPI">Mahout Item Recommender Tutorial using Java and Eclipse</a> - YouTube video tutorial by Steve Cook


# Coursework/Lectures

   * <a href="http://videolectures.net/mlss05us_chicago/">http://videolectures.net/mlss05us_chicago/</a>
   * <a href="http://videolectures.net/mlas06_pittsburgh/">http://videolectures.net/mlas06_pittsburgh/</a>
   * <a href="http://see.stanford.edu/see/lecturelist.aspx?coll=348ca38a-3a6d-4052-937d-cb017338d7b1">Stanford Lectures on Machine Learning by Andrew Ng</a>
   * <a href="https://docs.google.com/open?id=0ByhGL2_SCeitMDQ3OTczNjItM2ZjYi00ZDg5LWE0MzItZGQxODQ5NzkzYjNj">CMU@Qatar Introduction to Mahout lecture</a>


# Talks

In reverse chronological order, so that most recent talks are at the top

   * [Distributed Machine Learning with Apache Mahout] Suneel Marthi at Apache Big Data North America, Vancouver, Canada, May 11, 2016 and MapR Washington DC Big Data Everywhere, Tysons, VA, June 2 2016
   * [Declarative Machine Learning with the Samsara DSL](http://www.slideshare.net/FlinkForward/sebastian-schelter-distributed-machine-learing-with-the-samsara-dsl) Sebastian Schelter at Flink Forward Conference, Berlin Germany, October 2015.
   * [Bringing Algebraic Semantics to Mahout](http://www.slideshare.net/sscdotopen/bringing-algebraic-semantics-to-mahout) Sebastian Schelter at HPI Infolunch, Potsdam Germany, May 2014
   * Mahout Spark and Scala bindings: Bringing Algebraic Semantics ([slides](http://www.slideshare.net/DmitriyLyubimov/mahout-scala-and-spark-bindings)/[video](http://youtu.be/h9dpmvNW1Dw)) - Dmitriy Lyubimov at Mahout Meetup, April 17, 2014. 
   * Mahout Future Directions - Ted Dunning, Suneel Marthi, Sebastian Schelter at Hadoop Summit Europe 2014, Amsterdam, April 3, 2014
   * Building Recommender Systems for Mere-Mortals - Sebastian Schelter at Researchgate Developer Day, Berlin, November 2013
   * Recommendations with Apache Mahout - Sebastian Schelter at IBM Almaden Research Center, San Jose, September 2013
   * <a href="http://de.slideshare.net/sscdotopen/next-directions-in-mahouts-recommenders">Next Directions in Mahout’s Recommenders</a> - Sebastian Schelter at Bay Area Mahout Meetup, Redwood City, August 2013 
   * <a href="http://de.slideshare.net/sscdotopen/new-directions-in-mahouts-recommenders">New Directions in Mahout’s Recommenders</a> - Sebastian Schelter at Recommender Systems Get Together Berlin, April 2013
   * <a href="http://www.slideshare.net/VaradMeru/introduction-to-mahout-and-machine-learning">Introduction to Mahout and Machine Learning</a> - Slides by Varad Meru, Software Development Engineer at Orzota. July 27th, 2013.
   * <a href="http://de.slideshare.net/sscdotopen/introduction-to-collaborative-filtering-with-apache-mahout">An Introduction to Collaborative Filtering with Apache Mahout</a> - Sebastian Schelter at Recommender Systems Challenge Workshop in conjunction with ACM RecSys 2012, Dublin, September 2012
   * <a href="https://github.com/ManuelB/facebook-recommender-demo/raw/master/docs/Talk-BedCon-Berlin-2012.pdf">How to build a recommender system based on Mahout and JavaEE</a> - Slides by Manuel Blechschmidt at Berlin Expert Days March, 2012.
   * <a href="http://lanyrd.com/2011/apachecon-north-america/skdtb/">Apache Mahout for intelligent data analysis</a> - Slides from Isabel Drost at Apache Con NA November, 2011.
   * <a href="http://lanyrd.com/2011/apachecon-north-america/skdrk/">Dr. Mahout: Analyzing clinical data using scalable and distributed computing</a> - Slides from Shannon Quinn at Apache Con NA November, 2011.
   * Frank Scholten at Berlin Buzzwords on June 7, 2011.
   * Introduction to Collaborative Filtering using Mahout (updated) - Talk by Sean Owen at the London Hadoop User Group on April 14, 2011.
   *  <a href="http://www.meetup.com/LA-HUG/pages/Video_from_March_16th_LA-HUG_Ted_Dunning_Mahout">Cool Tricks with Classifiers</a> - Talk by Ted Dunning at the Los Angeles HUG talking about Mahout classifiers on March 16, 2011.
   * First Mahout Hackathon, Berlin, March 2011
   * <a href="http://blog.jteam.nl/2011/01/13/announcement-lucene-nl-mahout-meetup-with-isabel-drost-feb-7/">Mahout meetup</a> - there were two talks at the Apache Mahout meetup at JTeam in Amsterdam, February 2011. <a href="http://isabel-drost.de/hadoop/slides/jteam.pdf">intro slides</a>
   * <a href="http://www.fosdem.org/2011/schedule/event/mahoutclustering.html">Mahout clustering </a> - Talk on Mahout clustering at data dev room FOSDEM, February 2011.
   * Scaling Data Analysis with Apache Mahout - talk on Mahout at O'Reilly Strata, February 2011. 
   * <a href="http://www.slideshare.net/jaganadhg/mahout-tutorial-fossmeet-nitc">Practical Machine Learning</a> - Slides from Biju B and Jaganadh G, FOSSMEET-NITC, Calicut, India, February 2011.
   * <a href="http://www.javaedge.com/jedge/pdf/Mahout.pdf">Mahout at AlphaCSPs The Edge 2010 (pdf)</a> - <a href="http://www.slideshare.net/arikogan/mahouts-presentation-at-alphacsps-the-edge-2010">slideshare</a> - Slides from <a href="http://il.linkedin.com/in/arielkogan">Ariel Kogan</a> AlphaCSP's The Edge, December 2010.
   * <a href="http://isabel-drost.de/hadoop/slides/devoxx.pdf">Intelligent data analysis with Apache Mahout</a> - Slides from Isabel Drost, Devoxx Antwerp, November 2010.
   * <a href="http://isabel-drost.de/hadoop/slides/codebits.pdf">Apache Mahout introduction</a> - Slides from Isabel Drost, codebits Lisbon, November 2010.
   * <a href="http://isabel-drost.de/hadoop/slides/apachecon_2010.pdf">Apache Mahout - Making Data Analysis Easy</a> - Slides from Isabel Drost, Apache Con US Atlanta, November 2010.
   * <a href="http://www.slideshare.net/jaganadhg/bck9">Practical Machine Learning</a> - Slides from Jaganadh G, BarCamp Kerala 9, November 2010.
   * <a href="http://www.slideshare.net/tdunning/sdforum-11042010">Mahout and its new classification framework</a> - Slides from Ted Dunning, SDForum, November 2010.
   * <a href="http://www.slideshare.net/sscdotopen/mahoutcf">Distributed Item-based Collaborative Filtering with Apache Mahout</a> - Slides from Sebastian Schelter, Hadoop Get Together Berlin, October 2010.
   * <a href="http://isabel-drost.de/hadoop/slides/HMM.pdf">Hidden Markov Models for Mahout</a> - Slides from Max Heimel, Hadoop Get Together Berlin, October 2010.
   * <a href="http://www.slideshare.net/robinanil/oscon-apache-mahout-mammoth-scale-machine-learning">Apache Mahout Mammoth Scale Machine Learning </a> - Slides from Robin Anil, OSCON 2010.
   * <a href="http://slidesha.re/9LxOIu">Intro to Apache Mahout</a> - Slides from Grant Ingersoll,  RTP Semantic Web Group.
   * <a href="http://www.slideshare.net/ydn/3-biometric-hadoopsummit2010">Case study: Biometric Databases and Hadoop </a> - Slides from Jason Trost, Hadoop Summit 2010.
   * <a href="http://www.slideshare.net/hadoopusergroup/mail-antispam?from=ss_embed">Spam Fighting at Yahoo</a>
   * <a href="http://www.slideshare.net/hadoopusergroup/bixo-hug-talk?from=ss_embed">Web Mining with Ken Krugler</a>
   * <a href="http://berlinbuzzwords.wikidot.com/local--files/links-to-slides/ingersoll_bbuzz2010.pdf">Keynote on intelligent search</a> - Slides from Grant Ingersoll, Berlin Buzzwords, June 2010.
   * <a href="http://berlinbuzzwords.wikidot.com/local--files/links-to-slides/owen_bbuzz2010.pdf">Simple co-occurrence-based recommendation on Hadoop</a> - Slides from Sean Owen, Berlin Buzzwords, June, 2010.
   * <a href="http://berlinbuzzwords.wikidot.com/local--files/links-to-slides/scholten_bbuzz2010.odp">Introduction to Collaborative Filtering using Mahout</a> - Slides from Frank Scholten, Berlin Buzzwords, June, 2010.
   * <a href="http://lucene.grantingersoll.com/2010/02/16/trijug-intro-to-mahout-slides-and-demo-examples/">Introduction to Scalable Machine Learning</a> - Slides and demos from Grant Ingersoll, March, 2010.
   * Mahout @ India Hadoop Summit - Slides from a 1 hour talk on Mahout at the India Hadoop Summit by Robin Anil, February 2010.
   * <a href="http://www.isabel-drost.de/hadoop/slides/opensourceexpo09.pdf">Mahout in 10 minutes</a> - Slides from a 10 min intro to Mahout at the Map Reduce tutorial by David Z&uuml;lke at Open Source Expo in Karlsruhe, Isabel Drost, November 2009.
   * <a href="http://www.isabel-drost.de/hadoop/slides/apacheconus2009.pdf">Mahout at Apache Con US </a> - Slides from a talk on "Going from raw data to information" (with Mahout) at Apache Con US in Oakland, Isabel Drost, November 2009.
   * <a href="http://www.isabel-drost.de/hadoop/slides/froscon2009.pdf">Mahout at FrOSCon</a> - Slides from a talk on Mahout at FrOSCon in Sankt Augustin, Isabel Drost, August 2009.
   * <a href="http://www.isabel-drost.de/hadoop/slides/dai.pdf">Mahout at DAI group TU Berlin</a> - Slides from a talk on Mahout at the DAI Laboratories TU Berlin, Isabel Drost, July 2009.
   * <a href="http://www.isabel-drost.de/hadoop/slides/ulf.pdf">Mahout at Machine Learning Group TU Berlin</a> - Slides from a talk on Hadoop with some detour to Mahout at the Machine
   * Learning Group of Prof. Dr. Klaus-Robert M&uuml;ller at TU Berlin, Isabel Drost, June 2009.
   * <a href="http://www.isabel-drost.de/hadoop/slides/google.pdf">Mahout at Google Z&uuml;rich</a> - Slides from a Google tech-talk on the past, present and future of Mahout, Isabel Drost, May 2009.
   * <a href="http://static.last.fm/johan/huguk-20090414/isabel_drost-introducing_apache_mahout.pdf">Hadoop user group UK</a> - Slides from a talk on April 14, 2009 at the Hadoop User Group UK in London, Isabel Drost, April 2009.
   * <a href="http://cwiki.apache.org/confluence/download/attachments/88410/SDForum.pdf">BI Over Petabytes: Meet Apache Mahout</a> - Slides from a talk by Jeff Eastman on April 21, 2009 at the Bay Area SD Forum Business Intelligence SIG meeting at SAP in Palo Alto, CA.
   * Lucene Meetup and Apache Barcamp in Amsterdam, March 2009.
   * BarCampRDU - (Raleigh) on Aug. 2, 2008
   * Introducing Mahout: Apache Machine Learning - Committer Grant Ingersoll gave a gentle introduction to Mahout and Machine Learning at ApacheCon in November (3rd through 7th) in New Orleans, USA. 
   * Mahout: Scaling Machine Learning - Introduction to Mahout and machine learning at FrOSCon in Sankt Augustin/Germany, Isabel Drost, August 2008.  (<a href="http://cwiki.apache.org/confluence/download/attachments/88410/froscon.pdf">slides</a>)
   * Mahout: Scalable Machine Learning - An introduction to Mahout and machine learning at the first German Hadoop gathering in newthinking store/ Berlin, Isabel Drost, July 2008.
   * Apache Mahout: Industrial Strength Machine Learning - Committer Jeff Eastman gave an introduction to Mahout at Yahoo\!, May 2008
   * <a href="http://people.apache.org/~berndf/openexpode08-lucene-talk.pdf">Apache Lucene - Mach's wie Google</a> - Bernd Fondermann presented an overview of the Apache Lucene project,
   * including Mahout at Open Source Expo 2008 in Karlsruhe, May 2008.
   * Apache Mahout: Bringing Machine Learning to Industrial Strength - Committer Isabel Drost gave a Fast Feather introduction the the new project Mahout at Apache Con EU April, 2008