/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.browser;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.AbstractBrowserBindingService;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.ClientTypeCacheImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.FormDataWriter;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.ReturnVersion;
import org.apache.chemistry.opencmis.commons.impl.TypeCache;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.commons.spi.VersioningService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersioningServiceImpl
extends AbstractBrowserBindingService
implements VersioningService {
    public VersioningServiceImpl(BindingSession session) {
        this.setSession(session);
    }

    public void checkOut(String repositoryId, Holder<String> objectId, ExtensionsData extension, Holder<Boolean> contentCopied) {
        if (objectId == null || objectId.getValue() == null || ((String)objectId.getValue()).length() == 0) {
            throw new CmisInvalidArgumentException("Object id must be set!");
        }
        UrlBuilder url = this.getObjectUrl(repositoryId, (String)objectId.getValue());
        final FormDataWriter formData = new FormDataWriter("checkOut");
        formData.addSuccinctFlag(this.getSuccinct());
        Response resp = this.post(url, formData.getContentType(), new Output(){

            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        ObjectData newObj = JSONConverter.convertObject(json, (TypeCache)typeCache);
        objectId.setValue((Object)(newObj == null ? null : newObj.getId()));
    }

    public void cancelCheckOut(String repositoryId, String objectId, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId);
        final FormDataWriter formData = new FormDataWriter("cancelCheckOut");
        this.postAndConsume(url, formData.getContentType(), new Output(){

            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
    }

    public void checkIn(String repositoryId, Holder<String> objectId, Boolean major, Properties properties, ContentStream contentStream, String checkinComment, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        if (objectId == null || objectId.getValue() == null || ((String)objectId.getValue()).length() == 0) {
            throw new CmisInvalidArgumentException("Object id must be set!");
        }
        UrlBuilder url = this.getObjectUrl(repositoryId, (String)objectId.getValue());
        final FormDataWriter formData = new FormDataWriter("checkIn", contentStream);
        formData.addParameter("major", major);
        formData.addPropertiesParameters(properties);
        formData.addParameter("checkinComment", checkinComment);
        formData.addPoliciesParameters(policies);
        formData.addAddAcesParameters(addAces);
        formData.addRemoveAcesParameters(removeAces);
        formData.addSuccinctFlag(this.getSuccinct());
        Response resp = this.post(url, formData.getContentType(), new Output(){

            public void write(OutputStream out) throws IOException {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        ObjectData newObj = JSONConverter.convertObject(json, (TypeCache)typeCache);
        objectId.setValue((Object)(newObj == null ? null : newObj.getId()));
    }

    public ObjectData getObjectOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId, "object");
        url.addParameter("filter", (Object)filter);
        url.addParameter("includeAllowableActions", (Object)includeAllowableActions);
        url.addParameter("includeRelationships", (Object)includeRelationships);
        url.addParameter("renditionFilter", (Object)renditionFilter);
        url.addParameter("includePolicyIds", (Object)includePolicyIds);
        url.addParameter("includeACL", (Object)includeAcl);
        url.addParameter("returnVersion", (Object)(major == null || Boolean.FALSE.equals(major) ? ReturnVersion.LATEST : ReturnVersion.LASTESTMAJOR));
        url.addParameter("succinct", (Object)this.getSuccinctParameter());
        Response resp = this.read(url);
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        return JSONConverter.convertObject(json, (TypeCache)typeCache);
    }

    public Properties getPropertiesOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId, "properties");
        url.addParameter("filter", (Object)filter);
        url.addParameter("returnVersion", (Object)(major == null || Boolean.FALSE.equals(major) ? ReturnVersion.LATEST : ReturnVersion.LASTESTMAJOR));
        url.addParameter("succinct", (Object)this.getSuccinctParameter());
        Response resp = this.read(url);
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        if (this.getSuccinct()) {
            ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
            return JSONConverter.convertSuccinctProperties(json, null, (TypeCache)typeCache);
        }
        return JSONConverter.convertProperties(json, null);
    }

    public List<ObjectData> getAllVersions(String repositoryId, String objectId, String versionSeriesId, String filter, Boolean includeAllowableActions, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId, "versions");
        url.addParameter("filter", (Object)filter);
        url.addParameter("includeAllowableActions", (Object)includeAllowableActions);
        url.addParameter("succinct", (Object)this.getSuccinctParameter());
        Response resp = this.read(url);
        List<Object> json = this.parseArray(resp.getStream(), resp.getCharset());
        ClientTypeCacheImpl typeCache = new ClientTypeCacheImpl(repositoryId, this);
        return JSONConverter.convertObjects(json, (TypeCache)typeCache);
    }
}

