/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.serializer;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.io.serializer.WritableSerialization;
import org.apache.hadoop.io.serializer.avro.AvroReflectSerialization;
import org.apache.hadoop.io.serializer.avro.AvroSpecificSerialization;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class SerializationFactory
extends Configured {
    private static final Log LOG = LogFactory.getLog((String)SerializationFactory.class.getName());
    private List<Serialization<?>> serializations = new ArrayList();

    public SerializationFactory(Configuration conf) {
        super(conf);
        for (String serializerName : conf.getStrings("io.serializations", WritableSerialization.class.getName(), AvroSpecificSerialization.class.getName(), AvroReflectSerialization.class.getName())) {
            this.add(conf, serializerName);
        }
    }

    private void add(Configuration conf, String serializationName) {
        try {
            Class<?> serializionClass = conf.getClassByName(serializationName);
            this.serializations.add((Serialization)ReflectionUtils.newInstance(serializionClass, this.getConf()));
        }
        catch (ClassNotFoundException e) {
            LOG.warn((Object)"Serialization class not found: ", (Throwable)e);
        }
    }

    public <T> Serializer<T> getSerializer(Class<T> c) {
        Serialization<T> serializer = this.getSerialization(c);
        if (serializer != null) {
            return serializer.getSerializer(c);
        }
        return null;
    }

    public <T> Deserializer<T> getDeserializer(Class<T> c) {
        Serialization<T> serializer = this.getSerialization(c);
        if (serializer != null) {
            return serializer.getDeserializer(c);
        }
        return null;
    }

    public <T> Serialization<T> getSerialization(Class<T> c) {
        for (Serialization<T> serialization : this.serializations) {
            if (!serialization.accept(c)) continue;
            return serialization;
        }
        return null;
    }
}

