/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.solr;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.manifoldcf.agents.output.solr.ModifiedMultipartEntity;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.V2RequestSupport;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.V2Request;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;

public class ModifiedHttpSolrClient
extends HttpSolrClient {
    private static final String DEFAULT_PATH = "/select";
    private static Charset UTF8_CHARSET;
    private final HttpClient httpClient;
    private final boolean useMultiPartPost = true;

    public ModifiedHttpSolrClient(String baseURL, HttpClient client, ResponseParser parser, boolean allowCompression) {
        super(baseURL, client, parser, allowCompression);
        this.httpClient = client;
    }

    protected HttpRequestBase createMethod(SolrRequest request, String collection) throws IOException, SolrServerException {
        ResponseParser parser;
        if (request instanceof V2RequestSupport) {
            request = ((V2RequestSupport)request).getV2Request();
        }
        SolrParams params = request.getParams();
        final RequestWriter.ContentWriter contentWriter = this.requestWriter.getContentWriter(request);
        Collection streams = contentWriter == null ? this.requestWriter.getContentStreams(request) : null;
        String path = this.requestWriter.getPath(request);
        if (path == null || !path.startsWith("/")) {
            path = DEFAULT_PATH;
        }
        if ((parser = request.getResponseParser()) == null) {
            parser = this.parser;
        }
        ModifiableSolrParams wparams = new ModifiableSolrParams(params);
        if (parser != null) {
            wparams.set("wt", new String[]{parser.getWriterType()});
            wparams.set("version", new String[]{parser.getVersion()});
        }
        if (this.invariantParams != null) {
            wparams.add((SolrParams)this.invariantParams);
        }
        String basePath = this.baseUrl;
        if (collection != null) {
            basePath = basePath + "/" + collection;
        }
        if (request instanceof V2Request) {
            basePath = System.getProperty("solr.v2RealPath") == null ? this.baseUrl.replace("/solr", "/api") : this.baseUrl + "/____v2";
        }
        if (SolrRequest.METHOD.GET == request.getMethod()) {
            if (streams != null || contentWriter != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "GET can't send streams!");
            }
            return new HttpGet(basePath + path + ModifiedHttpSolrClient.toQueryString((SolrParams)wparams, false));
        }
        if (SolrRequest.METHOD.DELETE == request.getMethod()) {
            return new HttpDelete(basePath + path + ModifiedHttpSolrClient.toQueryString((SolrParams)wparams, false));
        }
        if (SolrRequest.METHOD.POST == request.getMethod() || SolrRequest.METHOD.PUT == request.getMethod()) {
            HttpPost postOrPut;
            boolean isMultipart;
            String url = basePath + path;
            String contentWriterUrl = url + ModifiedHttpSolrClient.toQueryString((SolrParams)wparams, false);
            ((Object)((Object)this)).getClass();
            Collection requestStreams = request.getContentStreams();
            if (requestStreams != null && requestStreams.size() > 0) {
                boolean hasNullStreamName = false;
                if (requestStreams != null) {
                    for (ContentStream cs : requestStreams) {
                        if (cs.getName() != null) continue;
                        hasNullStreamName = true;
                        break;
                    }
                }
                boolean urlTooBig = contentWriterUrl.length() > 4000;
                boolean bl = isMultipart = requestStreams != null && requestStreams.size() > 0 && (request.getMethod() == SolrRequest.METHOD.POST && !hasNullStreamName || urlTooBig);
                if (isMultipart) {
                    streams = requestStreams;
                }
            } else {
                isMultipart = false;
            }
            SolrRequest.METHOD methodToUse = isMultipart ? SolrRequest.METHOD.POST : request.getMethod();
            LinkedList<NameValuePair> postOrPutParams = new LinkedList<NameValuePair>();
            if (contentWriter != null && !isMultipart) {
                String fullQueryUrl = contentWriterUrl;
                postOrPut = SolrRequest.METHOD.POST == methodToUse ? new HttpPost(fullQueryUrl) : new HttpPut(fullQueryUrl);
                postOrPut.addHeader("Content-Type", contentWriter.getContentType());
                postOrPut.setEntity((HttpEntity)new BasicHttpEntity(){

                    public boolean isStreaming() {
                        return true;
                    }

                    public void writeTo(OutputStream outstream) throws IOException {
                        contentWriter.write(outstream);
                    }
                });
                return postOrPut;
            }
            if (streams == null || isMultipart) {
                ModifiableSolrParams queryParams = this.calculateQueryParams(this.getQueryParams(), wparams);
                queryParams.add((SolrParams)this.calculateQueryParams(request.getQueryParams(), wparams));
                String fullQueryUrl = url + ModifiedHttpSolrClient.toQueryString((SolrParams)queryParams, false);
                HttpEntityEnclosingRequestBase postOrPut2 = this.fillContentStream(methodToUse, streams, wparams, isMultipart, postOrPutParams, fullQueryUrl);
                return postOrPut2;
            }
            String fullQueryUrl = url + ModifiedHttpSolrClient.toQueryString((SolrParams)wparams, false);
            postOrPut = SolrRequest.METHOD.POST == methodToUse ? new HttpPost(fullQueryUrl) : new HttpPut(fullQueryUrl);
            this.fillSingleContentStream(streams, (HttpEntityEnclosingRequestBase)postOrPut);
            return postOrPut;
        }
        throw new SolrServerException("Unsupported method: " + request.getMethod());
    }

    private void fillSingleContentStream(Collection<ContentStream> streams, HttpEntityEnclosingRequestBase postOrPut) throws IOException {
        final ContentStream[] contentStream = new ContentStream[1];
        Iterator<ContentStream> iterator = streams.iterator();
        if (iterator.hasNext()) {
            ContentStream content;
            contentStream[0] = content = iterator.next();
        }
        Long size = contentStream[0].getSize();
        postOrPut.setEntity((HttpEntity)new InputStreamEntity(contentStream[0].getStream(), size == null ? -1L : size){

            public Header getContentType() {
                return new BasicHeader("Content-Type", contentStream[0].getContentType());
            }

            public boolean isRepeatable() {
                return false;
            }
        });
    }

    private HttpEntityEnclosingRequestBase fillContentStream(SolrRequest.METHOD methodToUse, Collection<ContentStream> streams, ModifiableSolrParams wparams, boolean isMultipart, LinkedList<NameValuePair> postOrPutParams, String fullQueryUrl) throws IOException {
        HttpPost postOrPut;
        Object object = postOrPut = SolrRequest.METHOD.POST == methodToUse ? new HttpPost(fullQueryUrl) : new HttpPut(fullQueryUrl);
        if (!isMultipart) {
            postOrPut.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        }
        LinkedList<FormBodyPart> parts = new LinkedList<FormBodyPart>();
        Iterator iter = wparams.getParameterNamesIterator();
        while (iter.hasNext()) {
            String p = (String)iter.next();
            String[] vals = wparams.getParams(p);
            if (vals == null) continue;
            for (String v : vals) {
                if (isMultipart) {
                    parts.add(new FormBodyPart(p, (ContentBody)new StringBody(v, StandardCharsets.UTF_8)));
                    continue;
                }
                postOrPutParams.add((NameValuePair)new BasicNameValuePair(p, v));
            }
        }
        if (isMultipart && streams != null) {
            for (ContentStream content : streams) {
                String name;
                String contentType = content.getContentType();
                if (contentType == null) {
                    contentType = "application/octet-stream";
                }
                if ((name = content.getName()) == null) {
                    name = "";
                }
                parts.add(new FormBodyPart(ModifiedHttpSolrClient.encodeForHeader(name), (ContentBody)new InputStreamBody(content.getStream(), ContentType.parse((String)contentType), ModifiedHttpSolrClient.encodeForHeader(content.getName()))));
            }
        }
        if (parts.size() > 0) {
            ModifiedMultipartEntity entity = new ModifiedMultipartEntity(HttpMultipartMode.STRICT, null, StandardCharsets.UTF_8);
            for (FormBodyPart p : parts) {
                entity.addPart(p);
            }
            postOrPut.setEntity((HttpEntity)entity);
        } else {
            postOrPut.setEntity((HttpEntity)new UrlEncodedFormEntity(postOrPutParams, StandardCharsets.UTF_8));
        }
        return postOrPut;
    }

    public static String toQueryString(SolrParams params, boolean xml) {
        StringBuilder sb = new StringBuilder(128);
        try {
            String amp = xml ? "&amp;" : "&";
            boolean first = true;
            Iterator names = params.getParameterNamesIterator();
            while (names.hasNext()) {
                String key = (String)names.next();
                String[] valarr = params.getParams(key);
                if (valarr == null) {
                    sb.append(first ? "?" : amp);
                    sb.append(URLEncoder.encode(key, "UTF-8"));
                    first = false;
                    continue;
                }
                for (String val : valarr) {
                    sb.append(first ? "?" : amp);
                    sb.append(key);
                    if (val != null) {
                        sb.append('=');
                        sb.append(URLEncoder.encode(val, "UTF-8"));
                    }
                    first = false;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    private static String encodeForHeader(String headerName) {
        if (headerName == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < headerName.length(); ++i) {
            char x = headerName.charAt(i);
            if (x == '\"' || x == '\\' || x == '\r') {
                sb.append("\\");
            }
            sb.append(x);
        }
        return sb.toString();
    }
}

