/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.metadata.MD_KeywordClass;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.identification.DefaultKeywordClass;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.identification.KeywordType;
import org.opengis.metadata.identification.Keywords;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Keywords_Type", propOrder={"keywords", "type", "thesaurusName", "keywordClass"})
@XmlRootElement(name="MD_Keywords")
public class DefaultKeywords
extends ISOMetadata
implements Keywords {
    private static final long serialVersionUID = -2765705888428016211L;
    private Collection<InternationalString> keywords;
    private KeywordType type;
    private Citation thesaurusName;
    private DefaultKeywordClass keywordClass;

    public DefaultKeywords() {
    }

    public DefaultKeywords(CharSequence ... charSequenceArray) {
        if (charSequenceArray != null) {
            for (CharSequence charSequence : charSequenceArray) {
                InternationalString internationalString = Types.toInternationalString(charSequence);
                if (this.keywords == null) {
                    this.keywords = this.singleton(internationalString, InternationalString.class);
                    continue;
                }
                this.keywords.add(internationalString);
            }
        }
    }

    public DefaultKeywords(Keywords keywords) {
        super(keywords);
        if (keywords != null) {
            this.keywords = this.copyCollection(keywords.getKeywords(), InternationalString.class);
            this.type = keywords.getType();
            this.thesaurusName = keywords.getThesaurusName();
        }
    }

    public static DefaultKeywords castOrCopy(Keywords keywords) {
        if (keywords == null || keywords instanceof DefaultKeywords) {
            return (DefaultKeywords)keywords;
        }
        return new DefaultKeywords(keywords);
    }

    @XmlElement(name="keyword", required=true)
    public Collection<InternationalString> getKeywords() {
        this.keywords = this.nonNullCollection(this.keywords, InternationalString.class);
        return this.keywords;
    }

    public void setKeywords(Collection<? extends InternationalString> collection) {
        this.keywords = this.writeCollection(collection, this.keywords, InternationalString.class);
    }

    @XmlElement(name="type")
    public KeywordType getType() {
        return this.type;
    }

    public void setType(KeywordType keywordType) {
        this.checkWritePermission(this.type);
        this.type = keywordType;
    }

    @XmlElement(name="thesaurusName")
    public Citation getThesaurusName() {
        return this.thesaurusName;
    }

    public void setThesaurusName(Citation citation) {
        this.checkWritePermission(this.thesaurusName);
        this.thesaurusName = citation;
    }

    @XmlElement(name="keywordClass")
    @XmlJavaTypeAdapter(value=MD_KeywordClass.Since2014.class)
    @UML(identifier="keywordClass", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public DefaultKeywordClass getKeywordClass() {
        return this.keywordClass;
    }

    public void setKeywordClass(DefaultKeywordClass defaultKeywordClass) {
        this.checkWritePermission(this.keywordClass);
        this.keywordClass = defaultKeywordClass;
    }
}

