/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities;

import org.apache.manifoldcf.authorities.BaseMappersInitializationCommand;
import org.apache.manifoldcf.authorities.interfaces.IMappingConnectorManager;
import org.apache.manifoldcf.authorities.interfaces.MappingConnectorFactory;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class SynchronizeMappers
extends BaseMappersInitializationCommand {
    public static final String _rcsid = "@(#)$Id: SynchronizeMappers.java 1498128 2013-06-30 14:15:49Z kwright $";

    @Override
    protected void doExecute(IMappingConnectorManager mgr) throws ManifoldCFException {
        IResultSet classNames = mgr.getConnectors();
        int i = 0;
        while (i < classNames.getRowCount()) {
            IResultRow row = classNames.getRow(i++);
            String classname = (String)row.getValue("classname");
            try {
                MappingConnectorFactory.getConnectorNoCheck(classname);
            }
            catch (ManifoldCFException e) {
                mgr.removeConnector(classname);
            }
        }
        Logging.root.info((Object)"Successfully synchronized all mappers");
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            System.err.println("Usage: SynchronizeMappers");
            System.exit(1);
        }
        try {
            SynchronizeMappers synchronizeMappers = new SynchronizeMappers();
            synchronizeMappers.execute();
            System.err.println("Successfully synchronized all mappers");
        }
        catch (ManifoldCFException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

