/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.ext.ReaderInterceptor;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.jboss.resteasy.core.ProvidersContextRetainer;
import org.jboss.resteasy.core.interception.ClientReaderInterceptorContext;
import org.jboss.resteasy.plugins.delegates.LinkHeaderDelegate;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.Link;
import org.jboss.resteasy.spi.LinkHeader;
import org.jboss.resteasy.spi.MarshalledEntity;
import org.jboss.resteasy.spi.NotImplementedYetException;
import org.jboss.resteasy.spi.ReaderException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.CaseInsensitiveMap;
import org.jboss.resteasy.util.GenericType;
import org.jboss.resteasy.util.InputStreamToByteArray;
import org.jboss.resteasy.util.ReadFromStream;
import org.jboss.resteasy.util.Types;

public class BaseClientResponse<T>
extends ClientResponse<T> {
    protected ResteasyProviderFactory providerFactory;
    protected String attributeExceptionsTo;
    protected MultivaluedMap<String, String> headers;
    protected String alternateMediaType;
    protected Class<?> returnType;
    protected Type genericReturnType;
    protected Annotation[] annotations = new Annotation[0];
    protected int status;
    protected boolean wasReleased = false;
    protected Object unmarshaledEntity;
    protected ReaderInterceptor[] readerInterceptors;
    protected Exception exception;
    protected BaseClientResponseStreamFactory streamFactory;
    protected LinkHeader linkHeader;
    protected Link location;
    protected ClientExecutor executor;
    protected Map<String, Object> attributes;

    public BaseClientResponse(BaseClientResponseStreamFactory streamFactory, ClientExecutor executor) {
        this.streamFactory = streamFactory;
        this.executor = executor;
    }

    public BaseClientResponse(BaseClientResponseStreamFactory streamFactory) {
        this.streamFactory = streamFactory;
    }

    public static ClientResponse copyFromError(ClientResponse copy) {
        if (copy instanceof BaseClientResponse) {
            BaseClientResponse base = (BaseClientResponse)copy;
            InputStream is = null;
            if (copy.getResponseHeaders().containsKey((Object)"Content-Type")) {
                try {
                    is = base.streamFactory.getInputStream();
                    byte[] bytes = ReadFromStream.readFromStream(1024, is);
                    is = new ByteArrayInputStream(bytes);
                }
                catch (IOException bytes) {
                    // empty catch block
                }
            }
            final InputStream theIs = is;
            BaseClientResponse tmp = new BaseClientResponse(new BaseClientResponseStreamFactory(){
                InputStream stream;

                @Override
                public InputStream getInputStream() throws IOException {
                    return theIs;
                }

                @Override
                public void performReleaseConnection() {
                }
            });
            tmp.executor = base.executor;
            tmp.status = base.status;
            tmp.providerFactory = base.providerFactory;
            tmp.headers = new CaseInsensitiveMap<String>();
            tmp.headers.putAll(base.headers);
            tmp.readerInterceptors = base.readerInterceptors;
            return tmp;
        }
        ByteArrayInputStream is = null;
        if (copy.getResponseHeaders().containsKey((Object)"Content-Type")) {
            GenericType<byte[]> gt = new GenericType<byte[]>(){};
            try {
                byte[] bytes = copy.getEntity(gt);
                is = new ByteArrayInputStream(bytes);
            }
            catch (Exception bytes) {
                // empty catch block
            }
        }
        final ByteArrayInputStream theIs = is;
        BaseClientResponse tmp = new BaseClientResponse(new BaseClientResponseStreamFactory(){
            InputStream stream;

            @Override
            public InputStream getInputStream() throws IOException {
                return theIs;
            }

            @Override
            public void performReleaseConnection() {
            }
        });
        tmp.status = copy.getStatus();
        tmp.providerFactory = ResteasyProviderFactory.getInstance();
        tmp.headers = new CaseInsensitiveMap<String>();
        tmp.headers.putAll(copy.getResponseHeaders());
        tmp.headers.remove((Object)"Content-Encoding");
        return tmp;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void setReaderInterceptors(ReaderInterceptor[] readerInterceptors) {
        this.readerInterceptors = readerInterceptors;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setHeaders(MultivaluedMap<String, String> headers) {
        this.headers = headers;
    }

    public void setProviderFactory(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public void setReturnType(Class<T> returnType) {
        this.returnType = returnType;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public void setGenericReturnType(Type genericReturnType) {
        this.genericReturnType = genericReturnType;
    }

    public void setAnnotations(Annotation[] annotations) {
        this.annotations = annotations;
    }

    public String getAttributeExceptionsTo() {
        return this.attributeExceptionsTo;
    }

    public void setAttributeExceptionsTo(String attributeExceptionsTo) {
        this.attributeExceptionsTo = attributeExceptionsTo;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public String getResponseHeader(String headerKey) {
        if (this.headers == null) {
            return null;
        }
        return (String)this.headers.getFirst((Object)headerKey);
    }

    @Override
    public LinkHeader getLinkHeader() {
        if (this.linkHeader != null) {
            return this.linkHeader;
        }
        this.linkHeader = new LinkHeader();
        if (!this.headers.containsKey((Object)"Link")) {
            return this.linkHeader;
        }
        List links = (List)this.headers.get((Object)"Link");
        LinkHeaderDelegate delegate = new LinkHeaderDelegate();
        for (String string : links) {
            LinkHeader tmp = delegate.fromString(string);
            this.linkHeader.getLinks().addAll(tmp.getLinks());
            this.linkHeader.getLinksByRelationship().putAll(tmp.getLinksByRelationship());
            this.linkHeader.getLinksByTitle().putAll(tmp.getLinksByTitle());
        }
        for (Link link : this.linkHeader.getLinks()) {
            link.setExecutor(this.executor);
        }
        return this.linkHeader;
    }

    @Override
    public Link getLocationLink() {
        if (this.location != null) {
            return this.location;
        }
        if (!this.headers.containsKey((Object)"Location")) {
            return null;
        }
        String header = (String)this.headers.getFirst((Object)"Location");
        this.location = new Link();
        this.location.setHref(header);
        this.location.setExecutor(this.executor);
        return this.location;
    }

    @Override
    public Link getHeaderAsLink(String headerName) {
        String value = (String)this.headers.getFirst((Object)headerName);
        if (value == null) {
            return null;
        }
        String type = (String)this.headers.getFirst((Object)(headerName + "-type"));
        Link link = new Link();
        link.setHref(value);
        link.setType(type);
        link.setExecutor(this.executor);
        return link;
    }

    public void setAlternateMediaType(String alternateMediaType) {
        this.alternateMediaType = alternateMediaType;
    }

    public BaseClientResponseStreamFactory getStreamFactory() {
        return this.streamFactory;
    }

    public void setStreamFactory(BaseClientResponseStreamFactory streamFactory) {
        this.streamFactory = streamFactory;
    }

    @Override
    public void resetStream() {
        try {
            this.streamFactory.getInputStream().reset();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T getEntity() {
        if (this.returnType == null) {
            throw new RuntimeException(Messages.MESSAGES.noTypeInformationForEntity());
        }
        return (T)this.getEntity(this.returnType, this.genericReturnType, this.annotations);
    }

    @Override
    public <T2> T2 getEntity(Class<T2> type) {
        return this.getEntity(type, null);
    }

    @Override
    public <T2> T2 getEntity(Class<T2> type, Type genericType) {
        return this.getEntity(type, genericType, this.getAnnotations(type, genericType));
    }

    private <T2> Annotation[] getAnnotations(Class<T2> type, Type genericType) {
        if (this.annotations != null) {
            return this.annotations;
        }
        return this.returnType == type && this.genericReturnType == genericType ? this.annotations : null;
    }

    @Override
    public <T2> T2 getEntity(Class<T2> type, Type genericType, Annotation[] anns) {
        if (this.exception != null) {
            throw new RuntimeException(Messages.MESSAGES.unableToUnmarshalResponse(this.attributeExceptionsTo), this.exception);
        }
        if (this.unmarshaledEntity != null && !type.isInstance(this.unmarshaledEntity)) {
            throw new RuntimeException(Messages.MESSAGES.entityAlreadyRead(this.unmarshaledEntity.getClass()));
        }
        if (this.unmarshaledEntity == null) {
            if (this.status == 204) {
                return null;
            }
            this.unmarshaledEntity = this.readFrom(type, genericType, this.getMediaType(), anns);
            if (this.unmarshaledEntity != null && !InputStream.class.isInstance(this.unmarshaledEntity)) {
                this.releaseConnection();
            }
        }
        return (T2)this.unmarshaledEntity;
    }

    public MediaType getMediaType() {
        String mediaType = this.getResponseHeader("Content-Type");
        if (mediaType == null) {
            mediaType = this.alternateMediaType;
        }
        return mediaType == null ? MediaType.WILDCARD_TYPE : MediaType.valueOf((String)mediaType);
    }

    protected synchronized <T2> Object readFrom(Class<T2> type, Type genericType, MediaType media, Annotation[] annotations) {
        Type useGeneric = genericType == null ? type : genericType;
        Class<Object> useType = type;
        boolean isMarshalledEntity = false;
        if (type.equals(MarshalledEntity.class)) {
            isMarshalledEntity = true;
            ParameterizedType param = (ParameterizedType)useGeneric;
            useGeneric = param.getActualTypeArguments()[0];
            useType = Types.getRawType(useGeneric);
        }
        Providers current = ResteasyProviderFactory.getContextData(Providers.class);
        ResteasyProviderFactory.pushContext(Providers.class, this.providerFactory);
        Object obj = null;
        try {
            Object finalObj;
            InputStream is = this.streamFactory.getInputStream();
            if (is == null) {
                throw new ClientResponseFailure(Messages.MESSAGES.inputStreamEmpty(), (ClientResponse)this);
            }
            if (isMarshalledEntity) {
                is = new InputStreamToByteArray(is);
            }
            obj = finalObj = new ClientReaderInterceptorContext(this.readerInterceptors, this.providerFactory, useType, useGeneric, annotations, media, this.getResponseHeaders(), new InputStreamWrapper(is), this.attributes).proceed();
            if (isMarshalledEntity) {
                InputStreamToByteArray isba = (InputStreamToByteArray)is;
                final byte[] bytes = isba.toByteArray();
                MarshalledEntity marshalledEntity = new MarshalledEntity(){

                    @Override
                    public byte[] getMarshalledBytes() {
                        return bytes;
                    }

                    public Object getEntity() {
                        return finalObj;
                    }
                };
                return marshalledEntity;
            }
            Object object = finalObj;
            return object;
        }
        catch (Exception e) {
            if (e instanceof ReaderException) {
                throw (ReaderException)e;
            }
            throw new ReaderException(e);
        }
        finally {
            ResteasyProviderFactory.popContextData(Providers.class);
            if (current != null) {
                ResteasyProviderFactory.pushContext(Providers.class, current);
            }
            if (obj instanceof ProvidersContextRetainer) {
                ((ProvidersContextRetainer)obj).setProviders(this.providerFactory);
            }
        }
    }

    @Override
    public <T2> T2 getEntity(GenericType<T2> genericType) {
        return this.getEntity(genericType.getType(), genericType.getGenericType());
    }

    @Override
    public <T2> T2 getEntity(GenericType<T2> genericType, Annotation[] ann) {
        return this.getEntity(genericType.getType(), genericType.getGenericType(), ann);
    }

    @Override
    public MultivaluedMap<String, String> getResponseHeaders() {
        return this.headers;
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.headers;
    }

    public int getStatus() {
        return this.status;
    }

    public Response.StatusType getStatusInfo() {
        Object statusType = Response.Status.fromStatusCode((int)this.status);
        if (statusType == null) {
            statusType = new Response.StatusType(){

                public int getStatusCode() {
                    return BaseClientResponse.this.status;
                }

                public Response.Status.Family getFamily() {
                    return Response.Status.Family.OTHER;
                }

                public String getReasonPhrase() {
                    return "Unknown Code";
                }
            };
        }
        return statusType;
    }

    public void checkFailureStatus() {
        if (this.status > 399 && this.status < 599) {
            throw this.createResponseFailure(Messages.MESSAGES.clientResponseFailureStatus(this.status, this.getResponseStatus()));
        }
    }

    public ClientResponseFailure createResponseFailure(String message) {
        return this.createResponseFailure(message, null);
    }

    public ClientResponseFailure createResponseFailure(String message, Exception e) {
        this.setException(e);
        this.returnType = byte[].class;
        this.genericReturnType = null;
        this.annotations = null;
        return new ClientResponseFailure(message, e, this);
    }

    @Override
    public Response.Status getResponseStatus() {
        return Response.Status.fromStatusCode((int)this.getStatus());
    }

    public boolean wasReleased() {
        return this.wasReleased;
    }

    public void setWasReleased(boolean wasReleased) {
        this.wasReleased = wasReleased;
    }

    @Override
    public final void releaseConnection() {
        if (!this.wasReleased) {
            if (this.streamFactory != null) {
                this.streamFactory.performReleaseConnection();
            }
            this.wasReleased = true;
        }
    }

    protected final synchronized void finalize() throws Throwable {
        this.releaseConnection();
    }

    public <T> T readEntity(Class<T> entityType) {
        throw new NotImplementedYetException();
    }

    public <T> T readEntity(javax.ws.rs.core.GenericType<T> entityType) {
        throw new NotImplementedYetException();
    }

    public <T> T readEntity(Class<T> entityType, Annotation[] annotations) {
        throw new NotImplementedYetException();
    }

    public <T> T readEntity(javax.ws.rs.core.GenericType<T> entityType, Annotation[] annotations) {
        throw new NotImplementedYetException();
    }

    public boolean hasEntity() {
        throw new NotImplementedYetException();
    }

    public boolean bufferEntity() {
        throw new NotImplementedYetException();
    }

    public void close() {
        this.releaseConnection();
    }

    public String getHeaderString(String name) {
        throw new NotImplementedYetException();
    }

    public Locale getLanguage() {
        throw new NotImplementedYetException();
    }

    public int getLength() {
        throw new NotImplementedYetException();
    }

    public Map<String, NewCookie> getCookies() {
        throw new NotImplementedYetException();
    }

    public EntityTag getEntityTag() {
        throw new NotImplementedYetException();
    }

    public Date getDate() {
        throw new NotImplementedYetException();
    }

    public Date getLastModified() {
        throw new NotImplementedYetException();
    }

    public Set<javax.ws.rs.core.Link> getLinks() {
        throw new NotImplementedYetException();
    }

    public boolean hasLink(String relation) {
        throw new NotImplementedYetException();
    }

    public javax.ws.rs.core.Link getLink(String relation) {
        throw new NotImplementedYetException();
    }

    public Link.Builder getLinkBuilder(String relation) {
        throw new NotImplementedYetException();
    }

    public URI getLocation() {
        throw new NotImplementedYetException();
    }

    public Set<String> getAllowedMethods() {
        throw new NotImplementedYetException();
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        throw new NotImplementedYetException();
    }

    private static class InputStreamWrapper
    extends FilterInputStream {
        protected InputStreamWrapper(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
        }
    }

    public static interface BaseClientResponseStreamFactory {
        public InputStream getInputStream() throws IOException;

        public void performReleaseConnection();
    }
}

