/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.LoggableFailure;

public class MediaTypeHelper {
    public static MediaType getConsumes(Class declaring, AccessibleObject method) {
        Consumes consume = method.getAnnotation(Consumes.class);
        if (consume == null && (consume = declaring.getAnnotation(Consumes.class)) == null) {
            return null;
        }
        return MediaType.valueOf((String)consume.value()[0]);
    }

    public static MediaType getProduces(Class declaring, Method method) {
        return MediaTypeHelper.getProduces(declaring, method, null);
    }

    public static MediaType getProduces(Class declaring, Method method, MediaType defaultProduces) {
        Produces consume = method.getAnnotation(Produces.class);
        if (consume == null) {
            consume = declaring.getAnnotation(Produces.class);
        }
        if (consume == null) {
            return defaultProduces;
        }
        return MediaType.valueOf((String)consume.value()[0]);
    }

    public static float getQ(MediaType type) {
        float rtn = MediaTypeHelper.getQWithParamInfo(type);
        if (rtn == 2.0f) {
            return 1.0f;
        }
        return rtn;
    }

    public static float getQWithParamInfo(MediaType type) {
        if (type.getParameters() != null) {
            String val = (String)type.getParameters().get("q");
            try {
                if (val != null) {
                    float rtn = Float.valueOf(val).floatValue();
                    if (rtn > 1.0f) {
                        throw new LoggableFailure(Messages.MESSAGES.mediaTypeQGreaterThan1(type.toString()), 400);
                    }
                    return rtn;
                }
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(Messages.MESSAGES.mediaTypeQMustBeFloat(type), e);
            }
        }
        return 2.0f;
    }

    public static boolean isCompositeWildcardSubtype(String subtype) {
        return subtype.startsWith("*+");
    }

    public static boolean isWildcardCompositeSubtype(String subtype) {
        return subtype.endsWith("+*");
    }

    public static boolean isComposite(String subtype) {
        return MediaTypeHelper.isCompositeWildcardSubtype(subtype) || MediaTypeHelper.isWildcardCompositeSubtype(subtype);
    }

    public static int compareWeight(MediaType one, MediaType two) {
        return new MediaTypeComparator().compare(one, two);
    }

    public static boolean sameWeight(MediaType one, MediaType two) {
        return new MediaTypeComparator().compare(one, two) == 0;
    }

    public static void sortByWeight(List<MediaType> types) {
        if (types == null || types.size() <= 1) {
            return;
        }
        Collections.sort(types, new MediaTypeComparator());
    }

    public static MediaType getBestMatch(List<MediaType> desired, List<MediaType> provided) {
        boolean emptyProvided;
        MediaTypeHelper.sortByWeight(desired);
        MediaTypeHelper.sortByWeight(provided);
        boolean emptyDesired = desired == null || desired.size() == 0;
        boolean bl = emptyProvided = provided == null || provided.size() == 0;
        if (emptyDesired && emptyProvided) {
            return null;
        }
        if (emptyDesired && !emptyProvided) {
            return provided.get(0);
        }
        if (emptyProvided && !emptyDesired) {
            return desired.get(0);
        }
        for (MediaType desire : desired) {
            for (MediaType provide : provided) {
                if (!provide.isCompatible(desire)) continue;
                return provide;
            }
        }
        return null;
    }

    public static List<MediaType> parseHeader(String header) {
        ArrayList<MediaType> types = new ArrayList<MediaType>();
        String[] medias = header.split(",");
        for (int i = 0; i < medias.length; ++i) {
            types.add(MediaType.valueOf((String)medias[i].trim()));
        }
        return types;
    }

    public static boolean equivalent(MediaType m1, MediaType m2) {
        if (m1 == m2) {
            return true;
        }
        if (!m1.getType().equals(m2.getType())) {
            return false;
        }
        if (!m1.getSubtype().equals(m2.getSubtype())) {
            return false;
        }
        return MediaTypeHelper.equivalentParams(m1, m2);
    }

    public static boolean equivalentParams(MediaType m1, MediaType m2) {
        Map params2;
        Map params1 = m1.getParameters();
        if (params1 == (params2 = m2.getParameters())) {
            return true;
        }
        if (params1 == null || params2 == null) {
            return false;
        }
        if (params1.size() == 0 && params2.size() == 0) {
            return true;
        }
        int numParams1 = params1.size();
        if (params1.containsKey("q")) {
            --numParams1;
        }
        int numParams2 = params2.size();
        if (params2.containsKey("q")) {
            --numParams2;
        }
        if (numParams1 != numParams2) {
            return false;
        }
        if (numParams1 == 0) {
            return true;
        }
        for (Map.Entry entry : params1.entrySet()) {
            String value2;
            String value;
            String key = (String)entry.getKey();
            if (key.equals("q") || (value = (String)entry.getValue()) == (value2 = (String)params2.get(key))) continue;
            if (value == null || value2 == null) {
                return false;
            }
            if (value.equals(value2)) continue;
            return false;
        }
        return true;
    }

    private static class MediaTypeComparator
    implements Comparator<MediaType>,
    Serializable {
        private static final long serialVersionUID = -5828700121582498092L;

        private MediaTypeComparator() {
        }

        @Override
        public int compare(MediaType mediaType2, MediaType mediaType) {
            float q2;
            boolean wasQ2;
            boolean wasQ;
            float q = MediaTypeHelper.getQWithParamInfo(mediaType);
            boolean bl = wasQ = q != 2.0f;
            if (q == 2.0f) {
                q = 1.0f;
            }
            boolean bl2 = wasQ2 = (q2 = MediaTypeHelper.getQWithParamInfo(mediaType2)) != 2.0f;
            if (q2 == 2.0f) {
                q2 = 1.0f;
            }
            if (q < q2) {
                return -1;
            }
            if (q > q2) {
                return 1;
            }
            if (mediaType.isWildcardType() && !mediaType2.isWildcardType()) {
                return -1;
            }
            if (!mediaType.isWildcardType() && mediaType2.isWildcardType()) {
                return 1;
            }
            if (mediaType.isWildcardSubtype() && !mediaType2.isWildcardSubtype()) {
                return -1;
            }
            if (!mediaType.isWildcardSubtype() && mediaType2.isWildcardSubtype()) {
                return 1;
            }
            if (MediaTypeHelper.isComposite(mediaType.getSubtype()) && !MediaTypeHelper.isComposite(mediaType2.getSubtype())) {
                return -1;
            }
            if (!MediaTypeHelper.isComposite(mediaType.getSubtype()) && MediaTypeHelper.isComposite(mediaType2.getSubtype())) {
                return 1;
            }
            if (MediaTypeHelper.isCompositeWildcardSubtype(mediaType.getSubtype()) && !MediaTypeHelper.isCompositeWildcardSubtype(mediaType2.getSubtype())) {
                return -1;
            }
            if (!MediaTypeHelper.isCompositeWildcardSubtype(mediaType.getSubtype()) && MediaTypeHelper.isCompositeWildcardSubtype(mediaType2.getSubtype())) {
                return 1;
            }
            if (MediaTypeHelper.isWildcardCompositeSubtype(mediaType.getSubtype()) && !MediaTypeHelper.isWildcardCompositeSubtype(mediaType2.getSubtype())) {
                return -1;
            }
            if (!MediaTypeHelper.isWildcardCompositeSubtype(mediaType.getSubtype()) && MediaTypeHelper.isWildcardCompositeSubtype(mediaType2.getSubtype())) {
                return 1;
            }
            int numNonQ = 0;
            if (mediaType.getParameters() != null) {
                numNonQ = mediaType.getParameters().size();
                if (wasQ) {
                    --numNonQ;
                }
            }
            int numNonQ2 = 0;
            if (mediaType2.getParameters() != null) {
                numNonQ2 = mediaType2.getParameters().size();
                if (wasQ2) {
                    --numNonQ2;
                }
            }
            if (numNonQ < numNonQ2) {
                return -1;
            }
            if (numNonQ > numNonQ2) {
                return 1;
            }
            return 0;
        }
    }
}

