/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image.input;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import jj2000.j2k.JJ2KExceptionHandler;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.input.ImgReader;

public class ImgReaderPPM
extends ImgReader {
    public static int DC_OFFSET = 128;
    private RandomAccessFile in;
    private int offset;
    private int rb;
    private int[][] barr = new int[3][];
    private DataBlkInt dbi = new DataBlkInt();
    private byte[] buf;
    private DataBlkInt intBlk;

    public ImgReaderPPM(File file) throws IOException {
        this(new RandomAccessFile(file, "r"));
    }

    public ImgReaderPPM(String fname) throws IOException {
        this(new RandomAccessFile(fname, "r"));
    }

    private ImgReaderPPM(RandomAccessFile in) throws EOFException, IOException {
        this.in = in;
        this.confirmFileType();
        this.skipCommentAndWhiteSpace();
        this.w = this.readHeaderInt();
        this.skipCommentAndWhiteSpace();
        this.h = this.readHeaderInt();
        this.skipCommentAndWhiteSpace();
        this.readHeaderInt();
        this.nc = 3;
        this.rb = 8;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.in = null;
        this.barr[0] = null;
        this.barr[1] = null;
        this.barr[2] = null;
        this.buf = null;
    }

    @Override
    public int getNomRangeBits(int c) {
        if (c < 0 || c > 2) {
            throw new IllegalArgumentException();
        }
        return this.rb;
    }

    @Override
    public int getFixedPoint(int c) {
        if (c < 0 || c > 2) {
            throw new IllegalArgumentException();
        }
        return 0;
    }

    @Override
    public final DataBlk getInternCompData(DataBlk blk, int c) {
        if (c < 0 || c > 2) {
            throw new IllegalArgumentException();
        }
        if (blk.getDataType() != 3) {
            if (this.intBlk == null) {
                this.intBlk = new DataBlkInt(blk.ulx, blk.uly, blk.w, blk.h);
            } else {
                this.intBlk.ulx = blk.ulx;
                this.intBlk.uly = blk.uly;
                this.intBlk.w = blk.w;
                this.intBlk.h = blk.h;
            }
            blk = this.intBlk;
        }
        if (this.barr[c] == null || this.dbi.ulx > blk.ulx || this.dbi.uly > blk.uly || this.dbi.ulx + this.dbi.w < blk.ulx + blk.w || this.dbi.uly + this.dbi.h < blk.uly + blk.h) {
            if (this.barr[c] == null || this.barr[c].length < blk.w * blk.h) {
                this.barr[c] = new int[blk.w * blk.h];
            }
            blk.setData(this.barr[c]);
            int i = (c + 1) % 3;
            if (this.barr[i] == null || this.barr[i].length < blk.w * blk.h) {
                this.barr[i] = new int[blk.w * blk.h];
            }
            if (this.barr[i = (c + 2) % 3] == null || this.barr[i].length < blk.w * blk.h) {
                this.barr[i] = new int[blk.w * blk.h];
            }
            this.dbi.ulx = blk.ulx;
            this.dbi.uly = blk.uly;
            this.dbi.w = blk.w;
            this.dbi.h = blk.h;
            if (this.buf == null || this.buf.length < 3 * blk.w) {
                this.buf = new byte[3 * blk.w];
            }
            int[] red = this.barr[0];
            int[] green = this.barr[1];
            int[] blue = this.barr[2];
            try {
                int mi = blk.uly + blk.h;
                for (i = blk.uly; i < mi; ++i) {
                    this.in.seek(this.offset + i * 3 * this.w + 3 * blk.ulx);
                    this.in.read(this.buf, 0, 3 * blk.w);
                    int k = (i - blk.uly) * blk.w + blk.w - 1;
                    int j = 3 * blk.w - 1;
                    while (j >= 0) {
                        blue[k] = (this.buf[j--] & 0xFF) - DC_OFFSET;
                        green[k] = (this.buf[j--] & 0xFF) - DC_OFFSET;
                        red[k] = (this.buf[j--] & 0xFF) - DC_OFFSET;
                        --k;
                    }
                }
            }
            catch (IOException e) {
                JJ2KExceptionHandler.handleException(e);
            }
            this.barr[0] = red;
            this.barr[1] = green;
            this.barr[2] = blue;
            blk.setData(this.barr[c]);
            blk.offset = 0;
            blk.scanw = blk.w;
        } else {
            blk.setData(this.barr[c]);
            blk.offset = (blk.ulx - this.dbi.ulx) * this.dbi.w + blk.ulx - this.dbi.ulx;
            blk.scanw = this.dbi.scanw;
        }
        blk.progressive = false;
        return blk;
    }

    @Override
    public final DataBlk getCompData(DataBlk blk, int c) {
        if (blk.getDataType() != 3) {
            DataBlkInt tmp = new DataBlkInt(blk.ulx, blk.uly, blk.w, blk.h);
            blk = tmp;
        }
        int[] bakarr = (int[])blk.getData();
        int ulx = blk.ulx;
        int uly = blk.uly;
        int w = blk.w;
        int h = blk.h;
        blk.setData(null);
        this.getInternCompData(blk, c);
        if (bakarr == null) {
            bakarr = new int[w * h];
        }
        if (blk.offset == 0 && blk.scanw == w) {
            System.arraycopy(blk.getData(), 0, bakarr, 0, w * h);
        } else {
            for (int i = h - 1; i >= 0; --i) {
                System.arraycopy(blk.getData(), blk.offset + i * blk.scanw, bakarr, i * w, w);
            }
        }
        blk.setData(bakarr);
        blk.offset = 0;
        blk.scanw = blk.w;
        return blk;
    }

    private byte countedByteRead() throws IOException, EOFException {
        ++this.offset;
        return this.in.readByte();
    }

    private void confirmFileType() throws IOException, EOFException {
        byte[] type = new byte[]{80, 54};
        for (int i = 0; i < 2; ++i) {
            byte b = this.countedByteRead();
            if (b == type[i]) continue;
            if (i == 1 && b == 51) {
                throw new IllegalArgumentException("JJ2000 does not support ascii-PPM files. Use  raw-PPM file instead. ");
            }
            throw new IllegalArgumentException("Not a raw-PPM file");
        }
    }

    private void skipCommentAndWhiteSpace() throws IOException, EOFException {
        boolean done = false;
        while (!done) {
            byte b = this.countedByteRead();
            if (b == 35) {
                while (b != 10 && b != 13) {
                    b = this.countedByteRead();
                }
                continue;
            }
            if (b == 9 || b == 10 || b == 13 || b == 32) continue;
            done = true;
        }
        --this.offset;
        this.in.seek(this.offset);
    }

    private int readHeaderInt() throws IOException, EOFException {
        int res = 0;
        byte b = 0;
        b = this.countedByteRead();
        while (b != 32 && b != 10 && b != 9 && b != 13) {
            res = res * 10 + b - 48;
            b = this.countedByteRead();
        }
        return res;
    }

    @Override
    public boolean isOrigSigned(int c) {
        if (c < 0 || c > 2) {
            throw new IllegalArgumentException();
        }
        return false;
    }

    public String toString() {
        return "ImgReaderPPM: WxH = " + this.w + "x" + this.h + ", Component = 0,1,2" + "\nUnderlying RandomAccessFile:\n" + this.in.toString();
    }
}

