/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.webcrawler;

import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.connectors.webcrawler.FindHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.FormData;
import org.apache.manifoldcf.crawler.connectors.webcrawler.FormDataAccumulator;
import org.apache.manifoldcf.crawler.connectors.webcrawler.IHTMLHandler;
import org.apache.manifoldcf.crawler.connectors.webcrawler.LoginParameters;
import org.apache.manifoldcf.crawler.system.Logging;

public class FindHTMLFormHandler
extends FindHandler
implements IHTMLHandler {
    protected final Pattern formNamePattern;
    protected FormDataAccumulator discoveredFormData = null;
    protected FormDataAccumulator currentFormData = null;

    public FindHTMLFormHandler(String parentURI, Pattern formNamePattern) {
        super(parentURI);
        this.formNamePattern = formNamePattern;
    }

    public void applyFormOverrides(LoginParameters lp) throws ManifoldCFException {
        if (this.discoveredFormData != null && lp != null) {
            if (lp.getOverrideTargetURL() != null) {
                super.noteDiscoveredLink(lp.getOverrideTargetURL());
                this.discoveredFormData.overrideActionURI(this.getTargetURI());
            }
            this.discoveredFormData.applyOverrides(lp);
        }
    }

    public FormData getFormData() {
        return this.discoveredFormData;
    }

    @Override
    public void noteTextCharacter(char textCharacter) throws ManifoldCFException {
    }

    @Override
    public void noteMetaTag(Map metaAttributes) throws ManifoldCFException {
    }

    @Override
    public void noteFormStart(Map formAttributes) throws ManifoldCFException {
        boolean canUse;
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("WEB: Saw form with name " + (formAttributes.get("name") == null ? "null" : "'" + formAttributes.get("name") + "'") + " id " + (formAttributes.get("id") == null ? "null" : "'" + formAttributes.get("id") + "'") + " action " + (formAttributes.get("action") == null ? "null" : "'" + formAttributes.get("action") + "'")));
        }
        if (this.formNamePattern != null) {
            String formName = (String)formAttributes.get("name");
            if (formName == null) {
                formName = (String)formAttributes.get("id");
            }
            if (formName == null) {
                formName = (String)formAttributes.get("action");
            }
            if (formName == null) {
                formName = "";
            }
            Matcher m = this.formNamePattern.matcher(formName);
            canUse = m.find();
        } else {
            canUse = true;
        }
        if (canUse) {
            String actionURI = (String)formAttributes.get("action");
            if (actionURI == null) {
                actionURI = this.parentURI;
            } else if (actionURI.length() == 0) {
                actionURI = "";
            }
            this.noteDiscoveredLink(actionURI);
            actionURI = this.getTargetURI();
            if (actionURI != null) {
                String method = (String)formAttributes.get("method");
                method = method == null || method.length() == 0 ? "get" : method.toLowerCase(Locale.ROOT);
                this.currentFormData = new FormDataAccumulator(actionURI, method.equals("post") ? 1 : 0);
            }
        }
    }

    @Override
    public void noteFormInput(Map inputAttributes) throws ManifoldCFException {
        if (Logging.connectors.isDebugEnabled()) {
            String name;
            String type = (String)inputAttributes.get("type");
            if (type == null) {
                type = "text";
            }
            if ((name = (String)inputAttributes.get("name")) == null) {
                name = "(null)";
            }
            Logging.connectors.debug((Object)("WEB: Saw form element of type '" + type + "' name '" + name + "'"));
        }
        if (this.currentFormData != null) {
            this.currentFormData.addElement(inputAttributes);
        }
    }

    @Override
    public void noteFormEnd() throws ManifoldCFException {
        if (this.currentFormData != null) {
            this.discoveredFormData = this.currentFormData;
            this.currentFormData = null;
        }
    }

    @Override
    public void noteBASEHREF(String rawURL) throws ManifoldCFException {
    }

    @Override
    public void noteAHREF(String rawURL) throws ManifoldCFException {
    }

    @Override
    public void noteLINKHREF(String rawURL) throws ManifoldCFException {
    }

    @Override
    public void noteIMGSRC(String rawURL) throws ManifoldCFException {
    }

    @Override
    public void noteFRAMESRC(String rawURL) throws ManifoldCFException {
    }

    @Override
    public void finishUp() throws ManifoldCFException {
    }
}

