/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.opensaml.MalformedException;
import org.opensaml.SAMLAttributeDesignator;
import org.opensaml.SAMLException;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectQuery;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAttributeQuery
extends SAMLSubjectQuery
implements Cloneable {
    protected String resource = null;
    protected ArrayList designators = new ArrayList();

    public SAMLAttributeQuery() {
    }

    public SAMLAttributeQuery(SAMLSubject sAMLSubject, String string, Collection collection) throws SAMLException {
        super(sAMLSubject);
        this.resource = XML.assign(string);
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.designators.add(((SAMLAttributeDesignator)iterator.next()).setParent(this));
            }
        }
    }

    public SAMLAttributeQuery(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLAttributeQuery(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLAttributeQuery.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        Object object;
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:protocol", "AttributeQuery")) {
            object = XML.getQNameAttribute(element, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:protocol", "Query") && XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:protocol", "SubjectQuery") && object != null && "urn:oasis:names:tc:SAML:1.0:protocol".equals(((QName)object).getNamespaceURI()) && "AttributeQueryType".equals(((QName)object).getLocalPart()))) {
                throw new MalformedException(SAMLException.REQUESTER, "SAMLAttributeQuery() requires samlp:AttributeQuery at root");
            }
        }
        if (element.hasAttributeNS(null, "Resource")) {
            this.resource = XML.assign(element.getAttributeNS(null, "Resource"));
        }
        object = XML.getFirstChildElement(this.root, "urn:oasis:names:tc:SAML:1.0:assertion", "AttributeDesignator");
        while (object != null) {
            this.designators.add(new SAMLAttributeDesignator((Element)object).setParent(this));
            object = XML.getNextSiblingElement((Node)object, "urn:oasis:names:tc:SAML:1.0:assertion", "AttributeDesignator");
        }
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String string) {
        this.resource = XML.assign(string);
        this.setDirty(true);
    }

    public Iterator getDesignators() {
        return this.designators.iterator();
    }

    public void setDesignators(Collection collection) throws SAMLException {
        this.designators.clear();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.designators.add(((SAMLAttributeDesignator)iterator.next()).setParent(this));
            }
        }
        this.setDirty(true);
    }

    public void addDesignator(SAMLAttributeDesignator sAMLAttributeDesignator) throws SAMLException {
        if (sAMLAttributeDesignator == null) {
            throw new IllegalArgumentException("designator cannot be null");
        }
        this.designators.add(sAMLAttributeDesignator.setParent(this));
        this.setDirty(true);
    }

    public void removeDesignator(int n) {
        this.designators.remove(n);
        this.setDirty(true);
    }

    protected Element buildRoot(Document document, boolean bl) {
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "AttributeQuery");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
        }
        return element;
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        super.toDOM(document, bl);
        Element element = (Element)this.root;
        if (this.dirty) {
            if (!XML.isEmpty(this.resource)) {
                element.setAttributeNS(null, "Resource", this.resource);
            }
            Iterator iterator = this.designators.iterator();
            while (iterator.hasNext()) {
                element.appendChild(((SAMLAttributeDesignator)iterator.next()).toDOM(document));
            }
            this.setDirty(false);
        } else if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
        }
        return this.root;
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAttributeQuery sAMLAttributeQuery = (SAMLAttributeQuery)super.clone();
        try {
            sAMLAttributeQuery.designators = new ArrayList();
            Iterator iterator = this.designators.iterator();
            while (iterator.hasNext()) {
                sAMLAttributeQuery.designators.add(((SAMLAttributeDesignator)((SAMLAttributeDesignator)iterator.next()).clone()).setParent(sAMLAttributeQuery));
            }
        }
        catch (SAMLException sAMLException) {
            throw new CloneNotSupportedException(sAMLException.getMessage());
        }
        return sAMLAttributeQuery;
    }
}

