/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.exolab.castor.xml.XMLFieldDescriptor;

public class FieldValidator
extends Validator {
    private static final String ERROR_NAME = "-error-if-this-is-used-";
    private int minOccurs = 0;
    private int maxOccurs = -1;
    private XMLFieldDescriptor _descriptor = null;
    private TypeValidator _validator = null;

    public FieldValidator() {
    }

    public FieldValidator(TypeValidator validator) {
        this._validator = validator;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public TypeValidator getTypeValidator() {
        return this._validator;
    }

    public boolean hasTypeValidator() {
        return this._validator != null;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs < 0 ? 0 : minOccurs;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public void setDescriptor(XMLFieldDescriptor descriptor) {
        this._descriptor = descriptor;
    }

    public void setValidator(TypeValidator validator) {
        this._validator = validator;
    }

    public void validate(Object object, ValidationContext context) throws ValidationException {
        if (this._descriptor == null) {
            return;
        }
        if (object == null) {
            return;
        }
        if (this._descriptor.isReference()) {
            return;
        }
        if (this._descriptor.isTransient()) {
            return;
        }
        FieldHandler handler = this._descriptor.getHandler();
        if (handler == null) {
            return;
        }
        Object value = handler.getValue(object);
        if (value == null) {
            if (!this._descriptor.isRequired() || this._descriptor.isNillable()) {
                return;
            }
            String err = "The field '" + this._descriptor.getFieldName() + "' ";
            if (!ERROR_NAME.equals(this._descriptor.getXMLName())) {
                err = err + "(whose xml name is '" + this._descriptor.getXMLName() + "') ";
            }
            err = err + "is a required field of class '" + object.getClass().getName();
            throw new ValidationException(err);
        }
        if (context != null) {
            if (context.isValidated(object)) {
                return;
            }
            context.addValidated(object);
        }
        Class<?> type = value.getClass();
        int size = 1;
        try {
            boolean byteArray = false;
            if (type.isArray()) {
                boolean bl = byteArray = type.getComponentType() == Byte.TYPE;
                if (!byteArray) {
                    size = Array.getLength(value);
                    if (this._validator != null) {
                        for (int i = 0; i < size; ++i) {
                            this._validator.validate(Array.get(value, i), context);
                        }
                    } else {
                        for (int i = 0; i < size; ++i) {
                            super.validate(Array.get(value, i), context);
                        }
                    }
                }
            } else if (value instanceof Enumeration) {
                Enumeration enumeration = (Enumeration)value;
                size = 0;
                while (enumeration.hasMoreElements()) {
                    ++size;
                    Object obj = enumeration.nextElement();
                    if (this._validator != null) {
                        this._validator.validate(obj, context);
                        continue;
                    }
                    super.validate(obj, context);
                }
            } else if (value instanceof Vector) {
                Vector vector = (Vector)value;
                size = vector.size();
                for (int i = 0; i < size; ++i) {
                    if (this._validator != null) {
                        this._validator.validate(vector.elementAt(i), context);
                        continue;
                    }
                    super.validate(vector.elementAt(i), context);
                }
            } else if (value instanceof List) {
                List list = (List)value;
                size = list.size();
                for (int i = 0; i < size; ++i) {
                    if (this._validator != null) {
                        this._validator.validate(list.get(i), context);
                        continue;
                    }
                    super.validate(list.get(i), context);
                }
            } else if (this._validator != null) {
                this._validator.validate(value, context);
            } else {
                super.validate(value, context);
            }
        }
        catch (ValidationException vx) {
            String err = "The following exception occured while validating field: " + this._descriptor.getFieldName() + " of class: " + object.getClass().getName();
            throw new ValidationException(err, vx);
        }
        if (size < this.minOccurs && (size != 0 || this._descriptor.isRequired())) {
            String err = "A minimum of " + this.minOccurs + " ";
            err = err + this._descriptor.getFieldName() + " object(s) ";
            if (!ERROR_NAME.equals(this._descriptor.getXMLName())) {
                err = err + "(whose xml name is '" + this._descriptor.getXMLName() + "') ";
            }
            err = err + "are required for class: " + object.getClass().getName();
            throw new ValidationException(err);
        }
        if (this.maxOccurs >= 0 && size > this.maxOccurs) {
            String err = "A maximum of " + this.maxOccurs + " ";
            err = err + this._descriptor.getFieldName() + " object(s) ";
            if (!ERROR_NAME.equals(this._descriptor.getXMLName())) {
                err = err + "(whose xml name is '" + this._descriptor.getXMLName() + "') ";
            }
            err = err + "are required for class: " + object.getClass().getName() + ".";
            throw new ValidationException(err);
        }
        if (context != null) {
            context.removeValidated(object);
        }
    }
}

