/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.wordvector;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import opennlp.tools.util.java.Experimental;
import opennlp.tools.util.wordvector.FloatArrayVector;
import opennlp.tools.util.wordvector.MapWordVectorTable;
import opennlp.tools.util.wordvector.WordVectorTable;

@Experimental
public class Glove {
    private Glove() {
    }

    @Experimental
    public static WordVectorTable parse(InputStream in) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8), 0x100000);
        HashMap<String, FloatArrayVector> vectors = new HashMap<String, FloatArrayVector>();
        int dimension = -1;
        while ((line = reader.readLine()) != null) {
            String[] parts = line.split(" ");
            if (dimension == -1) {
                dimension = parts.length - 1;
            } else if (dimension != parts.length - 1) {
                throw new IOException("Vector dimension must be constant!");
            }
            String token = parts[0];
            float[] vector = new float[dimension];
            for (int i = 0; i < vector.length; ++i) {
                vector[i] = Float.parseFloat(parts[i + 1]);
            }
            vectors.put(token, new FloatArrayVector(vector));
        }
        return new MapWordVectorTable(Collections.unmodifiableMap(vectors));
    }
}

