/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.ZkClientClusterStateProvider;
import org.apache.solr.common.AlreadyClosedException;
import org.apache.solr.common.Callable;
import org.apache.solr.common.SolrCloseable;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.CloudCollectionsListener;
import org.apache.solr.common.cloud.ClusterProperties;
import org.apache.solr.common.cloud.ClusterPropertiesListener;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CollectionPropsWatcher;
import org.apache.solr.common.cloud.CollectionStatePredicate;
import org.apache.solr.common.cloud.CollectionStateWatcher;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocCollectionWatcher;
import org.apache.solr.common.cloud.LiveNodesListener;
import org.apache.solr.common.cloud.LiveNodesPredicate;
import org.apache.solr.common.cloud.OnReconnect;
import org.apache.solr.common.cloud.PerReplicaStates;
import org.apache.solr.common.cloud.PerReplicaStatesFetcher;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.util.CommonTestInjection;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkStateReader
implements SolrCloseable {
    public static final int STATE_UPDATE_DELAY = Integer.getInteger("solr.OverseerStateUpdateDelay", 2000);
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String BASE_URL_PROP = "base_url";
    public static final String NODE_NAME_PROP = "node_name";
    public static final String CORE_NODE_NAME_PROP = "core_node_name";
    public static final String ROLES_PROP = "roles";
    public static final String STATE_PROP = "state";
    public static final String FORCE_SET_STATE_PROP = "force_set_state";
    public static final String CORE_NAME_PROP = "core";
    public static final String COLLECTION_PROP = "collection";
    public static final String ELECTION_NODE_PROP = "election_node";
    public static final String SHARD_ID_PROP = "shard";
    public static final String REPLICA_PROP = "replica";
    public static final String SHARD_RANGE_PROP = "shard_range";
    public static final String SHARD_STATE_PROP = "shard_state";
    public static final String SHARD_PARENT_PROP = "shard_parent";
    public static final String NUM_SHARDS_PROP = "numShards";
    public static final String LEADER_PROP = "leader";
    public static final String SHARED_STORAGE_PROP = "shared_storage";
    public static final String PROPERTY_PROP = "property";
    public static final String PROPERTY_PROP_PREFIX = "property.";
    public static final String PROPERTY_VALUE_PROP = "property.value";
    public static final String MAX_AT_ONCE_PROP = "maxAtOnce";
    public static final String MAX_WAIT_SECONDS_PROP = "maxWaitSeconds";
    public static final String STATE_TIMESTAMP_PROP = "stateTimestamp";
    public static final String COLLECTIONS_ZKNODE = "/collections";
    public static final String LIVE_NODES_ZKNODE = "/live_nodes";
    public static final String NODE_ROLES = "/node_roles";
    public static final String ROLES = "/roles.json";
    public static final String ALIASES = "/aliases.json";
    public static final String UNSUPPORTED_CLUSTER_STATE = "/clusterstate.json";
    public static final String CLUSTER_PROPS = "/clusterprops.json";
    public static final String COLLECTION_PROPS_ZKNODE = "collectionprops.json";
    public static final String REJOIN_AT_HEAD_PROP = "rejoinAtHead";
    public static final String SOLR_SECURITY_CONF_PATH = "/security.json";
    public static final String SOLR_PKGS_PATH = "/packages.json";
    public static final String DEFAULT_SHARD_PREFERENCES = "defaultShardPreferences";
    public static final String REPLICATION_FACTOR = "replicationFactor";
    public static final String MAX_CORES_PER_NODE = "maxCoresPerNode";
    public static final String PULL_REPLICAS = "pullReplicas";
    public static final String NRT_REPLICAS = "nrtReplicas";
    public static final String TLOG_REPLICAS = "tlogReplicas";
    public static final String READ_ONLY = "readOnly";
    public static final String CONFIGS_ZKNODE = "/configs";
    public static final String CONFIGNAME_PROP = "configName";
    @Deprecated
    public static final String COLLECTION_DEF = "collectionDefaults";
    public static final String URL_SCHEME = "urlScheme";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String HTTPS_PORT_PROP = "solr.jetty.https.port";
    private static final String SOLR_ENVIRONMENT = "environment";
    public static final String REPLICA_TYPE = "type";
    public static final String CONTAINER_PLUGINS = "plugin";
    public static final String PLACEMENT_PLUGIN = "placement-plugin";
    protected volatile ClusterState clusterState;
    private static final int GET_LEADER_RETRY_INTERVAL_MS = 50;
    private static final int GET_LEADER_RETRY_DEFAULT_TIMEOUT = Integer.parseInt(System.getProperty("zkReaderGetLeaderRetryTimeoutMs", "4000"));
    public static final String LEADER_ELECT_ZKNODE = "leader_elect";
    public static final String SHARD_LEADERS_ZKNODE = "leaders";
    public static final String ELECTION_NODE = "election";
    private final ConcurrentHashMap<String, LazyCollectionRef> lazyCollectionStates = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, VersionedCollectionProps> watchedCollectionProps = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, PropsWatcher> collectionPropsWatchers = new ConcurrentHashMap();
    private volatile SortedSet<String> liveNodes = Collections.emptySortedSet();
    private volatile Map<String, Object> clusterProperties = Collections.emptyMap();
    private ConfigData securityData;
    private final Runnable securityNodeListener;
    private DocCollectionWatches collectionWatches = new DocCollectionWatches();
    private ConcurrentHashMap<String, CollectionWatch<CollectionPropsWatcher>> collectionPropsObservers = new ConcurrentHashMap();
    private Set<CloudCollectionsListener> cloudCollectionsListeners = ConcurrentHashMap.newKeySet();
    private final ExecutorService notifications = ExecutorUtil.newMDCAwareCachedThreadPool((String)"watches");
    private Set<LiveNodesListener> liveNodesListeners = ConcurrentHashMap.newKeySet();
    private Set<ClusterPropertiesListener> clusterPropertiesListeners = ConcurrentHashMap.newKeySet();
    private final ExecutorService collectionPropsNotifications = ExecutorUtil.newMDCAwareSingleThreadExecutor((ThreadFactory)new SolrNamedThreadFactory("collectionPropsNotifications"));
    private static final long LAZY_CACHE_TIME = TimeUnit.NANOSECONDS.convert(STATE_UPDATE_DELAY, TimeUnit.MILLISECONDS);
    private Future<?> collectionPropsCacheCleaner;
    public static final Set<String> KNOWN_CLUSTER_PROPS = Set.of("urlScheme", "location", "defaultShardPreferences", "maxCoresPerNode", "environment", "defaults", "plugin", "placement-plugin");
    private final SolrZkClient zkClient;
    private final boolean closeClient;
    private volatile boolean closed = false;
    private Set<CountDownLatch> waitLatches = ConcurrentHashMap.newKeySet();
    private final Object refreshCollectionListLock = new Object();
    private final Object refreshCollectionsSetLock = new Object();
    private final AtomicReference<Set<String>> lastFetchedCollectionSet = new AtomicReference();
    private final Object refreshLiveNodesLock = new Object();
    private final AtomicReference<SortedSet<String>> lastFetchedLiveNodes = new AtomicReference();
    private final Watcher clusterPropertiesWatcher = event -> {
        if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
            return;
        }
        this.loadClusterProperties();
    };
    public final AliasesManager aliasesManager = new AliasesManager();

    public static ZkStateReader from(CloudSolrClient solrClient) {
        try {
            ZkClientClusterStateProvider provider = (ZkClientClusterStateProvider)solrClient.getClusterStateProvider();
            return provider.getZkStateReader();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("client must be ZK based", e);
        }
    }

    public ZkStateReader(SolrZkClient zkClient) {
        this(zkClient, null);
    }

    public ZkStateReader(SolrZkClient zkClient, Runnable securityNodeListener) {
        this.zkClient = zkClient;
        this.closeClient = false;
        this.securityNodeListener = securityNodeListener;
        assert (ObjectReleaseTracker.track((Object)this));
    }

    public ZkStateReader(String zkServerAddress, int zkClientTimeout, int zkClientConnectTimeout) {
        this.zkClient = new SolrZkClient(zkServerAddress, zkClientTimeout, zkClientConnectTimeout, new OnReconnect(){

            @Override
            public void command() {
                try {
                    ZkStateReader.this.createClusterStateWatchersAndUpdate();
                }
                catch (KeeperException e) {
                    log.error("A ZK error has occurred", (Throwable)e);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A ZK error has occurred", e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.error("Interrupted", (Throwable)e);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted", e);
                }
            }
        });
        this.closeClient = true;
        this.securityNodeListener = null;
        assert (ObjectReleaseTracker.track((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forciblyRefreshAllClusterStateSlow() throws KeeperException, InterruptedException {
        Object object = this.getUpdateLock();
        synchronized (object) {
            if (this.clusterState == null) {
                this.createClusterStateWatchersAndUpdate();
                return;
            }
            this.refreshCollectionList(null);
            this.refreshLiveNodes(null);
            HashSet<String> updatedCollections = new HashSet<String>();
            for (String coll : this.collectionWatches.watchedCollections()) {
                DocCollection newState;
                if (!this.collectionWatches.updateDocCollection(coll, newState = this.fetchCollectionState(coll, null))) continue;
                updatedCollections.add(coll);
            }
            this.constructState(updatedCollections);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceUpdateCollection(String collection) throws KeeperException, InterruptedException {
        Object object = this.getUpdateLock();
        synchronized (object) {
            if (this.clusterState == null) {
                log.warn("ClusterState watchers have not been initialized");
                return;
            }
            ClusterState.CollectionRef ref = this.clusterState.getCollectionRef(collection);
            if (ref == null) {
                LazyCollectionRef tryLazyCollection = new LazyCollectionRef(collection);
                if (tryLazyCollection.get() != null) {
                    log.debug("Adding lazily-loaded reference for collection {}", (Object)collection);
                    this.lazyCollectionStates.putIfAbsent(collection, tryLazyCollection);
                    this.constructState(Collections.singleton(collection));
                }
            } else if (ref.isLazilyLoaded()) {
                log.debug("Refreshing lazily-loaded state for collection {}", (Object)collection);
                if (ref.get() != null) {
                    return;
                }
            } else if (this.collectionWatches.watchedCollections().contains(collection)) {
                log.debug("Forcing refresh of watched collection state for {}", (Object)collection);
                DocCollection newState = this.fetchCollectionState(collection, null);
                if (this.collectionWatches.updateDocCollection(collection, newState)) {
                    this.constructState(Collections.singleton(collection));
                }
            } else {
                log.error("Collection {} is not lazy nor watched!", (Object)collection);
            }
        }
    }

    public void updateLiveNodes() throws KeeperException, InterruptedException {
        this.refreshLiveNodes(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer compareStateVersions(String coll, int version) {
        DocCollection collection = this.clusterState.getCollectionOrNull(coll);
        if (collection == null) {
            return null;
        }
        if (collection.getZNodeVersion() < version) {
            DocCollection nu;
            if (log.isDebugEnabled()) {
                log.debug("Server older than client {}<{}", (Object)collection.getZNodeVersion(), (Object)version);
            }
            if ((nu = this.getCollectionLive(coll)) == null) {
                return -1;
            }
            if (nu.getZNodeVersion() > collection.getZNodeVersion()) {
                if (this.collectionWatches.updateDocCollection(coll, nu)) {
                    Object object = this.getUpdateLock();
                    synchronized (object) {
                        this.constructState(Collections.singleton(coll));
                    }
                }
                collection = nu;
            }
        }
        if (collection.getZNodeVersion() == version) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Wrong version from client [{}]!=[{}]", (Object)version, (Object)collection.getZNodeVersion());
        }
        return collection.getZNodeVersion();
    }

    public synchronized void createClusterStateWatchersAndUpdate() throws KeeperException, InterruptedException {
        log.debug("Updating cluster state from ZooKeeper... ");
        try {
            this.loadClusterProperties();
            this.refreshLiveNodes(new LiveNodeWatcher());
            this.refreshCollections();
            this.refreshCollectionList(new CollectionsChildWatcher());
            this.refreshAliases(this.aliasesManager);
            if (this.securityNodeListener != null) {
                this.addSecurityNodeWatcher((Callable<Pair<byte[], Stat>>)((Callable)pair -> {
                    ConfigData cd = new ConfigData();
                    cd.data = pair.first() == null || ((byte[])pair.first()).length == 0 ? Collections.emptyMap() : Utils.getDeepCopy((Map)((Map)Utils.fromJSON((byte[])((byte[])pair.first()))), (int)4, (boolean)false);
                    cd.version = pair.second() == null ? -1 : ((Stat)pair.second()).getVersion();
                    this.securityData = cd;
                    this.securityNodeListener.run();
                }));
                this.securityData = this.getSecurityProps(true);
            }
            this.collectionPropsObservers.forEach((k, v) -> this.collectionPropsWatchers.computeIfAbsent((String)k, x$0 -> new PropsWatcher((String)x$0)).refreshAndWatch(true));
        }
        catch (KeeperException.NoNodeException nne) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Cannot connect to cluster at " + this.zkClient.getZkServerAddress() + ": cluster not found/not ready. Expected node '" + nne.getPath() + "' does not exist.");
        }
    }

    private void addSecurityNodeWatcher(final Callable<Pair<byte[], Stat>> callback) throws KeeperException, InterruptedException {
        this.zkClient.exists(SOLR_SECURITY_CONF_PATH, new Watcher(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void process(WatchedEvent event) {
                if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                    return;
                }
                try {
                    Object object = ZkStateReader.this.getUpdateLock();
                    synchronized (object) {
                        log.debug("Updating [{}] ... ", (Object)ZkStateReader.SOLR_SECURITY_CONF_PATH);
                        Stat stat = new Stat();
                        byte[] data = "{}".getBytes(StandardCharsets.UTF_8);
                        if (Watcher.Event.EventType.NodeDeleted.equals((Object)event.getType())) {
                            ZkStateReader.this.getZkClient().exists(ZkStateReader.SOLR_SECURITY_CONF_PATH, this, true);
                        } else {
                            data = ZkStateReader.this.getZkClient().getData(ZkStateReader.SOLR_SECURITY_CONF_PATH, this, stat, true);
                        }
                        try {
                            callback.call((Object)new Pair((Object)data, (Object)stat));
                        }
                        catch (Exception e) {
                            log.error("Error running collections node listener", (Throwable)e);
                        }
                    }
                }
                catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException e) {
                    log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK: ", e);
                }
                catch (KeeperException e) {
                    log.error("A ZK error has occurred", (Throwable)e);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.warn("Interrupted", (Throwable)e);
                }
            }
        }, true);
    }

    private void constructState(Set<String> changedCollections) {
        SortedSet<String> liveNodes = this.liveNodes;
        LinkedHashMap<String, ClusterState.CollectionRef> result = new LinkedHashMap<String, ClusterState.CollectionRef>();
        for (Map.Entry<String, StatefulCollectionWatch> entry : this.collectionWatches.watchedCollectionEntries()) {
            if (entry.getValue().currentState == null) continue;
            result.put(entry.getKey(), new ClusterState.CollectionRef(entry.getValue().currentState));
        }
        for (Map.Entry<String, Object> entry : this.lazyCollectionStates.entrySet()) {
            result.putIfAbsent(entry.getKey(), (ClusterState.CollectionRef)entry.getValue());
        }
        this.clusterState = new ClusterState(result, liveNodes);
        if (log.isDebugEnabled()) {
            log.debug("clusterStateSet: interesting [{}] watched [{}] lazy [{}] total [{}]", new Object[]{this.collectionWatches.watchedCollections().size(), this.collectionWatches.activeCollectionCount(), ((ConcurrentHashMap.CollectionView)((Object)this.lazyCollectionStates.keySet())).size(), this.clusterState.getCollectionStates().size()});
        }
        if (log.isTraceEnabled()) {
            log.trace("clusterStateSet: interesting [{}] watched [{}] lazy [{}] total [{}]", new Object[]{this.collectionWatches.watchedCollections(), this.collectionWatches.activeCollections(), this.lazyCollectionStates.keySet(), this.clusterState.getCollectionStates()});
        }
        this.notifyCloudCollectionsListeners();
        for (String string : changedCollections) {
            this.notifyStateWatchers(string, this.clusterState.getCollectionOrNull(string));
        }
    }

    private void refreshCollections() {
        for (String coll : this.collectionWatches.watchedCollections()) {
            new StateWatcher(coll).refreshAndWatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshCollectionList(Watcher watcher) throws KeeperException, InterruptedException {
        Object object = this.refreshCollectionListLock;
        synchronized (object) {
            List<String> children = null;
            try {
                children = this.zkClient.getChildren(COLLECTIONS_ZKNODE, watcher, true);
            }
            catch (KeeperException.NoNodeException e) {
                log.warn("Error fetching collection names: ", (Throwable)e);
            }
            if (children == null || children.isEmpty()) {
                this.lazyCollectionStates.clear();
                return;
            }
            ((ConcurrentHashMap.CollectionView)((Object)this.lazyCollectionStates.keySet())).retainAll(children);
            for (String coll : children) {
                LazyCollectionRef existing;
                if (this.collectionWatches.watchedCollections().contains(coll) || (existing = this.lazyCollectionStates.get(coll)) != null) continue;
                this.lazyCollectionStates.putIfAbsent(coll, new LazyCollectionRef(coll));
            }
        }
    }

    public void registerCloudCollectionsListener(CloudCollectionsListener cloudCollectionsListener) {
        this.cloudCollectionsListeners.add(cloudCollectionsListener);
        this.notifyNewCloudCollectionsListener(cloudCollectionsListener);
    }

    public void removeCloudCollectionsListener(CloudCollectionsListener cloudCollectionsListener) {
        this.cloudCollectionsListeners.remove(cloudCollectionsListener);
    }

    private void notifyNewCloudCollectionsListener(CloudCollectionsListener listener) {
        listener.onChange(Collections.emptySet(), this.lastFetchedCollectionSet.get());
    }

    private void notifyCloudCollectionsListeners() {
        this.notifyCloudCollectionsListeners(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCloudCollectionsListeners(boolean notifyIfSame) {
        Object object = this.refreshCollectionsSetLock;
        synchronized (object) {
            Set<String> newCollections = this.getCurrentCollections();
            Set<String> oldCollections = this.lastFetchedCollectionSet.getAndSet(newCollections);
            if (!newCollections.equals(oldCollections) || notifyIfSame) {
                this.cloudCollectionsListeners.forEach(listener -> listener.onChange(oldCollections, newCollections));
            }
        }
    }

    public Set<String> getCurrentCollections() {
        HashSet<String> collections = new HashSet<String>();
        collections.addAll(this.collectionWatches.activeCollections());
        collections.addAll(this.lazyCollectionStates.keySet());
        return collections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshLiveNodes(Watcher watcher) throws KeeperException, InterruptedException {
        SortedSet<String> oldLiveNodes;
        SortedSet newLiveNodes;
        Object object = this.refreshLiveNodesLock;
        synchronized (object) {
            try {
                List<String> nodeList = this.zkClient.getChildren(LIVE_NODES_ZKNODE, watcher, true);
                newLiveNodes = new TreeSet<String>(nodeList);
            }
            catch (KeeperException.NoNodeException e) {
                newLiveNodes = Collections.emptySortedSet();
            }
            this.lastFetchedLiveNodes.set(newLiveNodes);
        }
        Object object2 = this.getUpdateLock();
        synchronized (object2) {
            newLiveNodes = this.lastFetchedLiveNodes.getAndSet(null);
            if (newLiveNodes == null) {
                return;
            }
            oldLiveNodes = this.liveNodes;
            this.liveNodes = newLiveNodes;
            if (this.clusterState != null) {
                this.clusterState.setLiveNodes((Set)newLiveNodes);
            }
        }
        if (oldLiveNodes.size() != newLiveNodes.size() && log.isInfoEnabled()) {
            log.info("Updated live nodes from ZooKeeper... ({}) -> ({})", (Object)oldLiveNodes.size(), (Object)newLiveNodes.size());
        }
        if (log.isDebugEnabled()) {
            log.debug("Updated live nodes from ZooKeeper... {} -> {}", oldLiveNodes, (Object)newLiveNodes);
        }
        if (!oldLiveNodes.equals(newLiveNodes)) {
            this.liveNodesListeners.forEach(listener -> {
                if (listener.onChange(new TreeSet<String>(oldLiveNodes), new TreeSet<String>(newLiveNodes))) {
                    this.removeLiveNodesListener((LiveNodesListener)listener);
                }
            });
        }
    }

    public void registerClusterPropertiesListener(ClusterPropertiesListener listener) {
        if (listener.onChange(this.getClusterProperties())) {
            this.removeClusterPropertiesListener(listener);
        } else {
            this.clusterPropertiesListeners.add(listener);
        }
    }

    public void removeClusterPropertiesListener(ClusterPropertiesListener listener) {
        this.clusterPropertiesListeners.remove(listener);
    }

    public void registerLiveNodesListener(LiveNodesListener listener) {
        if (listener.onChange(new TreeSet<String>(this.getClusterState().getLiveNodes()), new TreeSet<String>(this.getClusterState().getLiveNodes()))) {
            this.removeLiveNodesListener(listener);
        }
        this.liveNodesListeners.add(listener);
    }

    public void removeLiveNodesListener(LiveNodesListener listener) {
        this.liveNodesListeners.remove(listener);
    }

    public ClusterState getClusterState() {
        return this.clusterState;
    }

    public Object getUpdateLock() {
        return this;
    }

    public void close() {
        this.closed = true;
        this.notifications.shutdownNow();
        this.waitLatches.parallelStream().forEach(c -> c.countDown());
        ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.notifications);
        ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.collectionPropsNotifications);
        if (this.closeClient) {
            this.zkClient.close();
        }
        assert (ObjectReleaseTracker.release((Object)this));
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String getLeaderUrl(String collection, String shard, int timeout) throws InterruptedException {
        Replica replica = this.getLeaderRetry(collection, shard, timeout);
        if (replica == null || replica.getBaseUrl() == null) {
            return null;
        }
        ZkCoreNodeProps props = new ZkCoreNodeProps((ZkNodeProps)replica);
        return props.getCoreUrl();
    }

    public Replica getLeader(Set<String> liveNodes, DocCollection docCollection, String shard) {
        Replica replica;
        Replica replica2 = replica = docCollection != null ? docCollection.getLeader(shard) : null;
        if (replica != null && liveNodes.contains(replica.getNodeName())) {
            return replica;
        }
        return null;
    }

    public Replica getLeader(String collection, String shard) {
        if (this.clusterState != null) {
            Replica replica;
            DocCollection docCollection = this.clusterState.getCollectionOrNull(collection);
            Replica replica2 = replica = docCollection != null ? docCollection.getLeader(shard) : null;
            if (replica != null && this.getClusterState().liveNodesContain(replica.getNodeName())) {
                return replica;
            }
        }
        return null;
    }

    public boolean isNodeLive(String node) {
        return this.liveNodes.contains(node);
    }

    public Replica getLeaderRetry(String collection, String shard) throws InterruptedException {
        return this.getLeaderRetry(collection, shard, GET_LEADER_RETRY_DEFAULT_TIMEOUT);
    }

    public Replica getLeaderRetry(String collection, String shard, int timeout) throws InterruptedException {
        AtomicReference coll = new AtomicReference();
        AtomicReference leader = new AtomicReference();
        try {
            this.waitForState(collection, (long)timeout, TimeUnit.MILLISECONDS, (n, c) -> {
                if (c == null) {
                    return false;
                }
                coll.set(c);
                Replica l = this.getLeader(n, c, shard);
                if (l != null) {
                    log.debug("leader found for {}/{} to be {}", new Object[]{collection, shard, l});
                    leader.set(l);
                    return true;
                }
                return false;
            });
        }
        catch (TimeoutException e) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "No registered leader was found after waiting for " + timeout + "ms , collection: " + collection + " slice: " + shard + " saw state=" + this.clusterState.getCollectionOrNull(collection) + " with live_nodes=" + this.clusterState.getLiveNodes());
        }
        return (Replica)leader.get();
    }

    public static String getShardLeadersPath(String collection, String shardId) {
        return "/collections/" + collection + "/leaders" + (String)(shardId != null ? "/" + shardId : "") + "/leader";
    }

    public static String getShardLeadersElectPath(String collection, String shardId) {
        return "/collections/" + collection + "/leader_elect" + (String)(shardId != null ? "/" + shardId + "/election" : "");
    }

    public List<ZkCoreNodeProps> getReplicaProps(String collection, String shardId, String thisCoreNodeName) {
        return this.getReplicaProps(collection, shardId, thisCoreNodeName, null);
    }

    public List<ZkCoreNodeProps> getReplicaProps(String collection, String shardId, String thisCoreNodeName, Replica.State mustMatchStateFilter) {
        return this.getReplicaProps(collection, shardId, thisCoreNodeName, mustMatchStateFilter, null);
    }

    public List<ZkCoreNodeProps> getReplicaProps(String collection, String shardId, String thisCoreNodeName, Replica.State mustMatchStateFilter, Replica.State mustNotMatchStateFilter) {
        return this.getReplicaProps(collection, shardId, thisCoreNodeName, mustMatchStateFilter, null, EnumSet.of(Replica.Type.TLOG, Replica.Type.NRT));
    }

    public List<ZkCoreNodeProps> getReplicaProps(String collection, String shardId, String thisCoreNodeName, Replica.State mustMatchStateFilter, Replica.State mustNotMatchStateFilter, EnumSet<Replica.Type> acceptReplicaType) {
        assert (thisCoreNodeName != null);
        ClusterState clusterState = this.clusterState;
        if (clusterState == null) {
            return null;
        }
        DocCollection docCollection = clusterState.getCollectionOrNull(collection);
        if (docCollection == null || docCollection.getSlicesMap() == null) {
            throw new ZooKeeperException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection in zk: " + collection);
        }
        Map slices = docCollection.getSlicesMap();
        Slice replicas = (Slice)slices.get(shardId);
        if (replicas == null) {
            throw new ZooKeeperException(SolrException.ErrorCode.BAD_REQUEST, "Could not find shardId in zk: " + shardId);
        }
        Map shardMap = replicas.getReplicasMap();
        ArrayList<ZkCoreNodeProps> nodes = new ArrayList<ZkCoreNodeProps>(shardMap.size());
        for (Map.Entry entry : shardMap.entrySet().stream().filter(e -> acceptReplicaType.contains(((Replica)e.getValue()).getType())).collect(Collectors.toList())) {
            ZkCoreNodeProps nodeProps = new ZkCoreNodeProps((ZkNodeProps)entry.getValue());
            String coreNodeName = ((Replica)entry.getValue()).getName();
            if (!clusterState.liveNodesContain(nodeProps.getNodeName()) || coreNodeName.equals(thisCoreNodeName) || mustMatchStateFilter != null && mustMatchStateFilter != Replica.State.getState((String)nodeProps.getState()) || mustNotMatchStateFilter != null && mustNotMatchStateFilter == Replica.State.getState((String)nodeProps.getState())) continue;
            nodes.add(nodeProps);
        }
        if (nodes.size() == 0) {
            return null;
        }
        return nodes;
    }

    public SolrZkClient getZkClient() {
        return this.zkClient;
    }

    public <T> T getClusterProperty(String key, T defaultValue) {
        Object value = Utils.getObjectByPath(this.clusterProperties, (boolean)false, (String)key);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    public <T> T getClusterProperty(List<String> keyPath, T defaultValue) {
        Object value = Utils.getObjectByPath(this.clusterProperties, (boolean)false, keyPath);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    public Map<String, Object> getClusterProperties() {
        return Collections.unmodifiableMap(this.clusterProperties);
    }

    private void loadClusterProperties() {
        try {
            while (true) {
                try {
                    byte[] data = this.zkClient.getData(CLUSTER_PROPS, this.clusterPropertiesWatcher, new Stat(), true);
                    Map properties = (Map)Utils.fromJSON((byte[])data);
                    this.clusterProperties = ClusterProperties.convertCollectionDefaultsToNestedFormat(properties);
                    log.debug("Loaded cluster properties: {}", this.clusterProperties);
                    for (ClusterPropertiesListener listener : this.clusterPropertiesListeners) {
                        listener.onChange(this.getClusterProperties());
                    }
                    return;
                }
                catch (KeeperException.NoNodeException e) {
                    this.clusterProperties = Collections.emptyMap();
                    log.debug("Loaded empty cluster properties");
                    if (this.zkClient.exists(CLUSTER_PROPS, this.clusterPropertiesWatcher, true) != null) continue;
                    return;
                }
                break;
            }
        }
        catch (InterruptedException | KeeperException e) {
            log.error("Error reading cluster properties from zookeeper", SolrZkClient.checkInterrupted(e));
            return;
        }
    }

    public Map<String, String> getCollectionProperties(String collection) {
        return this.getCollectionProperties(collection, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getCollectionProperties(String collection, long cacheForMillis) {
        ConcurrentHashMap<String, VersionedCollectionProps> concurrentHashMap = this.watchedCollectionProps;
        synchronized (concurrentHashMap) {
            Map<String, String> properties;
            VersionedCollectionProps vprops;
            Watcher watcher = null;
            if (cacheForMillis > 0L) {
                watcher = this.collectionPropsWatchers.compute(collection, (c, w) -> w == null ? new PropsWatcher((String)c, cacheForMillis) : w.renew(cacheForMillis));
            }
            boolean haveUnexpiredProps = (vprops = this.watchedCollectionProps.get(collection)) != null && vprops.cacheUntilNs > System.nanoTime();
            long untilNs = System.nanoTime() + TimeUnit.NANOSECONDS.convert(cacheForMillis, TimeUnit.MILLISECONDS);
            if (haveUnexpiredProps) {
                properties = vprops.props;
                vprops.cacheUntilNs = Math.max(vprops.cacheUntilNs, untilNs);
            } else {
                try {
                    VersionedCollectionProps vcp = this.fetchCollectionProperties(collection, watcher);
                    properties = vcp.props;
                    if (cacheForMillis > 0L) {
                        vcp.cacheUntilNs = untilNs;
                        this.watchedCollectionProps.put(collection, vcp);
                    } else if (!this.collectionPropsObservers.containsKey(collection)) {
                        this.watchedCollectionProps.remove(collection);
                    }
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading collection properties", SolrZkClient.checkInterrupted(e));
                }
            }
            return properties;
        }
    }

    static String getCollectionPropsPath(String collection) {
        return "/collections/" + collection + "/collectionprops.json";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VersionedCollectionProps fetchCollectionProperties(String collection, Watcher watcher) throws KeeperException, InterruptedException {
        String znodePath = ZkStateReader.getCollectionPropsPath(collection);
        if (this.collectionPropsCacheCleaner == null) {
            ZkStateReader zkStateReader = this;
            synchronized (zkStateReader) {
                if (this.collectionPropsCacheCleaner == null) {
                    this.collectionPropsCacheCleaner = this.notifications.submit(new CacheCleaner());
                }
            }
        }
        while (true) {
            try {
                Stat stat = new Stat();
                byte[] data = this.zkClient.getData(znodePath, watcher, stat, true);
                Map props = (Map)Utils.fromJSON((byte[])data);
                return new VersionedCollectionProps(stat.getVersion(), props);
            }
            catch (ClassCastException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to parse collection properties for collection " + collection, (Throwable)e);
            }
            catch (KeeperException.NoNodeException e) {
                Stat exists;
                if (watcher != null && (exists = this.zkClient.exists(znodePath, watcher, true)) != null) continue;
                return new VersionedCollectionProps(-1, Collections.emptyMap());
            }
            break;
        }
    }

    public ConfigData getSecurityProps(boolean getFresh) {
        if (!getFresh) {
            if (this.securityData == null) {
                return new ConfigData(Collections.emptyMap(), -1);
            }
            return new ConfigData(this.securityData.data, this.securityData.version);
        }
        try {
            Stat stat = new Stat();
            if (this.getZkClient().exists(SOLR_SECURITY_CONF_PATH, true).booleanValue()) {
                byte[] data = this.getZkClient().getData(SOLR_SECURITY_CONF_PATH, null, stat, true);
                return data != null && data.length > 0 ? new ConfigData((Map)Utils.fromJSON((byte[])data), stat.getVersion()) : null;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading security properties", (Throwable)e);
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading security properties", (Throwable)e);
        }
        return null;
    }

    public String getBaseUrlForNodeName(String nodeName) {
        return Utils.getBaseUrlForNodeName((String)nodeName, (String)this.getClusterProperty(URL_SCHEME, HTTP));
    }

    public DocCollection getCollectionLive(String coll) {
        try {
            return this.fetchCollectionState(coll, null);
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not load collection from ZK: " + coll, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not load collection from ZK: " + coll, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocCollection fetchCollectionState(String coll, Watcher watcher) throws KeeperException, InterruptedException {
        String collectionPath = DocCollection.getCollectionPath((String)coll);
        while (true) {
            ClusterState.initReplicaStateProvider(() -> {
                try {
                    PerReplicaStates replicaStates = PerReplicaStatesFetcher.fetch(collectionPath, this.zkClient, null);
                    log.debug("per-replica-state ver: {} fetched for initializing {} ", (Object)replicaStates.cversion, (Object)collectionPath);
                    return replicaStates;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            try {
                Stat stat = new Stat();
                byte[] data = this.zkClient.getData(collectionPath, watcher, stat, true);
                ClusterState state = ZkClientClusterStateProvider.createFromJsonSupportingLegacyConfigName(stat.getVersion(), data, Collections.emptySet(), coll, this.zkClient);
                ClusterState.CollectionRef collectionRef = (ClusterState.CollectionRef)state.getCollectionStates().get(coll);
                DocCollection docCollection = collectionRef == null ? null : collectionRef.get();
                return docCollection;
            }
            catch (KeeperException.NoNodeException e) {
                Stat exists;
                if (watcher != null && (exists = this.zkClient.exists(collectionPath, watcher, true)) != null) continue;
                DocCollection docCollection = null;
                return docCollection;
            }
            finally {
                ClusterState.clearReplicaStateProvider();
                continue;
            }
            break;
        }
    }

    @Deprecated
    public static String getCollectionPathRoot(String coll) {
        return DocCollection.getCollectionPathRoot((String)coll);
    }

    @Deprecated
    public static String getCollectionPath(String coll) {
        return DocCollection.getCollectionPath((String)coll);
    }

    public void registerCore(String collection) {
        AtomicBoolean reconstructState = new AtomicBoolean(false);
        this.collectionWatches.compute(collection, (k, v) -> {
            if (v == null) {
                reconstructState.set(true);
                v = new StatefulCollectionWatch();
            }
            ++v.coreRefCount;
            return v;
        });
        if (reconstructState.get()) {
            new StateWatcher(collection).refreshAndWatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCore(String collection) {
        AtomicBoolean reconstructState = new AtomicBoolean(false);
        this.collectionWatches.compute(collection, (k, v) -> {
            if (v == null) {
                return null;
            }
            if (v.coreRefCount > 0) {
                --v.coreRefCount;
            }
            if (v.canBeRemoved()) {
                this.lazyCollectionStates.put(collection, new LazyCollectionRef(collection));
                reconstructState.set(true);
                return null;
            }
            return v;
        });
        if (reconstructState.get()) {
            Object object = this.getUpdateLock();
            synchronized (object) {
                this.constructState(Collections.emptySet());
            }
        }
    }

    public void registerCollectionStateWatcher(String collection, CollectionStateWatcher stateWatcher) {
        DocCollectionAndLiveNodesWatcherWrapper wrapper = new DocCollectionAndLiveNodesWatcherWrapper(collection, stateWatcher);
        this.registerDocCollectionWatcher(collection, wrapper);
        this.registerLiveNodesListener(wrapper);
        DocCollection state = this.clusterState.getCollectionOrNull(collection);
        if (stateWatcher.onStateChanged(this.liveNodes, state)) {
            this.removeCollectionStateWatcher(collection, stateWatcher);
        }
    }

    public void registerDocCollectionWatcher(String collection, DocCollectionWatcher stateWatcher) {
        DocCollection state;
        AtomicBoolean watchSet = new AtomicBoolean(false);
        this.collectionWatches.compute(collection, (k, v) -> {
            if (v == null) {
                v = new StatefulCollectionWatch();
                watchSet.set(true);
            }
            v.stateWatchers.add(stateWatcher);
            return v;
        });
        if (watchSet.get()) {
            new StateWatcher(collection).refreshAndWatch();
        }
        if (stateWatcher.onStateChanged(state = this.clusterState.getCollectionOrNull(collection))) {
            this.removeDocCollectionWatcher(collection, stateWatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForState(String collection, long wait, TimeUnit unit, CollectionStatePredicate predicate) throws InterruptedException, TimeoutException {
        if (this.closed) {
            throw new AlreadyClosedException();
        }
        CountDownLatch latch = new CountDownLatch(1);
        this.waitLatches.add(latch);
        AtomicReference docCollection = new AtomicReference();
        CollectionStateWatcher watcher = (n, c) -> {
            docCollection.set(c);
            boolean matches = predicate.matches(n, c);
            if (matches) {
                latch.countDown();
            }
            return matches;
        };
        try {
            this.registerCollectionStateWatcher(collection, watcher);
            if (!latch.await(wait, unit)) {
                throw new TimeoutException("Timeout waiting to see state for collection=" + collection + " :" + docCollection.get());
            }
        }
        finally {
            this.removeCollectionStateWatcher(collection, watcher);
            this.waitLatches.remove(latch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocCollection waitForState(String collection, long wait, TimeUnit unit, Predicate<DocCollection> predicate) throws InterruptedException, TimeoutException {
        if (log.isDebugEnabled()) {
            log.debug("Waiting up to {}ms for state {}", (Object)unit.toMillis(wait), predicate);
        }
        if (this.closed) {
            throw new AlreadyClosedException();
        }
        CountDownLatch latch = new CountDownLatch(1);
        this.waitLatches.add(latch);
        AtomicReference docCollection = new AtomicReference();
        DocCollectionWatcher watcher = c -> {
            docCollection.set(c);
            boolean matches = predicate.test(c);
            if (matches) {
                latch.countDown();
            }
            return matches;
        };
        try {
            this.registerDocCollectionWatcher(collection, watcher);
            if (!latch.await(wait, unit)) {
                throw new TimeoutException("Timeout waiting to see state for collection=" + collection + " :" + docCollection.get());
            }
            DocCollection docCollection2 = (DocCollection)docCollection.get();
            return docCollection2;
        }
        finally {
            this.removeDocCollectionWatcher(collection, watcher);
            this.waitLatches.remove(latch);
            if (log.isDebugEnabled()) {
                log.debug("Completed wait for {}", predicate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForLiveNodes(long wait, TimeUnit unit, LiveNodesPredicate predicate) throws InterruptedException, TimeoutException {
        if (this.closed) {
            throw new AlreadyClosedException();
        }
        CountDownLatch latch = new CountDownLatch(1);
        this.waitLatches.add(latch);
        LiveNodesListener listener = (o, n) -> {
            boolean matches = predicate.matches(o, n);
            if (matches) {
                latch.countDown();
            }
            return matches;
        };
        this.registerLiveNodesListener(listener);
        try {
            if (!latch.await(wait, unit)) {
                throw new TimeoutException("Timeout waiting for live nodes, currently they are: " + this.getClusterState().getLiveNodes());
            }
        }
        finally {
            this.removeLiveNodesListener(listener);
            this.waitLatches.remove(latch);
        }
    }

    public void removeCollectionStateWatcher(String collection, CollectionStateWatcher watcher) {
        DocCollectionAndLiveNodesWatcherWrapper wrapper = new DocCollectionAndLiveNodesWatcherWrapper(collection, watcher);
        this.removeDocCollectionWatcher(collection, wrapper);
        this.removeLiveNodesListener(wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDocCollectionWatcher(String collection, DocCollectionWatcher watcher) {
        AtomicBoolean reconstructState = new AtomicBoolean(false);
        this.collectionWatches.compute(collection, (k, v) -> {
            if (v == null) {
                return null;
            }
            v.stateWatchers.remove(watcher);
            if (v.canBeRemoved()) {
                this.lazyCollectionStates.put(collection, new LazyCollectionRef(collection));
                reconstructState.set(true);
                assert (CommonTestInjection.injectDelay());
                return null;
            }
            return v;
        });
        if (reconstructState.get()) {
            Object object = this.getUpdateLock();
            synchronized (object) {
                this.constructState(Collections.emptySet());
            }
        }
    }

    Set<DocCollectionWatcher> getStateWatchers(String collection) {
        HashSet<DocCollectionWatcher> watchers = new HashSet<DocCollectionWatcher>();
        this.collectionWatches.compute(collection, (k, v) -> {
            if (v != null) {
                watchers.addAll(v.stateWatchers);
            }
            return v;
        });
        return watchers;
    }

    public void registerCollectionPropsWatcher(String collection, CollectionPropsWatcher propsWatcher) {
        AtomicBoolean watchSet = new AtomicBoolean(false);
        this.collectionPropsObservers.compute(collection, (k, v) -> {
            if (v == null) {
                v = new CollectionWatch();
                watchSet.set(true);
            }
            v.stateWatchers.add(propsWatcher);
            return v;
        });
        if (watchSet.get()) {
            this.collectionPropsWatchers.computeIfAbsent(collection, x$0 -> new PropsWatcher((String)x$0)).refreshAndWatch(false);
        }
    }

    public void removeCollectionPropsWatcher(String collection, CollectionPropsWatcher watcher) {
        this.collectionPropsObservers.compute(collection, (k, v) -> {
            if (v == null) {
                return null;
            }
            v.stateWatchers.remove(watcher);
            if (v.canBeRemoved()) {
                ConcurrentHashMap<String, VersionedCollectionProps> concurrentHashMap = this.watchedCollectionProps;
                synchronized (concurrentHashMap) {
                    this.watchedCollectionProps.remove(collection);
                }
                return null;
            }
            return v;
        });
    }

    private void notifyStateWatchers(String collection, DocCollection collectionState) {
        block3: {
            if (this.closed) {
                return;
            }
            try {
                this.notifications.submit(new Notification(collection, collectionState));
            }
            catch (RejectedExecutionException e) {
                if (this.closed) break block3;
                log.error("Couldn't run collection notifications for {}", (Object)collection, (Object)e);
            }
        }
    }

    public Aliases getAliases() {
        return this.aliasesManager.getAliases();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshAliases(AliasesManager watcher) throws KeeperException, InterruptedException {
        Object object = this.getUpdateLock();
        synchronized (object) {
            this.constructState(Collections.emptySet());
            this.zkClient.exists(ALIASES, watcher, true);
        }
        this.aliasesManager.update();
    }

    private void notifyPropsWatchers(String collection, Map<String, String> properties) {
        block2: {
            try {
                this.collectionPropsNotifications.submit(new PropsNotification(collection, properties));
            }
            catch (RejectedExecutionException e) {
                if (this.closed) break block2;
                log.error("Couldn't run collection properties notifications for {}", (Object)collection, (Object)e);
            }
        }
    }

    public DocCollection getCollection(String collection) {
        return this.clusterState == null ? null : this.clusterState.getCollectionOrNull(collection);
    }

    private final class DocCollectionAndLiveNodesWatcherWrapper
    implements DocCollectionWatcher,
    LiveNodesListener {
        private final String collectionName;
        private final CollectionStateWatcher delegate;

        public int hashCode() {
            return this.collectionName.hashCode() * this.delegate.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof DocCollectionAndLiveNodesWatcherWrapper) {
                DocCollectionAndLiveNodesWatcherWrapper that = (DocCollectionAndLiveNodesWatcherWrapper)other;
                return this.collectionName.equals(that.collectionName) && this.delegate.equals(that.delegate);
            }
            return false;
        }

        public DocCollectionAndLiveNodesWatcherWrapper(String collectionName, CollectionStateWatcher delegate) {
            this.collectionName = collectionName;
            this.delegate = delegate;
        }

        @Override
        public boolean onStateChanged(DocCollection collectionState) {
            boolean result = this.delegate.onStateChanged(ZkStateReader.this.liveNodes, collectionState);
            if (result) {
                ZkStateReader.this.removeLiveNodesListener(this);
            }
            return result;
        }

        @Override
        public boolean onChange(SortedSet<String> oldLiveNodes, SortedSet<String> newLiveNodes) {
            DocCollection collection = ZkStateReader.this.clusterState.getCollectionOrNull(this.collectionName);
            boolean result = this.delegate.onStateChanged(newLiveNodes, collection);
            if (result) {
                ZkStateReader.this.removeDocCollectionWatcher(this.collectionName, this);
            }
            return result;
        }
    }

    private class CacheCleaner
    implements Runnable {
        private CacheCleaner() {
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                ZkStateReader.this.watchedCollectionProps.entrySet().removeIf(entry -> ((VersionedCollectionProps)entry.getValue()).cacheUntilNs < System.nanoTime() && !ZkStateReader.this.collectionPropsObservers.containsKey(entry.getKey()));
            }
        }
    }

    private class PropsNotification
    implements Runnable {
        private final String collection;
        private final Map<String, String> collectionProperties;
        private final List<CollectionPropsWatcher> watchers = new ArrayList<CollectionPropsWatcher>();

        private PropsNotification(String collection, Map<String, String> collectionProperties) {
            this.collection = collection;
            this.collectionProperties = collectionProperties;
            ZkStateReader.this.collectionPropsObservers.compute(collection, (k, v) -> {
                if (v == null) {
                    return null;
                }
                this.watchers.addAll(v.stateWatchers);
                return v;
            });
        }

        @Override
        public void run() {
            for (CollectionPropsWatcher watcher : this.watchers) {
                if (!watcher.onStateChanged(this.collectionProperties)) continue;
                ZkStateReader.this.removeCollectionPropsWatcher(this.collection, watcher);
            }
        }
    }

    public class AliasesManager
    implements Watcher {
        private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        private volatile Aliases aliases = Aliases.EMPTY;

        public Aliases getAliases() {
            return this.aliases;
        }

        public void applyModificationAndExportToZk(UnaryOperator<Aliases> op) {
            if (this.aliases.getZNodeVersion() == -1) {
                try {
                    boolean updated = this.update();
                    assert (updated);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, e.toString(), e);
                }
                catch (KeeperException e) {
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, e.toString(), e);
                }
            }
            long deadlineNanos = System.nanoTime() + TimeUnit.SECONDS.toNanos(30L);
            for (int triesLeft = 30; triesLeft > 0; --triesLeft) {
                Aliases curAliases = this.getAliases();
                Aliases modAliases = (Aliases)op.apply(curAliases);
                byte[] modAliasesJson = modAliases.toJSON();
                if (curAliases == modAliases) {
                    this.log.debug("Current aliases has the desired modification; no further ZK interaction needed.");
                    return;
                }
                try {
                    try {
                        Stat stat = ZkStateReader.this.getZkClient().setData(ZkStateReader.ALIASES, modAliasesJson, curAliases.getZNodeVersion(), true);
                        this.setIfNewer(Aliases.fromJSON((byte[])modAliasesJson, (int)stat.getVersion()));
                        return;
                    }
                    catch (KeeperException.BadVersionException e) {
                        this.log.debug("{}", (Object)e, (Object)e);
                        this.log.warn("Couldn't save aliases due to race with another modification; will update and retry until timeout");
                        this.update();
                        if (deadlineNanos >= System.nanoTime()) continue;
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Timed out trying to update aliases! Either zookeeper or this node may be overloaded.");
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, e.toString(), e);
                }
                catch (KeeperException e) {
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, e.toString(), e);
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Too many successive version failures trying to update aliases");
        }

        public boolean update() throws KeeperException, InterruptedException {
            this.log.debug("Checking ZK for most up to date Aliases {}", (Object)ZkStateReader.ALIASES);
            ZkStateReader.this.zkClient.getZooKeeper().sync(ZkStateReader.ALIASES, null, null);
            Stat stat = new Stat();
            byte[] data = ZkStateReader.this.zkClient.getData(ZkStateReader.ALIASES, null, stat, true);
            return this.setIfNewer(Aliases.fromJSON((byte[])data, (int)stat.getVersion()));
        }

        public void process(WatchedEvent event) {
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            try {
                this.log.debug("Aliases: updating");
                Stat stat = new Stat();
                byte[] data = ZkStateReader.this.zkClient.getData(ZkStateReader.ALIASES, this, stat, true);
                this.setIfNewer(Aliases.fromJSON((byte[])data, (int)stat.getVersion()));
            }
            catch (KeeperException.NoNodeException stat) {
            }
            catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException e) {
                this.log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK: ", e);
            }
            catch (KeeperException e) {
                this.log.error("A ZK error has occurred", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A ZK error has occurred", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.log.warn("Interrupted", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean setIfNewer(Aliases newAliases) {
            assert (newAliases.getZNodeVersion() >= 0);
            AliasesManager aliasesManager = this;
            synchronized (aliasesManager) {
                int cmp = Integer.compare(this.aliases.getZNodeVersion(), newAliases.getZNodeVersion());
                if (cmp < 0) {
                    this.log.debug("Aliases: cmp={}, new definition is: {}", (Object)cmp, (Object)newAliases);
                    this.aliases = newAliases;
                    this.notifyAll();
                    return true;
                }
                this.log.debug("Aliases: cmp={}, not overwriting ZK version.", (Object)cmp);
                assert (cmp != 0 || Arrays.equals(this.aliases.toJSON(), newAliases.toJSON())) : this.aliases + " != " + newAliases;
                return false;
            }
        }
    }

    private class Notification
    implements Runnable {
        final String collection;
        final DocCollection collectionState;

        private Notification(String collection, DocCollection collectionState) {
            this.collection = collection;
            this.collectionState = collectionState;
        }

        @Override
        public void run() {
            ArrayList watchers = new ArrayList();
            ZkStateReader.this.collectionWatches.compute(this.collection, (k, v) -> {
                if (v == null) {
                    return null;
                }
                watchers.addAll(v.stateWatchers);
                return v;
            });
            for (DocCollectionWatcher watcher : watchers) {
                try {
                    if (!watcher.onStateChanged(this.collectionState)) continue;
                    ZkStateReader.this.removeDocCollectionWatcher(this.collection, watcher);
                }
                catch (Exception exception) {
                    log.warn("Error on calling watcher", (Throwable)exception);
                }
            }
        }
    }

    public static class ConfigData {
        public Map<String, Object> data;
        public int version;

        public ConfigData() {
        }

        public ConfigData(Map<String, Object> data, int version) {
            this.data = data;
            this.version = version;
        }
    }

    class LiveNodeWatcher
    implements Watcher {
        LiveNodeWatcher() {
        }

        public void process(WatchedEvent event) {
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("A live node change: [{}], has occurred - updating... (live nodes size: [{}])", (Object)event, (Object)ZkStateReader.this.liveNodes.size());
            }
            this.refreshAndWatch();
        }

        public void refreshAndWatch() {
            try {
                ZkStateReader.this.refreshLiveNodes(this);
            }
            catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException e) {
                log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK: ", e);
            }
            catch (KeeperException e) {
                log.error("A ZK error has occurred", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A ZK error has occurred", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Interrupted", (Throwable)e);
            }
        }
    }

    class CollectionsChildWatcher
    implements Watcher {
        CollectionsChildWatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            if (ZkStateReader.this.closed) {
                return;
            }
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            log.debug("A collections change: [{}], has occurred - updating...", (Object)event);
            this.refreshAndWatch();
            Object object = ZkStateReader.this.getUpdateLock();
            synchronized (object) {
                ZkStateReader.this.constructState(Collections.emptySet());
            }
        }

        public void refreshAndWatch() {
            try {
                ZkStateReader.this.refreshCollectionList(this);
            }
            catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException e) {
                log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK: ", e);
            }
            catch (KeeperException e) {
                log.error("A ZK error has occurred", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A ZK error has occurred", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Interrupted", (Throwable)e);
            }
        }
    }

    class PropsWatcher
    implements Watcher {
        private final String coll;
        private long watchUntilNs;

        PropsWatcher(String coll) {
            this.coll = coll;
            this.watchUntilNs = 0L;
        }

        PropsWatcher(String coll, long forMillis) {
            this.coll = coll;
            this.watchUntilNs = System.nanoTime() + TimeUnit.NANOSECONDS.convert(forMillis, TimeUnit.MILLISECONDS);
        }

        public PropsWatcher renew(long forMillis) {
            this.watchUntilNs = System.nanoTime() + TimeUnit.NANOSECONDS.convert(forMillis, TimeUnit.MILLISECONDS);
            return this;
        }

        public void process(WatchedEvent event) {
            boolean expired;
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            boolean bl = expired = System.nanoTime() > this.watchUntilNs;
            if (!ZkStateReader.this.collectionPropsObservers.containsKey(this.coll) && expired) {
                log.debug("Ignoring property change for collection {}", (Object)this.coll);
                return;
            }
            log.info("A collection property change: [{}] for collection [{}] has occurred - updating...", (Object)event, (Object)this.coll);
            this.refreshAndWatch(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void refreshAndWatch(boolean notifyWatchers) {
            try {
                ConcurrentHashMap<String, VersionedCollectionProps> concurrentHashMap = ZkStateReader.this.watchedCollectionProps;
                synchronized (concurrentHashMap) {
                    VersionedCollectionProps vcp = ZkStateReader.this.fetchCollectionProperties(this.coll, this);
                    Map<String, String> properties = vcp.props;
                    VersionedCollectionProps existingVcp = ZkStateReader.this.watchedCollectionProps.get(this.coll);
                    if (existingVcp == null || vcp.zkVersion > existingVcp.zkVersion || vcp.zkVersion == -1) {
                        ZkStateReader.this.watchedCollectionProps.put(this.coll, vcp);
                        if (notifyWatchers) {
                            ZkStateReader.this.notifyPropsWatchers(this.coll, properties);
                        }
                        if (vcp.zkVersion == -1 && existingVcp != null) {
                            ZkStateReader.this.watchedCollectionProps.remove(this.coll);
                            ZkStateReader.this.collectionPropsObservers.remove(this.coll);
                            ZkStateReader.this.collectionPropsWatchers.remove(this.coll);
                        }
                    }
                }
            }
            catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException e) {
                log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK: ", e);
            }
            catch (KeeperException e) {
                log.error("Lost collection property watcher for {} due to ZK error", (Object)this.coll, (Object)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A ZK error has occurred", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("Lost collection property watcher for {} due to the thread being interrupted", (Object)this.coll, (Object)e);
            }
        }
    }

    class StateWatcher
    implements Watcher {
        private final String coll;
        private final String collectionPath;

        StateWatcher(String coll) {
            this.coll = coll;
            this.collectionPath = DocCollection.getCollectionPath((String)coll);
        }

        public void process(WatchedEvent event) {
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            if (!ZkStateReader.this.collectionWatches.watchedCollections().contains(this.coll)) {
                log.debug("Uninteresting collection {}", (Object)this.coll);
                return;
            }
            SortedSet<String> liveNodes = ZkStateReader.this.liveNodes;
            if (log.isInfoEnabled()) {
                log.info("A cluster state change: [{}] for collection [{}] has occurred - updating... (live nodes size: [{}])", new Object[]{event, this.coll, liveNodes.size()});
            }
            this.refreshAndWatch(event.getType());
        }

        public void refreshAndWatch() {
            this.refreshAndWatch(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshAndWatch(Watcher.Event.EventType eventType) {
            try {
                if (eventType == null || eventType == Watcher.Event.EventType.NodeChildrenChanged) {
                    this.refreshAndWatchChildren();
                    if (eventType == Watcher.Event.EventType.NodeChildrenChanged) {
                        return;
                    }
                }
                DocCollection newState = ZkStateReader.this.fetchCollectionState(this.coll, this);
                ZkStateReader.this.collectionWatches.updateDocCollection(this.coll, newState);
                Object object = ZkStateReader.this.getUpdateLock();
                synchronized (object) {
                    ZkStateReader.this.constructState(Collections.singleton(this.coll));
                }
            }
            catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException e) {
                log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK: ", e);
            }
            catch (KeeperException e) {
                log.error("Unwatched collection: [{}]", (Object)this.coll, (Object)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A ZK error has occurred", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("Unwatched collection: [{}]", (Object)this.coll, (Object)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshAndWatchChildren() throws KeeperException, InterruptedException {
            Stat stat = new Stat();
            List<String> replicaStates = null;
            try {
                replicaStates = ZkStateReader.this.zkClient.getChildren(this.collectionPath, this, stat, true);
                PerReplicaStates newStates = new PerReplicaStates(this.collectionPath, stat.getCversion(), replicaStates);
                DocCollection oldState = ZkStateReader.this.collectionWatches.getDocCollection(this.coll);
                DocCollection newState = oldState != null ? oldState.copyWith(newStates) : ZkStateReader.this.fetchCollectionState(this.coll, null);
                ZkStateReader.this.collectionWatches.updateDocCollection(this.coll, newState);
                Object object = ZkStateReader.this.getUpdateLock();
                synchronized (object) {
                    ZkStateReader.this.constructState(Collections.singleton(this.coll));
                }
                if (log.isDebugEnabled()) {
                    log.debug("updated per-replica states changed for: {}, ver: {} , new vals: {}", new Object[]{this.coll, stat.getCversion(), replicaStates});
                }
            }
            catch (KeeperException.NoNodeException e) {
                log.info("{} is deleted, stop watching children", (Object)this.collectionPath);
            }
        }
    }

    private class VersionedCollectionProps {
        int zkVersion;
        Map<String, String> props;
        long cacheUntilNs = 0L;

        VersionedCollectionProps(int zkVersion, Map<String, String> props) {
            this.zkVersion = zkVersion;
            this.props = props;
        }
    }

    private class LazyCollectionRef
    extends ClusterState.CollectionRef {
        private final String collName;
        private volatile long lastUpdateTime;
        private DocCollection cachedDocCollection;

        public LazyCollectionRef(String collName) {
            super(null);
            this.collName = collName;
            this.lastUpdateTime = -1L;
        }

        public synchronized DocCollection get(boolean allowCached) {
            this.gets.incrementAndGet();
            if (!allowCached || this.lastUpdateTime < 0L || System.nanoTime() - this.lastUpdateTime > LAZY_CACHE_TIME) {
                boolean shouldFetch = true;
                if (this.cachedDocCollection != null) {
                    Stat freshStats = null;
                    try {
                        freshStats = ZkStateReader.this.zkClient.exists(DocCollection.getCollectionPath((String)this.collName), null, true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (freshStats != null && !this.cachedDocCollection.isModified(freshStats.getVersion(), freshStats.getCversion())) {
                        shouldFetch = false;
                    }
                }
                if (shouldFetch) {
                    this.cachedDocCollection = ZkStateReader.this.getCollectionLive(this.collName);
                    this.lastUpdateTime = System.nanoTime();
                }
            }
            return this.cachedDocCollection;
        }

        public boolean isLazilyLoaded() {
            return true;
        }

        public String toString() {
            return "LazyCollectionRef(" + this.collName + ")";
        }
    }

    private static class StatefulCollectionWatch
    extends CollectionWatch<DocCollectionWatcher> {
        private DocCollection currentState;

        private StatefulCollectionWatch() {
        }
    }

    private static class DocCollectionWatches {
        private final ConcurrentHashMap<String, StatefulCollectionWatch> statefulWatchesByCollectionName = new ConcurrentHashMap();

        private DocCollectionWatches() {
        }

        private DocCollection getDocCollection(String collection) {
            StatefulCollectionWatch watch = this.statefulWatchesByCollectionName.get(collection);
            return watch != null ? watch.currentState : null;
        }

        private Set<String> activeCollections() {
            return this.statefulWatchesByCollectionName.entrySet().stream().filter(entry -> ((StatefulCollectionWatch)entry.getValue()).currentState != null).map(Map.Entry::getKey).collect(Collectors.toUnmodifiableSet());
        }

        private long activeCollectionCount() {
            return this.statefulWatchesByCollectionName.entrySet().stream().filter(entry -> ((StatefulCollectionWatch)entry.getValue()).currentState != null).count();
        }

        private Set<String> watchedCollections() {
            return Collections.unmodifiableSet(this.statefulWatchesByCollectionName.keySet());
        }

        private Set<Map.Entry<String, StatefulCollectionWatch>> watchedCollectionEntries() {
            return Collections.unmodifiableSet(this.statefulWatchesByCollectionName.entrySet());
        }

        private boolean updateDocCollection(String collection, DocCollection newState) {
            AtomicBoolean stateHasChanged = new AtomicBoolean(false);
            this.statefulWatchesByCollectionName.computeIfPresent(collection, (col, watch) -> {
                DocCollection oldState = watch.currentState;
                if (oldState != null || newState != null) {
                    if (oldState == null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Add data for [{}] ver [{}]", (Object)collection, (Object)newState.getZNodeVersion());
                        }
                        watch.currentState = newState;
                    } else if (newState == null) {
                        log.debug("Removing cached collection state for [{}]", (Object)collection);
                        watch.currentState = null;
                    } else {
                        int newCVersion;
                        int oldCVersion = oldState.getPerReplicaStates() == null ? -1 : oldState.getPerReplicaStates().cversion;
                        int n = newCVersion = newState.getPerReplicaStates() == null ? -1 : newState.getPerReplicaStates().cversion;
                        if (oldState.getZNodeVersion() < newState.getZNodeVersion() || oldCVersion < newCVersion) {
                            watch.currentState = newState;
                            if (log.isDebugEnabled()) {
                                log.debug("Updating data for [{}] from [{}] to [{}]", new Object[]{collection, oldState.getZNodeVersion(), newState.getZNodeVersion()});
                            }
                        }
                    }
                }
                stateHasChanged.set(oldState != watch.currentState);
                return watch;
            });
            return stateHasChanged.get();
        }

        private StatefulCollectionWatch compute(String collectionName, BiFunction<String, StatefulCollectionWatch, StatefulCollectionWatch> remappingFunction) {
            return this.statefulWatchesByCollectionName.compute(collectionName, remappingFunction);
        }
    }

    private static class CollectionWatch<T> {
        int coreRefCount = 0;
        Set<T> stateWatchers = ConcurrentHashMap.newKeySet();

        private CollectionWatch() {
        }

        public boolean canBeRemoved() {
            return this.coreRefCount + this.stateWatchers.size() == 0;
        }
    }
}

