/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.coreit;

import java.net.URL;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;

public class ReachableMojo
extends AbstractMojo {
    private String resource;

    public void execute() throws MojoFailureException {
        if (!this.reach(true) || !this.reach(false)) {
            throw new MojoFailureException((Object)this, "Resource reachability test failed..", "Failed to reach resource: " + this.resource + " using one or more methods.");
        }
    }

    public boolean reach(boolean useContextClassloader) throws MojoFailureException {
        ClassLoader cl = useContextClassloader ? Thread.currentThread().getContextClassLoader() : ((Object)((Object)this)).getClass().getClassLoader();
        URL result = cl.getResource(this.resource);
        this.getLog().info((CharSequence)("Attepting to reach: " + this.resource + " from: " + cl + (useContextClassloader ? " (context classloader)" : "") + (result == null ? ": FAILED" : ":SUCCEEDED")));
        if (result == null) {
            this.getLog().info((CharSequence)("Cannot find resource: " + this.resource + (useContextClassloader ? " in context classloader" : "")));
            return false;
        }
        return true;
    }
}

