/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.cli;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.cli.Options;
import org.apache.maven.api.cli.ParserRequest;
import org.apache.maven.api.cli.extensions.CoreExtension;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.api.services.MessageBuilderFactory;

@Immutable
@Experimental
public interface InvokerRequest {
    @Nonnull
    public ParserRequest parserRequest();

    public boolean parsingFailed();

    default public boolean embedded() {
        return this.parserRequest().embedded();
    }

    @Nonnull
    public Path cwd();

    @Nonnull
    public Path installationDirectory();

    @Nonnull
    public Path userHomeDirectory();

    default public MessageBuilderFactory messageBuilderFactory() {
        return this.parserRequest().messageBuilderFactory();
    }

    default public Lookup lookup() {
        return this.parserRequest().lookup();
    }

    @Nonnull
    public Map<String, String> userProperties();

    @Nonnull
    public Map<String, String> systemProperties();

    @Nonnull
    public Path topDirectory();

    @Nonnull
    public Optional<Path> rootDirectory();

    @Nonnull
    default public Optional<InputStream> stdIn() {
        return Optional.ofNullable(this.parserRequest().stdIn());
    }

    @Nonnull
    default public Optional<OutputStream> stdOut() {
        return Optional.ofNullable(this.parserRequest().stdOut());
    }

    @Nonnull
    default public Optional<OutputStream> stdErr() {
        return Optional.ofNullable(this.parserRequest().stdErr());
    }

    @Nonnull
    public Optional<List<CoreExtension>> coreExtensions();

    @Nonnull
    public Options options();
}

