/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.util.Objects;
import org.apache.maven.api.ProtoSession;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.services.Request;
import org.apache.maven.api.services.RequestTrace;

@Experimental
abstract class BaseRequest<S extends ProtoSession>
implements Request<S> {
    private final S session;
    private final RequestTrace trace;

    protected BaseRequest(@Nonnull S session) {
        this(session, null);
    }

    protected BaseRequest(@Nonnull S session, RequestTrace trace) {
        this.session = (ProtoSession)Objects.requireNonNull(session, "session cannot be null");
        this.trace = trace;
    }

    @Override
    @Nonnull
    public S getSession() {
        return this.session;
    }

    @Override
    public RequestTrace getTrace() {
        return this.trace;
    }
}

