/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.apache.ftpserver.DataConnectionConfiguration;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.apache.ftpserver.util.IllegalInetAddressException;
import org.apache.ftpserver.util.IllegalPortException;
import org.apache.ftpserver.util.SocketAddressEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PORT
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(PORT.class);

    @Override
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException {
        InetSocketAddress address;
        session.resetState();
        if (!request.hasArgument()) {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 501, "PORT", null));
            return;
        }
        DataConnectionConfiguration dataCfg = session.getListener().getDataConnectionConfiguration();
        if (!dataCfg.isActiveEnabled()) {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 501, "PORT.disabled", null));
            return;
        }
        try {
            address = SocketAddressEncoder.decode(request.getArgument());
            if (address.getPort() == 0) {
                throw new IllegalPortException("PORT port must not be 0");
            }
        }
        catch (IllegalInetAddressException e) {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 501, "PORT", null));
            return;
        }
        catch (IllegalPortException e) {
            this.LOG.debug("Invalid data port: " + request.getArgument(), (Throwable)e);
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 501, "PORT.invalid", null));
            return;
        }
        catch (UnknownHostException e) {
            this.LOG.debug("Unknown host", (Throwable)e);
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 501, "PORT.host", null));
            return;
        }
        if (dataCfg.isActiveIpCheck() && session.getRemoteAddress() instanceof InetSocketAddress) {
            InetAddress clientAddr = ((InetSocketAddress)session.getRemoteAddress()).getAddress();
            if (!address.getAddress().equals(clientAddr)) {
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 501, "PORT.mismatch", null));
                return;
            }
        }
        session.getDataConnection().initActiveDataConnection(address);
        session.write((Object)LocalizedFtpReply.translate(session, request, context, 200, "PORT", null));
    }
}

