/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.spring.integration;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.common.SftpException;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.util.FileCopyUtils;

public class SpringSftpSession
extends AbstractLoggingBean
implements Session<SftpClient.DirEntry> {
    private final SftpClient sftpClient;
    private final Callable<Exception> sessionCloser;

    public SpringSftpSession(SftpClient clientInstance) {
        this(clientInstance, () -> null);
    }

    public SpringSftpSession(SftpClient clientInstance, Callable<Exception> sessionCloser) {
        this.sftpClient = Objects.requireNonNull(clientInstance, "No SFTP client instance");
        this.sessionCloser = sessionCloser;
    }

    public String getHostPort() {
        SocketAddress peerAddress;
        SftpClient client = this.getClientInstance();
        ClientSession session = client == null ? null : client.getSession();
        IoSession ioSession = session == null ? null : session.getIoSession();
        SocketAddress socketAddress = peerAddress = ioSession == null ? null : ioSession.getRemoteAddress();
        if (peerAddress instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)peerAddress;
            return inetAddress.getHostString() + ":" + inetAddress.getPort();
        }
        if (peerAddress instanceof SshdSocketAddress) {
            SshdSocketAddress sshdAddress = (SshdSocketAddress)peerAddress;
            return sshdAddress.getHostName() + ":" + sshdAddress.getPort();
        }
        return Objects.toString(peerAddress, null);
    }

    public boolean isOpen() {
        SftpClient client = this.getClientInstance();
        return client.isOpen();
    }

    public SftpClient getClientInstance() {
        return this.sftpClient;
    }

    public Callable<Exception> getSessionCloser() {
        return this.sessionCloser;
    }

    public void close() {
        Exception err = null;
        try {
            SftpClient client = this.getClientInstance();
            this.closeClientInstance(client);
        }
        catch (Exception e) {
            err = (Exception)ExceptionUtils.accumulateException(err, (Throwable)e);
        }
        try {
            this.closeSessionInstance(this.getSessionCloser());
        }
        catch (Exception e) {
            err = (Exception)ExceptionUtils.accumulateException((Throwable)err, (Throwable)e);
        }
        if (err != null) {
            throw ExceptionUtils.toRuntimeException((Throwable)err);
        }
    }

    protected void closeClientInstance(SftpClient client) throws Exception {
        if (client.isOpen()) {
            client.close();
        }
    }

    protected void closeSessionInstance(Callable<Exception> closer) throws Exception {
        Exception err;
        if (closer == null) {
            return;
        }
        try {
            err = closer.call();
        }
        catch (Exception e) {
            err = e;
        }
        if (err != null) {
            throw err;
        }
    }

    public boolean remove(String path) throws IOException {
        SftpClient client = this.getClientInstance();
        if (this.log.isDebugEnabled()) {
            this.log.debug("remove({})[{}]", (Object)client, (Object)path);
        }
        client.remove(path);
        return true;
    }

    public boolean mkdir(String directory) throws IOException {
        SftpClient client = this.getClientInstance();
        if (this.log.isDebugEnabled()) {
            this.log.debug("mkdir({})[{}]", (Object)client, (Object)directory);
        }
        client.mkdir(directory);
        return true;
    }

    public boolean rmdir(String directory) throws IOException {
        SftpClient client = this.getClientInstance();
        if (this.log.isDebugEnabled()) {
            this.log.debug("rmdir({})[{}]", (Object)client, (Object)directory);
        }
        client.rmdir(directory);
        return true;
    }

    public void rename(String pathFrom, String pathTo) throws IOException {
        SftpClient client = this.getClientInstance();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (this.exists(pathTo)) {
            if (debugEnabled) {
                this.log.debug("rename({})[{} => {}] target exists - attempting to remove", new Object[]{client, pathFrom, pathTo});
            }
            this.remove(pathTo);
        }
        if (debugEnabled) {
            this.log.debug("rename({})[{} => {}] renaming", new Object[]{client, pathFrom, pathTo});
        }
        client.rename(pathFrom, pathTo);
    }

    public boolean exists(String path) throws IOException {
        SftpClient client = this.getClientInstance();
        try {
            SftpClient.Attributes attrs = client.lstat(path);
            return attrs != null;
        }
        catch (SftpException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("exists({})[{}]: {} - {}", new Object[]{client, path, e.getStatus(), e.getMessage()});
            }
            return false;
        }
    }

    public String[] listNames(String path) throws IOException {
        Object[] entries = this.list(path);
        if (GenericUtils.isEmpty((Object[])entries)) {
            return GenericUtils.EMPTY_STRING_ARRAY;
        }
        LinkedList<String> names = new LinkedList<String>();
        for (int index = 0; index < entries.length; ++index) {
            String n;
            Object de = entries[index];
            SftpClient.Attributes attrs = de.getAttributes();
            if (!attrs.isRegularFile() || attrs.isSymbolicLink() || ".".equals(n = de.getFilename()) || "..".equals(n)) continue;
            names.add(n);
        }
        if (GenericUtils.isEmpty(names)) {
            return GenericUtils.EMPTY_STRING_ARRAY;
        }
        return names.toArray(new String[names.size()]);
    }

    public SftpClient.DirEntry[] list(String path) throws IOException {
        SftpClient client = this.getClientInstance();
        Iterable entries = client.readDir(path);
        Collection result = GenericUtils.stream((Iterable)entries).collect(Collectors.toCollection(LinkedList::new));
        if (GenericUtils.isEmpty((Collection)result)) {
            return SftpClient.EMPTY_DIR_ENTRIES;
        }
        return result.toArray(new SftpClient.DirEntry[result.size()]);
    }

    public void read(String source, OutputStream outputStream) throws IOException {
        SftpClient client = this.getClientInstance();
        try (InputStream inputStream = client.read(source);){
            FileCopyUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
    }

    public void write(InputStream inputStream, String destination) throws IOException {
        SftpClient client = this.getClientInstance();
        try (OutputStream outputStream = client.write(destination);){
            FileCopyUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
    }

    public void append(InputStream inputStream, String destination) throws IOException {
        SftpClient client = this.getClientInstance();
        try (OutputStream outputStream = client.write(destination, new SftpClient.OpenMode[]{SftpClient.OpenMode.Append});){
            FileCopyUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
    }

    public InputStream readRaw(String source) throws IOException {
        SftpClient client = this.getClientInstance();
        return client.read(source);
    }

    public boolean finalizeRaw() throws IOException {
        return true;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.getClientInstance() + "]";
    }
}

